/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.api.keyinfo;

import com.sun.xml.ws.security.opt.api.EncryptedKey;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import java.security.Key;

/**
 * 
 * Class to store results from TokenBuilder. Stores the various key information
 * @author K.Venugopal@sun.com
 */
public class BuilderResult {
    private Key dataProtectionKey = null;
    private Key keyProtectionKey = null;
    private KeyInfo keyInfo = null;
    private EncryptedKey encryptedKey = null;
    private String dpKID = "";
    /** Creates a new instance of BuilderResult */
    public BuilderResult() {
    }

    /**
     * 
     * @return the data protection key
     */
    public Key getDataProtectionKey() {
        return dataProtectionKey;
    }

    /**
     * 
     * @param dataProtectionKey set the data protection key
     */
    public void setDataProtectionKey(final Key dataProtectionKey) {
        this.dataProtectionKey = dataProtectionKey;
    }

    /**
     * 
     * @return the key protection key
     */
    public Key getKeyProtectionKey() {
        return keyProtectionKey;
    }

    /**
     * 
     * @param keyProtectionKey store the key protection key
     */
    public void setKeyProtectionKey(final Key keyProtectionKey) {
        this.keyProtectionKey = keyProtectionKey;
    }

    /**
     * 
     * @return the stored keyInfo
     */
    public KeyInfo getKeyInfo() {
        return keyInfo;
    }

    /**
     * 
     * @param keyInfo store the keyInfo from <CODE>TokenBuilder</CODE>
     */
    public void setKeyInfo(final KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    /**
     * 
     * @return the encryptedKey
     */
    public EncryptedKey getEncryptedKey() {
        return encryptedKey;
    }

    /**
     * 
     * @param encryptedKey store the encryptedKey for Signature or Encryption
     */
    public void setEncryptedKey(final EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }
    
    public void setDPTokenId(final String id){
        this.dpKID = id;
    }
    
    public String getDPTokenId(){
        return dpKID;
    }
}
