/*
 * BinarySecurityToken.java
 *
 * Created on August 2, 2006, 10:37 AM
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */


package com.sun.xml.ws.security.opt.api.keyinfo;

/**
 * Represents binary-formatted security tokens
 * @author K.Venugopal@sun.com
 */
public interface BinarySecurityToken extends Token{
    /*
     * The ValueType attribute is used to indicate the "value space" of the encoded binary
     * data (e.g. an X.509 certificate). The ValueType attribute allows a URI that defines the
     * value type and space of the encoded binary data.
     */
    String getValueType();
    /*
     * BinarySecurityToken/@EncodingType
     * The EncodingType attribute is used to indicate, using a URI, the encoding format of the
     * binary data (e.g., base64 encoded). A new attribute is introduced, as there are issues
     * with the current schema validation tools that make derivations of mixed simple and
     * complex types difficult within XML Schema. The EncodingType attribute is interpreted
     * to indicate the encoding format of the element.
     */
    String getEncodingType();
    
    /*
     * returns contents of the BinarySecurityToken
     */
    byte[] getTokenValue();
    
}
