/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.impl.kerberos;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

/**
 *
 * @author Ashutosh.Shahi@sun.com
 */
public class KerberosContext {
    
    private GSSContext context = null;
    private byte[] kerberosToken = null;
    private byte[] secretKey = null;
    private SecretKey sKey = null;
    private boolean setOnce = false; 
    
    /** Creates a new instance of KerberosContext */
    public KerberosContext() {
    }
    
    public void setOnce(boolean setOnce){
        this.setOnce = setOnce;
    }
    
    public boolean setOnce(){
        return setOnce;
    }
    
    public void setGSSContext(GSSContext context){
        this.context = context;
    }
    
    public GSSContext getGSSContext(){
        return context;
    }
    
    public void setKerberosToken(byte[] token){
        kerberosToken = token;
    }
    
    public byte[] getKerberosToken(){
        return kerberosToken;
    }
    
    public void setSecretKey(byte[] secretKey){
        this.secretKey = secretKey;
    }
    
    public SecretKey getSecretKey(String algorithm){
        if(sKey == null){
            sKey = new SecretKeySpec(secretKey, algorithm);
        }
        return sKey;
    }
    
    public GSSCredential getDelegatedCredentials() throws GSSException{
        if(context != null && context.getCredDelegState()){
            return context.getDelegCred();
        }
        
        return null;
    }
}
