/*
 * SecurityCredential.java
 *
 * Created on August 21, 2007, 2:55 PM
 *
 *
 */

package com.sun.xml.ws.security;

import java.security.Principal;
import java.util.Properties;
import javax.xml.namespace.QName;

/**
 * A Holder class for representing Security Tokens stored in a JAVA Subject
 * The intent is that Authentication modules that need to use tokens/Keys acquired from different sources
 * using different  Public/Proprietary API's can make use of the Java Subject 
 * (possibly the one associated with AccessControlContext) as a Central Repository. 
 * This would make the authentication modules independent of the API's to be used for Token acquisition
 *
 * Authentication Modules would also need to populate Credentials from an incoming Secure Message into a 
 * common repository. The populated credentials can then be used to set the subject's disthinguished Principal(s)
 * by passing the Subject to a Container CallbackHandler ?. 
 *
 * A SecurityCredential can either be used as a Public Credential or a PrivateCredential under the Subject.
 *
 */
public interface SecurityCredential<T> {
     
     /**
      *@return the Security Token represented by this Credential
      */
     public T getToken();
     
     /**
      *@return a Map of Properties/Attributes of this SecurityCredential
      * NOTE: These properties are application/domain specific and may or maynot be directly  Representable 
      * in the underlying Security Token itself
      * For Eg: When handling WS-SecurityPolicy we may want to disthinguish Primary X509Token from an
      * Endorsing X509Token.
      */
     public Properties getTokenProperties();
     
     /**
      *@return the TokenType of this Security Credential
      *NOTE: This method is necessary since the T.class in itself may or maynot be 
      *sufficient to determine the type of the token. Especially if T is not a Standard
      *JAVA Type (i.e an Application Specific Class)
      */
     public QName getTokenType();
     
     /**
      *@return a Principal(SubClass) that uniquely represents the Credentials in the Token
      *For Eg: A SAML Token may be represented as a SecurityCredential, 
      * and the Subject Statement (NameIdentifier) or AttributeValue of an Attribute Statement
      * inside the SAML assertion would serve as a Principal.
      *
      *This method may be used by the CallerPrincipal and GroupPrincipal callback implementations
      *if they wish to.  
      *
      *A Particular SecurityCredential implementation may choose to throw UnSupportedOperationException
      *when this methos is invoked on them.
      *
      *@See SecurityPrincipal<T>
      */
     public Principal getPrincipal();
}


