/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security;

import java.util.Date;
import java.util.Set;

/**
 * The </code>SecurityContextTokenInfo</code> class represents security parameters
 * which will be saved in the <code>Session</code> object so that whenever the endpoint
 * crashes the security negotiations can be resumed from its original state and no new 
 * negotiations need to be done.
 *
 */
public interface SecurityContextTokenInfo {

    String getIdentifier();

    void setIdentifier(String identifier);

    String getExternalId();

    void setExternalId(String externalId);
    
    String getInstance();

    void setInstance(String instance);
    
    byte[] getSecret();

    byte[] getInstanceSecret(String instance);

    void addInstance(String instance, byte[] key);

    Date getCreationTime();

    void setCreationTime(Date creationTime);

    Date getExpirationTime();

    void setExpirationTime(Date expirationTime);
    
    Set getInstanceKeys();

    IssuedTokenContext getIssuedTokenContext();

    IssuedTokenContext getIssuedTokenContext(SecurityTokenReference reference);
        
}
