/*
 * SCVAdapter.java
 *
 * Created on August 9, 2006, 2:47 PM
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.security.core.xenc;
import com.sun.xml.ws.security.opt.impl.util.CVDataContentHandlerFactory;
import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.activation.DataHandler;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class CVAdapter extends XmlAdapter<DataHandler,byte[]>{
    
    static{
//        DataHandler.setDataContentHandlerFactory(new CVDataContentHandlerFactory());
        
        CommandMap map = CommandMap.getDefaultCommandMap();
        if (map instanceof MailcapCommandMap) {
            MailcapCommandMap mailMap = (MailcapCommandMap) map;            
            mailMap.addMailcap("application/ciphervalue"+";;x-java-content-handler="+"com.sun.xml.ws.security.opt.impl.util.CVDataHandler");
        }        
    }
    
    private CryptoProcessor cp;
    
    public CVAdapter(){
    }
    
    public CVAdapter(CryptoProcessor cp){
        this.cp = cp;
    }
    
    public DataHandler marshal(byte[] value){
        return new DataHandler(cp,"application/ciphervalue");
    }
    
    public byte[] unmarshal(DataHandler dh){
        throw new UnsupportedOperationException();
    }
    
}
