/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.keyinfo;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.SamlKeyIdentifier;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.keyinfo.KeyInfoStrategy;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class KeyIdentifierStrategy
extends KeyInfoStrategy {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    X509Certificate cert = null;
    String alias = null;
    boolean forSigning;
    String samlAssertionId = null;

    public KeyIdentifierStrategy() {
    }

    public KeyIdentifierStrategy(String samlAssertionId) {
        this.samlAssertionId = samlAssertionId;
        this.forSigning = false;
    }

    public KeyIdentifierStrategy(String alias, boolean forSigning) {
        this.alias = alias;
        this.forSigning = forSigning;
    }

    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = this.getKeyIdentifier(secureMsg);
        if (keyIdentifier == null) {
            log.log(Level.SEVERE, "WSS0701.cannot.locate.certificate", this.alias);
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + this.alias + "'");
        }
        tokenRef.setReference(keyIdentifier);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = this.getKeyIdentifier(secureMsg);
        if (keyIdentifier == null) {
            log.log(Level.SEVERE, "WSS0701.cannot.locate.certificate", this.alias);
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + this.alias + "'");
        }
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        tokenRef.setReference(keyIdentifier);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    private KeyIdentifier getKeyIdentifier(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = null;
        if (this.samlAssertionId != null) {
            keyIdentifier = new SamlKeyIdentifier((Document)secureMsg.getSOAPPart());
            keyIdentifier.setReferenceValue(this.samlAssertionId);
            return keyIdentifier;
        }
        if (this.cert != null) {
            byte[] subjectKeyIdentifier = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(this.cert);
            if (subjectKeyIdentifier == null) {
                log.log(Level.SEVERE, "WSS0702.no.subject.keyidentifier", this.alias);
                throw new XWSSecurityException("The found certificate does not contain subject key identifier X509 extension");
            }
            String keyId = Base64.encode(subjectKeyIdentifier);
            keyIdentifier = new X509SubjectKeyIdentifier((Document)secureMsg.getSOAPPart());
            keyIdentifier.setReferenceValue(keyId);
        }
        return keyIdentifier;
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public String getAlias() {
        return this.alias;
    }
}

