/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.policy.spi.PolicyAssertionCreator;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.LogStringsMessages;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyAssertionCreator
implements PolicyAssertionCreator {
    private static HashSet<String> implementedAssertions = new HashSet();
    private static final String[] nsSupportedList = new String[]{SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri, SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri, "http://schemas.microsoft.com/ws/2005/07/securitypolicy", SecurityPolicyVersion.SECURITYPOLICY200512.namespaceUri};

    public String[] getSupportedDomainNamespaceURIs() {
        return nsSupportedList;
    }

    protected Class getClass(AssertionData assertionData) throws AssertionCreationException {
        String className = "";
        try {
            className = assertionData.getName().getLocalPart();
            if ("CertStore".equals(className)) {
                className = "CertStoreConfig";
            }
            return Class.forName("com.sun.xml.ws.security.impl.policy." + className);
        }
        catch (ClassNotFoundException ex) {
            if (Constants.logger.isLoggable(Level.SEVERE)) {
                Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0110_ERROR_LOCATING_CLASS("com.sun.xml.ws.security.impl.policy" + className), ex);
            }
            throw new AssertionCreationException(assertionData, (Throwable)ex);
        }
    }

    public PolicyAssertion createAssertion(AssertionData assertionData, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative, PolicyAssertionCreator policyAssertionCreator) throws AssertionCreationException {
        String localName = assertionData.getName().getLocalPart();
        if (implementedAssertions.contains(localName)) {
            Class cl = null;
            cl = this.getClass(assertionData);
            Constructor cons = null;
            try {
                cons = this.getConstructor(cl);
            }
            catch (NoSuchMethodException ex) {
                if (Constants.logger.isLoggable(Level.SEVERE)) {
                    Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0111_ERROR_OBTAINING_CONSTRUCTOR(assertionData.getName()), ex);
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
            catch (SecurityException ex) {
                if (Constants.logger.isLoggable(Level.SEVERE)) {
                    Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0111_ERROR_OBTAINING_CONSTRUCTOR(assertionData.getName()), ex);
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
            if (cons != null) {
                try {
                    return (PolicyAssertion)cons.newInstance(assertionData, nestedAssertions, nestedAlternative);
                }
                catch (IllegalArgumentException ex) {
                    if (Constants.logger.isLoggable(Level.SEVERE)) {
                        Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0112_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    if (Constants.logger.isLoggable(Level.SEVERE)) {
                        Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0112_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
                catch (InstantiationException ex) {
                    if (Constants.logger.isLoggable(Level.SEVERE)) {
                        Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0112_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    if (Constants.logger.isLoggable(Level.SEVERE)) {
                        Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0112_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
            }
            try {
                return (PolicyAssertion)cl.newInstance();
            }
            catch (InstantiationException ex) {
                if (Constants.logger.isLoggable(Level.SEVERE)) {
                    Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0112_ERROR_INSTANTIATING(assertionData.getName()));
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                if (Constants.logger.isLoggable(Level.SEVERE)) {
                    Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0112_ERROR_INSTANTIATING(assertionData.getName()));
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
        }
        return policyAssertionCreator.createAssertion(assertionData, nestedAssertions, nestedAlternative, policyAssertionCreator);
    }

    private Constructor getConstructor(Class cl) throws NoSuchMethodException {
        Constructor<?>[] cList = cl.getConstructors();
        return cl.getConstructor(AssertionData.class, Collection.class, AssertionSet.class);
    }

    static {
        implementedAssertions.add("AlgorithmSuite");
        implementedAssertions.add("AsymmetricBinding");
        implementedAssertions.add("Address");
        implementedAssertions.add("EncryptedElements");
        implementedAssertions.add("EncryptedParts");
        implementedAssertions.add("EncryptionToken");
        implementedAssertions.add("EndorsingSupportingTokens");
        implementedAssertions.add("EndpointReference");
        implementedAssertions.add("Header");
        implementedAssertions.add("HttpsToken");
        implementedAssertions.add("IssuedToken");
        implementedAssertions.add("Issuer");
        implementedAssertions.add("InitiatorToken");
        implementedAssertions.add("KerberosToken");
        implementedAssertions.add("Lifetime");
        implementedAssertions.add("Layout");
        implementedAssertions.add("ProtectionToken");
        implementedAssertions.add("RecipientToken");
        implementedAssertions.add("RelToken");
        implementedAssertions.add("RequestSecurityTokenTemplate");
        implementedAssertions.add("RequiredElements");
        implementedAssertions.add("SamlToken");
        implementedAssertions.add("SecurityContextToken");
        implementedAssertions.add("SecureConversationToken");
        implementedAssertions.add("SignedElements");
        implementedAssertions.add("SignedSupportingTokens");
        implementedAssertions.add("SignedEndorsingSupportingTokens");
        implementedAssertions.add("SignedParts");
        implementedAssertions.add("SpnegoContextToken");
        implementedAssertions.add("SupportingTokens");
        implementedAssertions.add("SignatureToken");
        implementedAssertions.add("SymmetricBinding");
        implementedAssertions.add("TransportBinding");
        implementedAssertions.add("TransportToken");
        implementedAssertions.add("Trust10");
        implementedAssertions.add("UsernameToken");
        implementedAssertions.add("UseKey");
        implementedAssertions.add("Wss10");
        implementedAssertions.add("Wss11");
        implementedAssertions.add("X509Token");
        implementedAssertions.add("KeyStore");
        implementedAssertions.add("TrustStore");
        implementedAssertions.add("CallbackHandler");
        implementedAssertions.add("CallbackHandlerConfiguration");
        implementedAssertions.add("Validator");
        implementedAssertions.add("ValidatorConfiguration");
        implementedAssertions.add("CertStore");
        implementedAssertions.add("KerberosConfig");
        implementedAssertions.add("RsaToken");
        implementedAssertions.add("KeyValueToken");
        implementedAssertions.add("EncryptedSupportingTokens");
        implementedAssertions.add("SignedEncryptedSupportingTokens");
        implementedAssertions.add("SignedEndorsingEncryptedSupportingTokens");
        implementedAssertions.add("EndorsingEncryptedSupportingTokens");
        implementedAssertions.add("Trust13");
        implementedAssertions.add("IssuerName");
        implementedAssertions.add("Claims");
    }
}

