/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InboundSequence
extends AbstractSequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(InboundSequence.class);
    private final Set<Long> unackedMessageIdentifiers = new TreeSet<Long>();

    InboundSequence(String sequenceId, String securityContextTokenId, long expirationTime) {
        super(sequenceId, securityContextTokenId, expirationTime, 0L);
    }

    @Override
    Collection<Long> getUnackedMessageIdStorage() {
        return this.unackedMessageIdentifiers;
    }

    @Override
    public void acknowledgeMessageIds(List<Sequence.AckRange> ranges) throws IllegalMessageIdentifierException, IllegalStateException {
        for (Sequence.AckRange range : ranges) {
            for (long index = range.lower; index <= range.upper; ++index) {
                this.acknowledgeMessageId(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessageId(long messageId) throws IllegalMessageIdentifierException, IllegalStateException {
        if (this.getStatus() != Sequence.Status.CREATED) {
            throw new IllegalStateException(LocalizationMessages.WSRM_1135_WRONG_SEQUENCE_STATE_ACKNOWLEDGEMENT_REJECTED(this.getId(), (Object)this.getStatus()));
        }
        try {
            this.messageIdLock.writeLock().lock();
            if (messageId > this.getLastMessageId()) {
                if (this.getLastMessageId() + 1L != messageId) {
                    for (long lostIdentifier = this.getLastMessageId() + 1L; lostIdentifier < messageId; ++lostIdentifier) {
                        this.unackedMessageIdentifiers.add(lostIdentifier);
                    }
                }
                this.updateLastMessageId(messageId);
            } else if (!this.unackedMessageIdentifiers.remove(messageId)) {
                throw LOGGER.logSevereException(new IllegalMessageIdentifierException(messageId));
            }
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }
}

