/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy.assertion;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.SimpleAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.policy.assertion.RmAssertionInstantiator;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Rm10Assertion
extends SimpleAssertion {
    public static final QName NAME = new QName(RmVersion.WSRM10.policyNamespaceUri, "RMAssertion");
    private static final QName INACTIVITY_TIMEOUT_QNAME = new QName(RmVersion.WSRM10.policyNamespaceUri, "InactivityTimeout");
    private static final QName RETRANSMITTION_INTERVAL_QNAME = new QName(RmVersion.WSRM10.policyNamespaceUri, "BaseRetransmissionInterval");
    private static final QName EXPONENTIAL_BACKOFF_QNAME = new QName(RmVersion.WSRM10.policyNamespaceUri, "ExponentialBackoff");
    private static final QName ACKNOWLEDGEMENT_INTERVAL_QNAME = new QName(RmVersion.WSRM10.policyNamespaceUri, "AcknowledgementInterval");
    private static final QName MILISECONDS_ATTRIBUTE_QNAME = new QName("", "Milliseconds");
    private static RmAssertionInstantiator instantiator = new RmAssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) {
            return new Rm10Assertion(data, assertionParameters);
        }
    };
    private final long inactivityTimeout;
    private final long retransmittionInterval;
    private final boolean useExponentialBackoffAlgorithm;
    private final long acknowledgementInterval;

    public static RmAssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private Rm10Assertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters) {
        super(data, assertionParameters);
        long _inactivityTimeout = 600000L;
        long _retransmittionInterval = -1L;
        boolean _useExponentialBackoffAlgorithm = false;
        long _acknowledgementInterval = -1L;
        if (assertionParameters != null) {
            for (PolicyAssertion policyAssertion : assertionParameters) {
                if (INACTIVITY_TIMEOUT_QNAME.equals(policyAssertion.getName())) {
                    _inactivityTimeout = Long.parseLong(policyAssertion.getAttributeValue(MILISECONDS_ATTRIBUTE_QNAME));
                    continue;
                }
                if (RETRANSMITTION_INTERVAL_QNAME.equals(policyAssertion.getName())) {
                    _retransmittionInterval = Long.parseLong(policyAssertion.getAttributeValue(MILISECONDS_ATTRIBUTE_QNAME));
                    continue;
                }
                if (EXPONENTIAL_BACKOFF_QNAME.equals(policyAssertion.getName())) {
                    _useExponentialBackoffAlgorithm = true;
                    continue;
                }
                if (!ACKNOWLEDGEMENT_INTERVAL_QNAME.equals(policyAssertion.getName())) continue;
                _acknowledgementInterval = Long.parseLong(policyAssertion.getAttributeValue(MILISECONDS_ATTRIBUTE_QNAME));
            }
        }
        this.inactivityTimeout = _inactivityTimeout;
        this.retransmittionInterval = _retransmittionInterval;
        this.useExponentialBackoffAlgorithm = _useExponentialBackoffAlgorithm;
        this.acknowledgementInterval = _acknowledgementInterval;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public long getBaseRetransmittionInterval() {
        return this.retransmittionInterval;
    }

    public boolean useExponentialBackoffAlgorithm() {
        return this.useExponentialBackoffAlgorithm;
    }

    public long getAcknowledgementInterval() {
        return this.acknowledgementInterval;
    }
}

