/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.ConfigurationManager;
import com.sun.xml.ws.rm.policy.assertion.AllowDuplicatesAssertion;
import com.sun.xml.ws.rm.policy.assertion.OrderedDeliveryAssertion;
import com.sun.xml.ws.rm.policy.assertion.Rm10Assertion;
import com.sun.xml.ws.rm.policy.assertion.RmFlowControlAssertion;

class Rm10ServiceConfiguration
implements Configuration {
    private SOAPVersion soapVersion;
    private AddressingVersion addressingVersion;
    private final long inactivityTimeout;
    private final long bufferQuota;
    private final boolean orderedDelivery;
    private final Configuration.DeliveryAssurance deliveryAssurance;
    private final long acknowledgementInterval;
    private final boolean requestResponseDetected;

    Rm10ServiceConfiguration(AssertionSet alternative, SOAPVersion soapVersion, AddressingVersion addressingVersion, boolean requestResponseDetected) {
        this.soapVersion = soapVersion;
        this.addressingVersion = addressingVersion;
        this.requestResponseDetected = requestResponseDetected;
        Rm10Assertion rmAssertion = ConfigurationManager.extractAssertion(alternative, Rm10Assertion.NAME, Rm10Assertion.class);
        this.inactivityTimeout = rmAssertion.getInactivityTimeout();
        this.acknowledgementInterval = rmAssertion.getAcknowledgementInterval();
        RmFlowControlAssertion rmFlowControlAssertion = ConfigurationManager.extractAssertion(alternative, RmFlowControlAssertion.NAME, RmFlowControlAssertion.class);
        this.bufferQuota = rmFlowControlAssertion != null ? rmFlowControlAssertion.getMaximumBufferSize() : -1L;
        AllowDuplicatesAssertion allowDuplicatesAssertion = ConfigurationManager.extractAssertion(alternative, AllowDuplicatesAssertion.NAME, AllowDuplicatesAssertion.class);
        this.deliveryAssurance = allowDuplicatesAssertion != null ? Configuration.DeliveryAssurance.AT_LEAST_ONCE : Configuration.DeliveryAssurance.EXACTLY_ONCE;
        OrderedDeliveryAssertion orderedDeliveryAssertion = ConfigurationManager.extractAssertion(alternative, OrderedDeliveryAssertion.NAME, OrderedDeliveryAssertion.class);
        this.orderedDelivery = orderedDeliveryAssertion != null;
    }

    public RmVersion getRmVersion() {
        return RmVersion.WSRM10;
    }

    public SOAPVersion getSoapVersion() {
        return this.soapVersion;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public boolean requestResponseOperationsDetected() {
        return this.requestResponseDetected;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public long getSequenceAcknowledgementInterval() {
        return this.acknowledgementInterval;
    }

    public Configuration.SecurityBinding getSecurityBinding() {
        return Configuration.SecurityBinding.NONE;
    }

    public Configuration.DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public boolean isOrderedDelivery() {
        return this.orderedDelivery;
    }

    public long getDestinationBufferQuota() {
        return this.bufferQuota;
    }

    public long getMessageRetransmissionInterval() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }

    public boolean useExponetialBackoffRetransmission() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }

    public long getAcknowledgementRequestInterval() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }

    public long getCloseSequenceOperationTimeout() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }
}

