/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;

public class ActionDumpPipe
extends AbstractFilterPipeImpl {
    private final String name;
    private final WSBinding binding;

    public ActionDumpPipe(WSBinding binding, Pipe next) {
        this("ActionDumpPipe", binding, next);
    }

    public ActionDumpPipe(String name, WSBinding binding, Pipe next) {
        super(next);
        this.name = name;
        this.binding = binding;
    }

    private ActionDumpPipe(ActionDumpPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.name = that.name;
        this.binding = that.binding;
    }

    public Packet process(Packet packet) {
        this.dump(packet);
        Packet reply = this.next.process(packet);
        this.dump(reply);
        return reply;
    }

    protected void dump(Packet packet) {
        if (packet.getMessage() != null) {
            this.dumpAction(packet);
        }
    }

    protected void dumpAction(Packet packet) {
        try {
            Message m = packet.getMessage().copy();
            String to = m.getHeaders().getTo(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
            String action = m.getHeaders().getAction(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
            System.out.println("{To, Action}: {" + to + ", " + action + "}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Pipe copy(PipeCloner cloner) {
        return new ActionDumpPipe(this, cloner);
    }
}

