/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.transport.tcp.client.TCPTransportPipe;
import com.sun.xml.ws.transport.tcp.client.WSConnectionManager;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public final class ServiceChannelTransportPipe
extends TCPTransportPipe {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.client");

    public ServiceChannelTransportPipe(@NotNull ClientPipeAssemblerContext context) {
        super(context);
    }

    private ServiceChannelTransportPipe(ServiceChannelTransportPipe that, PipeCloner cloner) {
        super(that, cloner);
    }

    public Packet process(Packet packet) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1001_TCP_SERVICE_TP_PROCESS_ENTER(packet.endpointAddress));
        }
        ChannelContext channelContext = null;
        WSConnectionManager wsConnectionManager = WSConnectionManager.getInstance();
        try {
            ContentType ct = this.defaultCodec.getStaticContentType(packet);
            channelContext = this.clientTransport.getConnectionContext();
            if (channelContext != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, MessagesMessages.WSTCP_1002_TCP_SERVICE_TP_PROCESS_TRANSPORT_REUSE());
                }
                wsConnectionManager.lockConnection(channelContext.getConnectionSession());
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, MessagesMessages.WSTCP_1003_TCP_SERVICE_TP_PROCESS_TRANSPORT_CREATE());
                }
                ConnectionSession connectionSession = (ConnectionSession)packet.invocationProperties.get("tcpSession");
                channelContext = connectionSession.getServiceChannelContext();
                this.clientTransport.setup(channelContext);
            }
            this.clientTransport.setContentType(ct.getContentType());
            this.writeTransportSOAPActionHeaderIfRequired(channelContext, ct, packet);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1004_TCP_SERVICE_TP_PROCESS_ENCODE(ct.getContentType()));
            }
            this.defaultCodec.encode(packet, this.clientTransport.openOutputStream());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1005_TCP_SERVICE_TP_PROCESS_SEND());
            }
            this.clientTransport.send();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1006_TCP_SERVICE_TP_PROCESS_OPEN_PREPARE_READING());
            }
            InputStream replyInputStream = this.clientTransport.openInputStream();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1007_TCP_SERVICE_TP_PROCESS_OPEN_PROCESS_READING(this.clientTransport.getStatus(), this.clientTransport.getContentType()));
            }
            if (this.clientTransport.getStatus() != 2) {
                String contentTypeStr = this.clientTransport.getContentType();
                Packet reply = packet.createClientResponse(null);
                this.defaultCodec.decode(replyInputStream, contentTypeStr, reply);
                reply.addSatellite((PropertySet)this.clientTransport);
                return reply;
            }
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0016_ERROR_WS_EXECUTION_ON_SERVER(this.clientTransport.getError()));
            throw new WSTCPException(this.clientTransport.getError());
        }
        catch (WebServiceException wex) {
            this.abortSession(channelContext);
            throw wex;
        }
        catch (Exception ex) {
            this.abortSession(channelContext);
            this.clientTransport.setup(null);
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0017_ERROR_WS_EXECUTION_ON_CLIENT(), ex);
            throw new WebServiceException(MessagesMessages.WSTCP_0017_ERROR_WS_EXECUTION_ON_CLIENT(), (Throwable)ex);
        }
    }

    public Pipe copy(PipeCloner cloner) {
        return new ServiceChannelTransportPipe(this, cloner);
    }
}

