/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.ws.api.security.trust.STSAuthorizationProvider;
import com.sun.xml.ws.api.security.trust.WSTrustContract;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustContractImpl
implements WSTrustContract<BaseSTSRequest, BaseSTSResponse> {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    protected STSConfiguration stsConfig;
    protected static final WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance();
    protected static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'", Locale.getDefault());
    private static final int DEFAULT_KEY_SIZE = 256;
    private long currentTime;

    @Override
    public void init(STSConfiguration config) {
        this.stsConfig = config;
    }

    @Override
    public BaseSTSResponse issue(BaseSTSRequest request, IssuedTokenContext context) throws WSTrustException {
        STSAuthorizationProvider authzProvider;
        Object oboToken;
        Subject subject;
        TrustSPMetadata spMd;
        WSTrustVersion wstVer = (WSTrustVersion)this.stsConfig.getOtherOptions().get("WSTrustVersion");
        RequestSecurityToken rst = (RequestSecurityToken)request;
        AppliesTo applies = rst.getAppliesTo();
        String appliesTo = null;
        if (applies != null) {
            appliesTo = WSTrustUtil.getAppliesToURI(applies);
        }
        if ((spMd = this.stsConfig.getTrustSPMetadata(appliesTo)) == null) {
            spMd = this.stsConfig.getTrustSPMetadata("default");
        }
        if (spMd == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
        }
        String tokenType = null;
        URI tokenTypeURI = rst.getTokenType();
        tokenType = tokenTypeURI != null ? tokenTypeURI.toString() : spMd.getTokenType();
        if (tokenType == null) {
            tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
        }
        String keyType = null;
        URI keyTypeURI = rst.getKeyType();
        keyType = keyTypeURI != null ? keyTypeURI.toString() : spMd.getKeyType();
        if (keyType == null) {
            keyType = "http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey";
        }
        if ((subject = context.getRequestorSubject()) == null) {
            AccessControlContext acc = AccessController.getContext();
            subject = Subject.getSubject(acc);
        }
        if (subject == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0030_REQUESTOR_NULL());
            throw new WSTrustException(LogStringsMessages.WST_0030_REQUESTOR_NULL());
        }
        OnBehalfOf obo = rst.getOnBehalfOf();
        if (obo != null && (oboToken = obo.getAny()) != null) {
            subject.getPublicCredentials().add((Element)oboToken);
        }
        if (!(authzProvider = WSTrustFactory.getSTSAuthorizationProvider()).isAuthorized(subject, appliesTo, tokenType, keyType)) {
            String user = subject.getPrincipals().iterator().next().getName();
            log.log(Level.SEVERE, LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
        }
        Claims claims = rst.getClaims();
        STSAttributeProvider attrProvider = WSTrustFactory.getSTSAttributeProvider();
        Map<QName, List<String>> claimedAttrs = attrProvider.getClaimedAttributes(subject, appliesTo, tokenType, claims);
        RequestedProofToken proofToken = null;
        Entropy serverEntropy = null;
        int keySize = 0;
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey".equals(keyType)) {
            proofToken = eleFac.createRequestedProofToken();
            byte[] clientEntr = null;
            Entropy clientEntropy = rst.getEntropy();
            if (clientEntropy != null) {
                BinarySecret clientBS = clientEntropy.getBinarySecret();
                if (clientBS == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, LogStringsMessages.WST_1009_NULL_BINARY_SECRET());
                    }
                } else {
                    clientEntr = clientBS.getRawValue();
                }
            }
            if ((keySize = (int)rst.getKeySize()) < 1) {
                keySize = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WST_1010_KEY_SIZE(keySize, 256));
            }
            byte[] key = WSTrustUtil.generateRandomSecret(keySize / 8);
            BinarySecret serverBS = eleFac.createBinarySecret(key, wstVer.getNonceBinarySecretTypeURI());
            serverEntropy = eleFac.createEntropy(serverBS);
            proofToken.setProofTokenType("ComputedKey");
            try {
                proofToken.setComputedKey(URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1"));
                key = SecurityUtil.P_SHA1((byte[])clientEntr, (byte[])key, (int)(keySize / 8));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0013_ERROR_SECRET_KEY("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1", keySize, appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0013_ERROR_SECRET_KEY("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1", keySize, appliesTo), ex);
            }
            context.setProofKey(key);
        } else if ("http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey".equals(keyType)) {
            Set<Object> certs = context.getRequestorSubject().getPublicCredentials();
            if (certs == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
            boolean addedClientCert = false;
            for (Object o : certs) {
                if (!(o instanceof X509Certificate)) continue;
                X509Certificate clientCert = (X509Certificate)o;
                context.setRequestorCertificate(clientCert);
                addedClientCert = true;
            }
            if (!addedClientCert) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
        }
        RequestedSecurityToken reqSecTok = null;
        RequestedAttachedReference raRef = null;
        RequestedUnattachedReference ruRef = null;
        URI ctx = null;
        try {
            String rstCtx = rst.getContext();
            if (rstCtx != null) {
                ctx = new URI(rst.getContext());
            }
        }
        catch (URISyntaxException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0014_URI_SYNTAX(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0014_URI_SYNTAX(), ex);
        }
        Lifetime lifetime = this.createLifetime();
        RequestSecurityTokenResponse rstr = eleFac.createRSTRForIssue(rst.getTokenType(), ctx, reqSecTok, applies, raRef, ruRef, proofToken, serverEntropy, lifetime);
        if (keySize > 0) {
            rstr.setKeySize(keySize);
        }
        return rstr;
    }

    @Override
    public BaseSTSResponse renew(BaseSTSRequest rst, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: renew");
    }

    @Override
    public BaseSTSResponse cancel(BaseSTSRequest rst, IssuedTokenContext context, Map map) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: cancel");
    }

    @Override
    public BaseSTSResponse validate(BaseSTSRequest request, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: validate");
    }

    @Override
    public void handleUnsolicited(BaseSTSResponse rstr, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: handleUnsolicited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lifetime createLifetime() {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = cal.get(15);
        if (((Calendar)cal).getTimeZone().inDaylightTime(cal.getTime())) {
            offset += ((Calendar)cal).getTimeZone().getDSTSavings();
        }
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(((Calendar)cal).getTimeZone());
            long beforeTime = cal.getTimeInMillis();
            this.currentTime = beforeTime - (long)offset;
            cal.setTimeInMillis(this.currentTime);
            AttributedDateTime created = new AttributedDateTime();
            created.setValue(calendarFormatter.format(cal.getTime()));
            AttributedDateTime expires = new AttributedDateTime();
            cal.setTimeInMillis(this.currentTime + this.stsConfig.getIssuedTokenTimeout());
            expires.setValue(calendarFormatter.format(cal.getTime()));
            Lifetime lifetime = eleFac.createLifetime(created, expires);
            return lifetime;
        }
    }
}

