/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Trust10;
import com.sun.xml.ws.security.impl.policy.Trust13;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.secconv.WSSCClientContract;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.impl.wssx.WSSCVersion13;
import com.sun.xml.ws.security.secconv.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.Configuration;
import com.sun.xml.ws.security.trust.WSTrustConstants;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import java.io.StringWriter;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.soap.SOAPFaultException;

public class WSSCPlugin {
    Configuration config;
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");
    private WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance();
    private WSSCVersion wsscVer = WSSCVersion.WSSC_10;
    private WSTrustVersion wsTrustVer = WSTrustVersion.WS_TRUST_10;
    private static final int DEFAULT_KEY_SIZE = 256;
    private static final String SC_ASSERTION = "SecureConversationAssertion";
    private static final String FOR_CANCEL = "For Cancel";
    private Packet packet = null;

    public WSSCPlugin(Configuration config, WSSCVersion wsscVer) {
        this.config = config;
        if (wsscVer instanceof WSSCVersion13) {
            this.wsscVer = wsscVer;
            this.wsTrustVer = WSTrustVersion.WS_TRUST_13;
            this.eleFac = WSTrustElementFactory.newInstance(this.wsTrustVer);
        }
    }

    public IssuedTokenContext process(PolicyAssertion token, WSDLPort wsdlPort, WSBinding binding, Pipe securityPipe, Marshaller marshaller, Unmarshaller unmarshaller, String endPointAddress, Packet packet, AddressingVersion addVer) {
        Set trustReqdProps;
        this.packet = packet;
        SecureConversationToken scToken = (SecureConversationToken)((Object)token);
        AssertionSet assertions = this.getAssertions(scToken);
        Trust10 trust10 = null;
        Trust13 trust13 = null;
        Binding symBinding = null;
        for (PolicyAssertion policyAssertion : assertions) {
            SecurityPolicyVersion spVersion;
            if (PolicyUtil.isTrust13(policyAssertion, spVersion = this.getSPVersion(policyAssertion))) {
                trust13 = (Trust13)policyAssertion;
                continue;
            }
            if (PolicyUtil.isTrust10(policyAssertion, spVersion)) {
                trust10 = (Trust10)policyAssertion;
                continue;
            }
            if (!PolicyUtil.isSymmetricBinding(policyAssertion, spVersion)) continue;
            symBinding = (SymmetricBinding)((Object)policyAssertion);
        }
        int skl = 256;
        boolean reqClientEntropy = true;
        if (symBinding != null) {
            AlgorithmSuite algoSuite = symBinding.getAlgorithmSuite();
            skl = algoSuite.getMinSKLAlgorithm();
            if (skl < 1) {
                skl = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WSSC_1006_SYM_BIN_KEYSIZE(skl, 256));
            }
        }
        if (trust10 != null) {
            trustReqdProps = trust10.getRequiredProperties();
            reqClientEntropy = trustReqdProps.contains("RequireClientEntropy");
        }
        if (trust13 != null) {
            trustReqdProps = trust13.getRequiredProperties();
            reqClientEntropy = trustReqdProps.contains("RequireClientEntropy");
        }
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityToken(reqClientEntropy, skl);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(""), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(""), ex);
        }
        BaseSTSResponse rstr = this.sendRequest(token, wsdlPort, binding, securityPipe, marshaller, unmarshaller, rst, this.wsscVer.getSCTRequestAction(), endPointAddress, addVer);
        IssuedTokenContextImpl context = new IssuedTokenContextImpl();
        try {
            this.processRequestSecurityTokenResponse(rst, rstr, (IssuedTokenContext)context);
        }
        catch (WSSecureConversationException ex) {
            throw new RuntimeException(ex);
        }
        context.setEndpointAddress(endPointAddress);
        return context;
    }

    private AssertionSet getAssertions(SecureConversationToken scToken) {
        return scToken.getBootstrapPolicy().getAssertionSet();
    }

    public IssuedTokenContext processCancellation(IssuedTokenContext ctx, WSDLPort wsdlPort, WSBinding binding, Pipe securityPipe, Marshaller marshaller, Unmarshaller unmarshaller, String endPointAddress, AddressingVersion addVer) {
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityTokenForCancel(ctx);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
        }
        BaseSTSResponse rstr = this.sendRequest(null, wsdlPort, binding, securityPipe, marshaller, unmarshaller, rst, this.wsscVer.getSCTCancelRequestAction(), endPointAddress, addVer);
        try {
            this.processRequestSecurityTokenResponse(rst, rstr, ctx);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
        }
        return ctx;
    }

    private BaseSTSResponse sendRequest(PolicyAssertion issuedToken, WSDLPort wsdlPort, WSBinding binding, Pipe securityPipe, Marshaller marshaller, Unmarshaller unmarshaller, BaseSTSRequest rst, String action, String endPointAddress, AddressingVersion addVer) {
        Message request = Messages.create((Marshaller)marshaller, (Object)this.eleFac.toJAXBElement(rst), (SOAPVersion)binding.getSOAPVersion());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1009_SEND_REQ_MESSAGE(this.printMessageAsString(request)));
        }
        Packet reqPacket = new Packet(request);
        if (issuedToken != null) {
            reqPacket.invocationProperties.put(SC_ASSERTION, issuedToken);
        }
        if (this.packet != null) {
            for (WSTrustConstants.STS_PROPERTIES stsProperty : WSTrustConstants.STS_PROPERTIES.values()) {
                reqPacket.invocationProperties.put(stsProperty.toString(), this.packet.invocationProperties.get(stsProperty.toString()));
            }
        }
        reqPacket.setEndPointAddressString(endPointAddress);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1008_SET_EP_ADDRESS(endPointAddress));
        }
        try {
            reqPacket = this.addAddressingHeaders(reqPacket, wsdlPort, binding, action, addVer);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
        }
        if (this.packet != null) {
            reqPacket.contentNegotiation = this.packet.contentNegotiation;
        }
        this.copyStandardSecurityProperties(this.packet, reqPacket);
        Packet respPacket = securityPipe.process(reqPacket);
        Message response = respPacket.getMessage();
        BaseSTSResponse rstr = null;
        if (!response.isFault()) {
            JAXBElement rstrEle = null;
            try {
                rstrEle = (JAXBElement)response.readPayloadAsJAXB(unmarshaller);
            }
            catch (JAXBException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
            }
            rstr = this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI()) ? this.eleFac.createRSTRCollectionFrom(rstrEle) : this.eleFac.createRSTRFrom(rstrEle);
        } else {
            try {
                throw new SOAPFaultException(response.readAsSOAPMessage().getSOAPBody().getFault());
            }
            catch (SOAPException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
            }
        }
        return rstr;
    }

    private RequestSecurityToken createRequestSecurityToken(boolean reqClientEntropy, int skl) throws WSSecureConversationException {
        URI tokenType = URI.create(this.wsscVer.getSCTTokenTypeURI());
        URI requestType = URI.create(this.wsTrustVer.getIssueRequestTypeURI());
        SecureRandom random = new SecureRandom();
        byte[] rawValue = new byte[skl / 8];
        random.nextBytes(rawValue);
        BinarySecret secret = this.eleFac.createBinarySecret(rawValue, this.wsTrustVer.getNonceBinarySecretTypeURI());
        Entropy entropy = reqClientEntropy ? this.eleFac.createEntropy(secret) : null;
        RequestSecurityToken rst = null;
        try {
            rst = this.eleFac.createRSTForIssue(tokenType, requestType, null, null, null, entropy, null);
            rst.setKeySize(skl);
            rst.setKeyType(URI.create(this.wsTrustVer.getSymmetricKeyTypeURI()));
            rst.setComputedKeyAlgorithm(URI.create(this.wsTrustVer.getCKPSHA1algorithmURI()));
        }
        catch (WSTrustException ex) {
            throw new WSSecureConversationException(ex);
        }
        return rst;
    }

    private RequestSecurityToken createRequestSecurityTokenForCancel(IssuedTokenContext ctx) throws WSSecureConversationException {
        URI requestType = null;
        requestType = URI.create(this.wsTrustVer.getCancelRequestTypeURI());
        CancelTarget target = this.eleFac.createCancelTarget((SecurityTokenReference)ctx.getUnAttachedSecurityTokenReference());
        RequestSecurityToken rst = this.eleFac.createRSTForCancel(requestType, target);
        return rst;
    }

    private void processRequestSecurityTokenResponse(BaseSTSRequest rst, BaseSTSResponse rstr, IssuedTokenContext context) throws WSSecureConversationException {
        WSSCClientContract contract = WSSCFactory.newWSSCClientContract(this.config, this.wsscVer);
        if (this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
            contract.handleRSTRC((RequestSecurityToken)rst, (RequestSecurityTokenResponseCollection)rstr, context);
        } else {
            contract.handleRSTR((RequestSecurityToken)rst, (RequestSecurityTokenResponse)rstr, context);
        }
    }

    private String printMessageAsString(Message message) {
        StringWriter writer = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter streamWriter = factory.createXMLStreamWriter(writer);
            message.writeTo(streamWriter);
            streamWriter.flush();
            return writer.toString();
        }
        catch (XMLStreamException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0025_PROBLEM_PRINTING_MSG(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0025_PROBLEM_PRINTING_MSG(), ex);
        }
    }

    private Packet addAddressingHeaders(Packet packet, WSDLPort wsdlPort, WSBinding binding, String action, AddressingVersion addVer) throws WSSecureConversationException {
        HeaderList list = packet.getMessage().getHeaders();
        list.fillRequestAddressingHeaders(packet, addVer, binding.getSOAPVersion(), false, action);
        return packet;
    }

    private void copyStandardSecurityProperties(Packet packet, Packet requestPacket) {
        String password;
        String username = (String)packet.invocationProperties.get("javax.xml.ws.security.auth.username");
        if (username != null) {
            requestPacket.invocationProperties.put("javax.xml.ws.security.auth.username", username);
        }
        if ((password = (String)packet.invocationProperties.get("javax.xml.ws.security.auth.password")) != null) {
            requestPacket.invocationProperties.put("javax.xml.ws.security.auth.password", password);
        }
    }

    private SecurityPolicyVersion getSPVersion(PolicyAssertion pa) {
        String nsUri = pa.getName().getNamespaceURI();
        SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
        }
        return spVersion;
    }
}

