/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.security.policy.MessageLayout;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import java.util.ArrayList;
import java.util.List;

public class XWSSPolicyContainer {
    private Section section;
    private List<SecurityPolicy> policyList;
    private List<SecurityPolicy> effectivePolicyList;
    private MessageLayout mode;
    private int foundTimestamp = -1;
    private boolean modified = false;

    public XWSSPolicyContainer(MessageLayout mode, boolean isServer, boolean isIncoming) {
        this.mode = mode;
        this.setMessageMode(isServer, isIncoming);
        this.effectivePolicyList = new ArrayList<SecurityPolicy>();
    }

    public XWSSPolicyContainer(boolean isServer, boolean isIncoming) {
        this.setMessageMode(isServer, isIncoming);
        this.effectivePolicyList = new ArrayList<SecurityPolicy>();
    }

    public void setMessageMode(boolean isServer, boolean isIncoming) {
        if (isServer && isIncoming) {
            this.section = Section.ServerIncomingPolicy;
        } else if (isServer && !isIncoming) {
            this.section = Section.ServerOutgoingPolicy;
        } else if (!isServer && isIncoming) {
            this.section = Section.ClientIncomingPolicy;
        } else if (!isServer && !isIncoming) {
            this.section = Section.ClientOutgoingPolicy;
        }
    }

    public void setPolicyContainerMode(MessageLayout mode) {
        this.mode = mode;
    }

    public void insert(SecurityPolicy secPolicy) {
        if (secPolicy == null) {
            return;
        }
        if (this.policyList == null) {
            this.policyList = new ArrayList<SecurityPolicy>();
        }
        if (this.isSupportingToken(secPolicy)) {
            switch (this.section) {
                case ServerOutgoingPolicy: 
                case ClientIncomingPolicy: {
                    return;
                }
            }
        }
        this.modified = true;
        this.policyList.add(secPolicy);
    }

    public MessagePolicy getMessagePolicy() throws PolicyGenerationException {
        if (this.modified) {
            this.convert();
            this.modified = false;
        }
        MessagePolicy msgPolicy = new MessagePolicy();
        msgPolicy.appendAll(this.effectivePolicyList);
        this.removeEmptyPrimaryPolicies(msgPolicy);
        return msgPolicy;
    }

    private void removeEmptyPrimaryPolicies(MessagePolicy msgPolicy) {
        for (Object policy : msgPolicy.getPrimaryPolicies()) {
            if (!(policy instanceof SecurityPolicy)) continue;
            SecurityPolicy secPolicy = (SecurityPolicy)policy;
            if (PolicyTypeUtil.signaturePolicy((SecurityPolicy)secPolicy)) {
                if (((SignaturePolicy.FeatureBinding)((SignaturePolicy)secPolicy).getFeatureBinding()).getTargetBindings().size() != 0) continue;
                msgPolicy.remove(secPolicy);
                continue;
            }
            if (!PolicyTypeUtil.encryptionPolicy((SecurityPolicy)secPolicy) || ((EncryptionPolicy.FeatureBinding)((EncryptionPolicy)secPolicy).getFeatureBinding()).getTargetBindings().size() != 0) continue;
            msgPolicy.remove(secPolicy);
        }
    }

    private void appendAfterToken(SecurityPolicy xwssPolicy) {
        int pos = -1;
        for (SecurityPolicy secPolicy : this.effectivePolicyList) {
            if (this.isSupportingToken(secPolicy) || this.isTimestamp(secPolicy)) continue;
            pos = this.effectivePolicyList.indexOf(secPolicy);
            break;
        }
        if (pos != -1) {
            this.effectivePolicyList.add(pos, xwssPolicy);
        } else {
            this.effectivePolicyList.add(xwssPolicy);
        }
    }

    private void prependBeforeToken(SecurityPolicy xwssPolicy) {
        int pos = -1;
        for (SecurityPolicy secPolicy : this.effectivePolicyList) {
            if (!this.isSupportingToken(secPolicy)) continue;
            pos = this.effectivePolicyList.indexOf(secPolicy);
        }
        if (pos != -1) {
            this.effectivePolicyList.add(pos, xwssPolicy);
        } else {
            this.effectivePolicyList.add(xwssPolicy);
        }
    }

    private void append(SecurityPolicy xwssPolicy) {
        this.effectivePolicyList.add(xwssPolicy);
    }

    private void prepend(SecurityPolicy xwssPolicy) {
        this.effectivePolicyList.add(0, xwssPolicy);
    }

    private boolean isSupportingToken(SecurityPolicy xwssPolicy) {
        MLSPolicy binding;
        if (xwssPolicy == null) {
            return false;
        }
        return PolicyTypeUtil.authenticationTokenPolicy((SecurityPolicy)xwssPolicy) && (PolicyTypeUtil.usernameTokenPolicy((SecurityPolicy)(binding = ((AuthenticationTokenPolicy)xwssPolicy).getFeatureBinding())) || PolicyTypeUtil.samlTokenPolicy((SecurityPolicy)binding) || PolicyTypeUtil.x509CertificateBinding((SecurityPolicy)binding));
    }

    private boolean isTimestamp(SecurityPolicy xwssPolicy) {
        return xwssPolicy != null && PolicyTypeUtil.timestampPolicy((SecurityPolicy)xwssPolicy);
    }

    private void convertLax() {
        for (SecurityPolicy xwssPolicy : this.policyList) {
            if (this.isTimestamp(xwssPolicy)) {
                this.foundTimestamp = this.policyList.indexOf(xwssPolicy);
                this.prepend(xwssPolicy);
                continue;
            }
            if (!this.isSupportingToken(xwssPolicy)) {
                switch (this.section) {
                    case ClientIncomingPolicy: {
                        this.prepend(xwssPolicy);
                        break;
                    }
                    case ClientOutgoingPolicy: {
                        this.append(xwssPolicy);
                        break;
                    }
                    case ServerIncomingPolicy: {
                        this.appendAfterToken(xwssPolicy);
                        break;
                    }
                    case ServerOutgoingPolicy: {
                        this.append(xwssPolicy);
                    }
                }
                continue;
            }
            if (!this.isSupportingToken(xwssPolicy) && !this.isTimestamp(xwssPolicy)) continue;
            this.prepend(xwssPolicy);
        }
    }

    private void convertStrict() {
        for (SecurityPolicy xwssPolicy : this.policyList) {
            if (this.isSupportingToken(xwssPolicy)) {
                this.prepend(xwssPolicy);
                continue;
            }
            if (this.isTimestamp(xwssPolicy)) {
                this.prepend(xwssPolicy);
                continue;
            }
            switch (this.section) {
                case ClientIncomingPolicy: {
                    this.appendAfterToken(xwssPolicy);
                    break;
                }
                case ClientOutgoingPolicy: {
                    this.append(xwssPolicy);
                    break;
                }
                case ServerIncomingPolicy: {
                    this.appendAfterToken(xwssPolicy);
                    break;
                }
                case ServerOutgoingPolicy: {
                    this.append(xwssPolicy);
                }
            }
        }
    }

    private void convertLaxTsFirst() {
        this.convertLax();
        if (this.foundTimestamp != -1) {
            switch (this.section) {
                case ClientOutgoingPolicy: {
                    this.effectivePolicyList.add(0, this.effectivePolicyList.remove(this.foundTimestamp));
                    break;
                }
                case ServerOutgoingPolicy: {
                    this.effectivePolicyList.add(0, this.effectivePolicyList.remove(this.foundTimestamp));
                }
            }
        }
    }

    private void convertLaxTsLast() {
        this.convertLax();
        if (this.foundTimestamp != -1) {
            switch (this.section) {
                case ClientOutgoingPolicy: {
                    this.effectivePolicyList.add(this.effectivePolicyList.size() - 1, this.effectivePolicyList.remove(this.foundTimestamp));
                    break;
                }
                case ServerOutgoingPolicy: {
                    this.effectivePolicyList.add(this.effectivePolicyList.size() - 1, this.effectivePolicyList.remove(this.foundTimestamp));
                }
            }
        }
    }

    public void convert() {
        if (MessageLayout.Lax == this.mode) {
            this.convertLax();
        } else if (MessageLayout.Strict == this.mode) {
            this.convertStrict();
        } else if (MessageLayout.LaxTsFirst == this.mode) {
            this.convertLaxTsFirst();
        } else if (MessageLayout.LaxTsLast == this.mode) {
            this.convertLaxTsLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Section {
        ClientIncomingPolicy,
        ClientOutgoingPolicy,
        ServerIncomingPolicy,
        ServerOutgoingPolicy;

    }
}

