/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.rm.MessageSender;
import com.sun.xml.ws.rm.jaxws.runtime.server.RMServerTube;
import com.sun.xml.ws.rm.localization.RmLogger;

public class TubelineSender
implements MessageSender,
Fiber.CompletionCallback {
    private static final RmLogger LOGGER = RmLogger.getLogger(TubelineSender.class);
    private Fiber fiber;
    private Fiber parentFiber;
    private Packet requestPacket;
    private SOAPVersion soapVersion;
    private AddressingVersion addressingVersion;
    private RMServerTube tube;

    public TubelineSender(RMServerTube tube, Packet packet, SOAPVersion soapVersion, AddressingVersion addressingVersion) {
        this.requestPacket = packet;
        this.parentFiber = Fiber.current();
        this.fiber = this.parentFiber.owner.createFiber();
        this.soapVersion = soapVersion;
        this.addressingVersion = addressingVersion;
        this.tube = tube;
    }

    public void onCompletion(@NotNull Packet packet) {
        try {
            this.tube.postProcess(packet);
            this.parentFiber.resume(packet);
        }
        catch (Throwable t) {
            LOGGER.severe("Unexcpected error occured, proceeding with handling the exception", t);
            this.onCompletion(t);
        }
    }

    public void onCompletion(@NotNull Throwable throwable) {
        Message mess = Messages.create((Throwable)throwable, (SOAPVersion)this.soapVersion);
        Packet packet = this.requestPacket.createServerResponse(mess, this.addressingVersion, this.soapVersion, this.addressingVersion.getDefaultFaultAction());
        this.parentFiber.resume(packet);
    }

    public void send() {
        this.fiber.start(TubeCloner.clone((Tube)this.tube.nextTube()), this.requestPacket, (Fiber.CompletionCallback)this);
    }
}

