/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.rm.AcknowledgementListener;
import com.sun.xml.ws.api.rm.SequenceSettings;
import com.sun.xml.ws.api.rm.client.ClientSequence;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.RMVersion;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ProtocolMessageSender;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMSource;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequence;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequenceResponse;
import com.sun.xml.ws.rm.protocol.AbstractTerminateSequence;
import com.sun.xml.ws.rm.v200502.CreateSequenceElement;
import com.sun.xml.ws.rm.v200502.OfferType;
import com.sun.xml.ws.rm.v200502.TerminateSequenceElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.net.URI;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOutboundSequence
extends OutboundSequence
implements ClientSequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(ClientOutboundSequence.class);
    protected int receiveBufferSize;
    private ProtocolMessageSender protocolMessageSender;
    private JAXBElement<SecurityTokenReferenceType> securityTokenReference = null;
    private boolean isAnonymous = false;
    private boolean isActive = true;
    private long resendDeadline;
    private long ackRequestDeadline;
    private AcknowledgementListener ackListener;
    private Service service;
    private static boolean sendHeartbeats = true;

    public ClientOutboundSequence(SequenceConfig config, JAXBElement<SecurityTokenReferenceType> str, URI destination, URI acksTo, boolean twoWay, Unmarshaller unmarshaller, Tube nextTube, BindingProvider proxy, ContentNegotiation contentNegotiation) throws RMException {
        super(config);
        super.setBufferRemaining(config.getBufferSize());
        this.securityTokenReference = str;
        this.protocolMessageSender = new ProtocolMessageSender(config, unmarshaller, nextTube, proxy, contentNegotiation);
        this.connect(destination, acksTo, twoWay);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getTransferWindowSize() {
        return this.getConfig().getBufferSize();
    }

    @Override
    public void setAcknowledgementListener(AcknowledgementListener listener) {
        this.ackListener = listener;
    }

    @Override
    public SequenceSettings getSequenceSettings() {
        SequenceConfig settings = this.getConfig();
        settings.setSequenceId(this.getId());
        InboundSequence iseq = this.getInboundSequence();
        settings.setCompanionSequenceId(iseq != null ? iseq.getId() : null);
        return settings;
    }

    public AcknowledgementListener getAcknowledgementListener() {
        return this.ackListener;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(URI destination, URI acksTo, boolean twoWay) throws RMException {
        LOGGER.entering(destination, acksTo, twoWay);
        try {
            AbstractCreateSequenceResponse csr;
            this.setDestination(destination);
            this.isAnonymous = acksTo != null ? this.getConfig().getAddressingVersion().anonymousUri.equals(acksTo.toString()) : true;
            AbstractCreateSequence createSequence = null;
            createSequence = this.getConfig().getRMVersion() == RMVersion.WSRM10 ? new CreateSequenceElement() : new com.sun.xml.ws.rm.v200702.CreateSequenceElement();
            W3CEndpointReference sourceEndpointReference = null;
            AddressingVersion addressingVersion = this.getConfig().getAddressingVersion();
            if (addressingVersion != AddressingVersion.W3C) {
                throw LOGGER.logSevereException(new RMException("Unsupported addressing version"));
            }
            WSEndpointReference epr = AddressingVersion.W3C.anonymousEpr;
            Source source = epr.asSource("AcksTo");
            sourceEndpointReference = new W3CEndpointReference(source);
            createSequence.setAcksTo(sourceEndpointReference);
            String incomingID = "uuid:" + UUID.randomUUID();
            if (twoWay) {
                Object offer;
                Object offerIdentifier;
                if (this.getConfig().getRMVersion() == RMVersion.WSRM10) {
                    offerIdentifier = new com.sun.xml.ws.rm.v200502.Identifier();
                    ((com.sun.xml.ws.rm.v200502.Identifier)offerIdentifier).setValue(incomingID);
                    offer = new OfferType();
                    ((OfferType)offer).setIdentifier((com.sun.xml.ws.rm.v200502.Identifier)offerIdentifier);
                    ((CreateSequenceElement)createSequence).setOffer((OfferType)offer);
                } else {
                    offerIdentifier = new Identifier();
                    ((Identifier)offerIdentifier).setValue(incomingID);
                    offer = new com.sun.xml.ws.rm.v200702.OfferType();
                    ((com.sun.xml.ws.rm.v200702.OfferType)offer).setIdentifier((Identifier)offerIdentifier);
                    ((com.sun.xml.ws.rm.v200702.OfferType)offer).setEndpoint((EndpointReference)sourceEndpointReference);
                    ((com.sun.xml.ws.rm.v200702.CreateSequenceElement)createSequence).setOffer((com.sun.xml.ws.rm.v200702.OfferType)offer);
                }
            }
            if (this.securityTokenReference != null) {
                createSequence.setSecurityTokenReference((SecurityTokenReferenceType)this.securityTokenReference.getValue());
                csr = this.protocolMessageSender.sendCreateSequence(createSequence, destination, acksTo, true);
            } else {
                csr = this.protocolMessageSender.sendCreateSequence(createSequence, destination, acksTo, false);
            }
            if (csr != null) {
                Object idOutbound;
                if (csr instanceof com.sun.xml.ws.rm.v200502.CreateSequenceResponseElement) {
                    idOutbound = ((com.sun.xml.ws.rm.v200502.CreateSequenceResponseElement)csr).getIdentifier();
                    this.setId(((com.sun.xml.ws.rm.v200502.Identifier)idOutbound).getValue());
                } else {
                    idOutbound = ((CreateSequenceResponseElement)csr).getIdentifier();
                    this.setId(((Identifier)idOutbound).getValue());
                }
                this.setCompanionSequence(new ClientInboundSequence(this, incomingID, this.getConfig()));
                this.resetLastActivityTime();
            }
        }
        finally {
            LOGGER.exiting();
        }
    }

    public void disconnect() throws RMException {
        this.disconnect(false);
    }

    public void disconnect(boolean keepAlive) throws RMException {
        if (this.getInboundSequence() == null) {
            throw new IllegalStateException("Not connected.");
        }
        this.isActive = keepAlive;
        if (this.getConfig().getRMVersion() == RMVersion.WSRM10) {
            this.sendLast();
        } else {
            this.sendCloseSequence();
        }
        this.waitForAcks();
        AbstractTerminateSequence ts = null;
        if (this.getConfig().getRMVersion() == RMVersion.WSRM10) {
            ts = new TerminateSequenceElement();
            com.sun.xml.ws.rm.v200502.Identifier idTerminate = new com.sun.xml.ws.rm.v200502.Identifier();
            idTerminate.setValue(this.getId());
            ((TerminateSequenceElement)ts).setIdentifier(idTerminate);
        } else {
            ts = new com.sun.xml.ws.rm.v200702.TerminateSequenceElement();
            Identifier idTerminate = new Identifier();
            idTerminate.setValue(this.getId());
            ((com.sun.xml.ws.rm.v200702.TerminateSequenceElement)ts).setIdentifier(idTerminate);
        }
        this.protocolMessageSender.sendTerminateSequence(ts, this);
    }

    private void sendLast() throws RMException {
        this.protocolMessageSender.sendLast(this);
    }

    private void sendCloseSequence() throws RMException {
        this.protocolMessageSender.sendCloseSequence(this);
    }

    public void resend(int messageNumber) throws RMException {
        RMMessage mess = this.get(messageNumber);
        mess.resume();
    }

    public synchronized void requestAck() {
        this.ackRequestDeadline = System.currentTimeMillis();
    }

    @Override
    protected synchronized boolean isAckRequested() {
        long time = System.currentTimeMillis();
        if (time > this.ackRequestDeadline) {
            this.ackRequestDeadline = time + this.getAckRequestInterval();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isResendDue() {
        long time = System.currentTimeMillis();
        if (time > this.resendDeadline) {
            this.resendDeadline = time + this.getResendInterval();
            return true;
        }
        return false;
    }

    private long getResendInterval() {
        if (!this.isActive || this.getStoredMessages() > this.getTransferWindowSize() / 2) {
            return 0L;
        }
        return this.getConfig().getResendInterval();
    }

    public boolean isTransferWindowFull() {
        return this.getTransferWindowSize() == this.getStoredMessages();
    }

    private long getAckRequestInterval() {
        if (!this.isActive || this.getStoredMessages() > this.getTransferWindowSize() / 2 || this.getReceiveBufferSize() > this.getConfig().getBufferSize() / 2) {
            return 0L;
        }
        return this.getConfig().getAckRequestInterval();
    }

    @Override
    public synchronized void acknowledge(int i) throws InvalidMessageNumberException {
        RMMessage mess = this.get(i);
        if (this.isAnonymous && mess.isTwoWayRequest()) {
            return;
        }
        super.acknowledge(i);
        if (this.ackListener != null) {
            this.ackListener.notify(this, i);
        }
        mess.resume();
    }

    public synchronized void acknowledgeResponse(int i) throws InvalidMessageNumberException {
        super.acknowledge(i);
        if (this.ackListener != null) {
            this.ackListener.notify(this, i);
        }
    }

    public synchronized void doMaintenanceTasks() throws RMException {
        if (this.getStoredMessages() > 0 && this.isResendDue()) {
            int top = this.getNextIndex();
            for (int i = 1; i < top; ++i) {
                RMMessage mess = this.get(i);
                if (mess == null || mess.isComplete()) continue;
                LOGGER.fine("Resending message with id [" + this.getId() + "]: " + i);
                this.resend(i);
            }
        } else if (this.isGettingClose(System.currentTimeMillis() - this.getLastActivityTime(), this.getConfig().getInactivityTimeout())) {
            new AckRequestedSender(this).start();
        }
    }

    private class AckRequestedSender
    extends Thread {
        private ClientOutboundSequence sequence;

        AckRequestedSender(ClientOutboundSequence sequence) {
            this.sequence = sequence;
        }

        public void run() {
            try {
                if (sendHeartbeats) {
                    LOGGER.fine(LocalizationMessages.WSRM_2010_HEARTBEAT_MESSAGE_MESSAGE(this.sequence.getId(), System.currentTimeMillis()));
                    ClientOutboundSequence.this.protocolMessageSender.sendAckRequested(this.sequence, ClientOutboundSequence.this.getConfig().getSoapVersion());
                }
            }
            catch (Exception e) {
                LOGGER.fine(LocalizationMessages.WSRM_2009_HEARTBEAT_MESSAGE_EXCEPTION(this.sequence.getId()), e);
                try {
                    RMSource.getRMSource().removeOutboundSequence(this.sequence);
                }
                catch (Exception ex) {
                    LOGGER.severe("Exception occured while removing the outbound sequence [" + this.sequence.getId() + "]", ex);
                }
            }
        }
    }
}

