/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws;

import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.CheckedException;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundFault;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLInput;
import com.sun.xml.ws.api.model.wsdl.WSDLMessage;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOutput;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.wsdl.writer.WSDLGenExtnContext;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.PolicyMerger;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.PolicyConfigParser;
import com.sun.xml.ws.policy.jaxws.WSDLBoundFaultContainer;
import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapUpdateProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelMarshaller;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.policy.sourcemodel.wspolicy.XmlToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class PolicyWSDLGeneratorExtension
extends WSDLGeneratorExtension {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyWSDLGeneratorExtension.class);
    private PolicyMap policyMap;
    private SEIModel seiModel;
    private Class endpointClass;
    private final Collection<PolicySubject> subjects = new LinkedList<PolicySubject>();
    private final PolicyModelMarshaller marshaller = PolicyModelMarshaller.getXmlMarshaller(true);
    private final PolicyMerger merger = PolicyMerger.getMerger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(WSDLGenExtnContext context) {
        LOGGER.entering();
        try {
            this.seiModel = context.getModel();
            this.endpointClass = context.getEndpointClass();
            PolicyMapUpdateProvider[] policyMapUpdateProviders = PolicyUtils.ServiceProvider.load(PolicyMapUpdateProvider.class);
            PolicyMapMutator[] extenders = new PolicyMapExtender[policyMapUpdateProviders.length];
            for (int i = 0; i < policyMapUpdateProviders.length; ++i) {
                extenders[i] = PolicyMapExtender.createPolicyMapExtender();
            }
            String configId = context.getEndpointClass().getName();
            try {
                this.policyMap = PolicyConfigParser.parse(configId, context.getContainer(), extenders);
            }
            catch (PolicyException e) {
                LOGGER.fine(LocalizationMessages.WSP_1027_FAILED_TO_READ_WSIT_CONFIG_FOR_ID(configId), e);
            }
            if (this.policyMap == null) {
                LOGGER.fine(LocalizationMessages.WSP_1034_CREATE_POLICY_MAP_FOR_CONFIG(configId));
                this.policyMap = PolicyMap.createPolicyMap(Arrays.asList(extenders));
            }
            TypedXmlWriter root = context.getRoot();
            root._namespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
            WSBinding binding = context.getBinding();
            try {
                for (int i = 0; i < policyMapUpdateProviders.length; ++i) {
                    policyMapUpdateProviders[i].update((PolicyMapExtender)extenders[i], this.policyMap, this.seiModel, binding);
                    extenders[i].disconnect();
                }
            }
            catch (PolicyException e) {
                throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1048_MAP_UPDATE_FAILED(), (Throwable)e));
            }
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinitionsExtension(TypedXmlWriter definitions) {
        block11: {
            try {
                LOGGER.entering();
                if (this.policyMap == null) {
                    LOGGER.fine(LocalizationMessages.WSP_1020_NOT_MARSHALLING_ANY_POLICIES_POLICY_MAP_IS_NULL());
                    break block11;
                }
                this.subjects.addAll(this.policyMap.getPolicySubjects());
                PolicyModelGenerator generator = PolicyModelGenerator.getGenerator();
                HashSet<String> policyIDsOrNamesWritten = new HashSet<String>();
                for (PolicySubject subject : this.subjects) {
                    Policy policy;
                    if (subject.getSubject() == null) {
                        LOGGER.fine(LocalizationMessages.WSP_1019_NOT_MARSHALLING_WSDL_SUBJ_NULL(subject));
                        continue;
                    }
                    try {
                        policy = subject.getEffectivePolicy(this.merger);
                    }
                    catch (PolicyException e) {
                        throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1029_FAILED_TO_RETRIEVE_EFFECTIVE_POLICY_FOR_SUBJECT(subject.toString()), (Throwable)e));
                    }
                    if (null == policy.getIdOrName() || policyIDsOrNamesWritten.contains(policy.getIdOrName())) {
                        LOGGER.fine(LocalizationMessages.WSP_1047_POLICY_ID_NULL_OR_DUPLICATE(policy));
                        continue;
                    }
                    try {
                        PolicySourceModel policyInfoset = generator.translate(policy);
                        this.marshaller.marshal(policyInfoset, (Object)definitions);
                    }
                    catch (PolicyException e) {
                        throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1051_FAILED_TO_MARSHALL_POLICY(policy.getIdOrName()), (Throwable)e));
                    }
                    policyIDsOrNamesWritten.add(policy.getIdOrName());
                }
            }
            finally {
                LOGGER.exiting();
            }
        }
    }

    public void addServiceExtension(TypedXmlWriter service) {
        LOGGER.entering();
        String serviceName = null == this.seiModel || null == this.endpointClass ? null : WSEndpoint.getDefaultServiceName((Class)this.endpointClass).getLocalPart();
        this.selectAndProcessSubject(service, WSDLService.class, ScopeType.SERVICE, serviceName);
        LOGGER.exiting();
    }

    public void addPortExtension(TypedXmlWriter port) {
        LOGGER.entering();
        String portName = null == this.seiModel || null == this.endpointClass ? null : WSEndpoint.getDefaultPortName((QName)this.seiModel.getServiceQName(), (Class)this.endpointClass).getLocalPart();
        this.selectAndProcessSubject(port, WSDLPort.class, ScopeType.ENDPOINT, portName);
        LOGGER.exiting();
    }

    public void addPortTypeExtension(TypedXmlWriter portType) {
        LOGGER.entering();
        String portTypeName = null == this.seiModel ? null : this.seiModel.getPortTypeName().getLocalPart();
        this.selectAndProcessSubject(portType, WSDLPortType.class, ScopeType.ENDPOINT, portTypeName);
        LOGGER.exiting();
    }

    public void addBindingExtension(TypedXmlWriter binding) {
        LOGGER.entering();
        QName bindingName = null == this.seiModel ? null : this.seiModel.getBoundPortTypeName();
        this.selectAndProcessSubject(binding, WSDLBoundPortType.class, ScopeType.ENDPOINT, bindingName);
        LOGGER.exiting();
    }

    public void addOperationExtension(TypedXmlWriter operation, JavaMethod method) {
        LOGGER.entering();
        this.selectAndProcessSubject(operation, WSDLOperation.class, ScopeType.OPERATION, method);
        LOGGER.exiting();
    }

    public void addBindingOperationExtension(TypedXmlWriter operation, JavaMethod method) {
        LOGGER.entering();
        this.selectAndProcessSubject(operation, WSDLBoundOperation.class, ScopeType.OPERATION, method);
        LOGGER.exiting();
    }

    public void addInputMessageExtension(TypedXmlWriter message, JavaMethod method) {
        LOGGER.entering();
        String messageName = null == method ? null : method.getRequestMessageName();
        this.selectAndProcessSubject(message, WSDLMessage.class, ScopeType.INPUT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addOutputMessageExtension(TypedXmlWriter message, JavaMethod method) {
        LOGGER.entering();
        String messageName = null == method ? null : method.getResponseMessageName();
        this.selectAndProcessSubject(message, WSDLMessage.class, ScopeType.OUTPUT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addFaultMessageExtension(TypedXmlWriter message, JavaMethod method, CheckedException exception) {
        LOGGER.entering();
        String messageName = null == exception ? null : exception.getMessageName();
        this.selectAndProcessSubject(message, WSDLMessage.class, ScopeType.FAULT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addOperationInputExtension(TypedXmlWriter input, JavaMethod method) {
        LOGGER.entering();
        String messageName = null == method ? null : method.getRequestMessageName();
        this.selectAndProcessSubject(input, WSDLInput.class, ScopeType.INPUT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addOperationOutputExtension(TypedXmlWriter output, JavaMethod method) {
        LOGGER.entering();
        String messageName = null == method ? null : method.getResponseMessageName();
        this.selectAndProcessSubject(output, WSDLOutput.class, ScopeType.OUTPUT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addOperationFaultExtension(TypedXmlWriter fault, JavaMethod method, CheckedException exception) {
        LOGGER.entering();
        String messageName = null == exception ? null : exception.getMessageName();
        this.selectAndProcessSubject(fault, WSDLFault.class, ScopeType.FAULT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addBindingOperationInputExtension(TypedXmlWriter input, JavaMethod method) {
        LOGGER.entering();
        String messageName = null == method ? null : method.getOperationName();
        this.selectAndProcessSubject(input, WSDLBoundOperation.class, ScopeType.INPUT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addBindingOperationOutputExtension(TypedXmlWriter output, JavaMethod method) {
        LOGGER.entering();
        String messageName = null == method ? null : method.getOperationName();
        this.selectAndProcessSubject(output, WSDLBoundOperation.class, ScopeType.OUTPUT_MESSAGE, messageName);
        LOGGER.exiting();
    }

    public void addBindingOperationFaultExtension(TypedXmlWriter writer, JavaMethod method, CheckedException exception) {
        LOGGER.entering(writer, method, exception);
        if (this.subjects != null) {
            for (PolicySubject subject : this.subjects) {
                String exceptionName;
                Object concreteSubject;
                if (!this.policyMap.isFaultMessageSubject(subject) || (concreteSubject = subject.getSubject()) == null || !WSDLBoundFaultContainer.class.isInstance(concreteSubject)) continue;
                String string = exceptionName = exception == null ? null : exception.getMessageName();
                if (exceptionName == null) {
                    this.writePolicyOrReferenceIt(subject, writer);
                    continue;
                }
                WSDLBoundFaultContainer faultContainer = (WSDLBoundFaultContainer)concreteSubject;
                WSDLBoundFault fault = faultContainer.getBoundFault();
                WSDLBoundOperation operation = faultContainer.getBoundOperation();
                if (!exceptionName.equals(fault.getName()) || !operation.getName().getLocalPart().equals(method.getOperationName())) continue;
                this.writePolicyOrReferenceIt(subject, writer);
            }
        }
        LOGGER.exiting();
    }

    private void selectAndProcessSubject(TypedXmlWriter xmlWriter, Class clazz, ScopeType scopeType, JavaMethod method) {
        LOGGER.entering(new Object[]{xmlWriter, clazz, scopeType, method});
        if (method == null) {
            this.selectAndProcessSubject(xmlWriter, clazz, scopeType, (String)null);
        } else {
            if (this.subjects != null) {
                for (PolicySubject subject : this.subjects) {
                    if (!method.equals(subject.getSubject())) continue;
                    this.writePolicyOrReferenceIt(subject, xmlWriter);
                }
            }
            this.selectAndProcessSubject(xmlWriter, clazz, scopeType, method.getOperationName());
        }
        LOGGER.exiting();
    }

    private void selectAndProcessSubject(TypedXmlWriter xmlWriter, Class clazz, ScopeType scopeType, QName bindingName) {
        LOGGER.entering(new Object[]{xmlWriter, clazz, scopeType, bindingName});
        if (bindingName == null) {
            this.selectAndProcessSubject(xmlWriter, clazz, scopeType, (String)null);
        } else {
            if (this.subjects != null) {
                for (PolicySubject subject : this.subjects) {
                    if (!bindingName.equals(subject.getSubject())) continue;
                    this.writePolicyOrReferenceIt(subject, xmlWriter);
                }
            }
            this.selectAndProcessSubject(xmlWriter, clazz, scopeType, bindingName.getLocalPart());
        }
        LOGGER.exiting();
    }

    private void selectAndProcessSubject(TypedXmlWriter xmlWriter, Class clazz, ScopeType scopeType, String wsdlName) {
        LOGGER.entering();
        if (this.subjects != null) {
            for (PolicySubject subject : this.subjects) {
                Object concreteSubject;
                if (!PolicyWSDLGeneratorExtension.isCorrectType(this.policyMap, subject, scopeType) || (concreteSubject = subject.getSubject()) == null || !clazz.isInstance(concreteSubject)) continue;
                if (null == wsdlName) {
                    this.writePolicyOrReferenceIt(subject, xmlWriter);
                    continue;
                }
                try {
                    Method getNameMethod = clazz.getDeclaredMethod("getName", new Class[0]);
                    if (!this.stringEqualsToStringOrQName(wsdlName, getNameMethod.invoke(concreteSubject, new Object[0]))) continue;
                    this.writePolicyOrReferenceIt(subject, xmlWriter);
                }
                catch (NoSuchMethodException e) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1011_UNABLE_TO_CHECK_ELEMENT_NAME(clazz.getName(), wsdlName), (Throwable)e));
                }
                catch (IllegalAccessException e) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1011_UNABLE_TO_CHECK_ELEMENT_NAME(clazz.getName(), wsdlName), (Throwable)e));
                }
                catch (InvocationTargetException e) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1011_UNABLE_TO_CHECK_ELEMENT_NAME(clazz.getName(), wsdlName), (Throwable)e));
                }
            }
        }
        LOGGER.exiting();
    }

    private static final boolean isCorrectType(PolicyMap map, PolicySubject subject, ScopeType type) {
        switch (type) {
            case OPERATION: {
                return !map.isInputMessageSubject(subject) && !map.isOutputMessageSubject(subject) && !map.isFaultMessageSubject(subject);
            }
            case INPUT_MESSAGE: {
                return map.isInputMessageSubject(subject);
            }
            case OUTPUT_MESSAGE: {
                return map.isOutputMessageSubject(subject);
            }
            case FAULT_MESSAGE: {
                return map.isFaultMessageSubject(subject);
            }
        }
        return true;
    }

    private boolean stringEqualsToStringOrQName(String first, Object second) {
        return second instanceof QName ? first.equals(((QName)second).getLocalPart()) : first.equals(second);
    }

    private void writePolicyOrReferenceIt(PolicySubject subject, TypedXmlWriter writer) {
        Policy policy;
        try {
            policy = subject.getEffectivePolicy(this.merger);
        }
        catch (PolicyException e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1029_FAILED_TO_RETRIEVE_EFFECTIVE_POLICY_FOR_SUBJECT(subject.toString()), (Throwable)e));
        }
        if (policy != null) {
            if (null == policy.getIdOrName()) {
                PolicyModelGenerator generator = PolicyModelGenerator.getGenerator();
                try {
                    PolicySourceModel policyInfoset = generator.translate(policy);
                    this.marshaller.marshal(policyInfoset, (Object)writer);
                }
                catch (PolicyException pe) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1010_UNABLE_TO_MARSHALL_POLICY_OR_POLICY_REFERENCE(), (Throwable)pe));
                }
            } else {
                TypedXmlWriter policyReference = writer._element(policy.getNamespaceVersion().asQName(XmlToken.PolicyReference), TypedXmlWriter.class);
                policyReference._attribute(XmlToken.Uri.toString(), (Object)('#' + policy.getIdOrName()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ScopeType {
        SERVICE,
        ENDPOINT,
        OPERATION,
        INPUT_MESSAGE,
        OUTPUT_MESSAGE,
        FAULT_MESSAGE;

    }
}

