/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLBoundInput;
import org.jvnet.wom.api.WSDLInput;
import org.jvnet.wom.api.WSDLPart;
import org.jvnet.wom.api.WSDLVisitor;
import org.jvnet.wom.api.binding.wsdl11.mime.MimeContent;
import org.jvnet.wom.api.binding.wsdl11.mime.MimeMultipart;
import org.jvnet.wom.api.binding.wsdl11.mime.MimePart;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBody;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPHeader;
import org.jvnet.wom.impl.WSDLBoundOperationImpl;
import org.jvnet.wom.impl.parser.WSDLDocumentImpl;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLBoundInputImpl
extends WSDLBoundInput {
    private String doc;
    private WSDLBoundOperationImpl parent;

    public WSDLBoundInputImpl(Locator locator, QName name, WSDLDocumentImpl document) {
        super(locator, name);
        this.setOwnerWSDLDocument(document);
    }

    public void setParent(WSDLBoundOperationImpl parent) {
        this.parent = parent;
    }

    @Override
    public String getDocumentation() {
        return this.doc;
    }

    @Override
    public <V, P> V visit(WSDLVisitor<V, P> visitor, P param) {
        return visitor.boundInput(this, param);
    }

    public void setDocumentation(String doc) {
        this.doc = doc;
    }

    @Override
    public WSDLPart.Binding getPartBinding(String partName) {
        Collection<MimeMultipart> mimeMultiparts;
        Collection<SOAPBody> soapBodies;
        int numOfParts = this.parent.getOperation().getInput().getMessage().parts().size();
        Collection<SOAPHeader> headers = this.getExtension(SOAPHeader.class);
        if (headers != null && headers.size() > 0) {
            for (SOAPHeader header : headers) {
                if (!header.getPart().equals(partName)) continue;
                return WSDLPart.Binding.Header;
            }
        }
        if ((soapBodies = this.getExtension(SOAPBody.class)) != null) {
            for (SOAPBody body : soapBodies) {
                if (body.getParts().size() <= 0) continue;
                if (body.getParts().contains(partName)) {
                    return WSDLPart.Binding.Body;
                }
                return WSDLPart.Binding.None;
            }
        }
        if ((mimeMultiparts = this.getExtension(MimeMultipart.class)) != null) {
            for (MimeMultipart multipart : mimeMultiparts) {
                for (MimePart mimepart : multipart.getMimeParts()) {
                    for (MimeContent content : mimepart.getMimeContentParts()) {
                        if (content.getPartName().equals(partName)) {
                            return WSDLPart.Binding.Mime;
                        }
                        if (content.getPartName() != null && !content.getPartName().equals("") || numOfParts != 1) continue;
                        return WSDLPart.Binding.Mime;
                    }
                    SOAPBody body = mimepart.getBodyPart();
                    if (body == null || body.getParts() != null && !body.getParts().contains(partName)) continue;
                    return WSDLPart.Binding.Body;
                }
            }
        }
        return WSDLPart.Binding.None;
    }

    @Override
    public WSDLInput getInput() {
        return this.parent.getOperation().getInput();
    }
}

