/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider;

import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthParam;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.SOAPAuthParam;
import com.sun.enterprise.security.jauth.ServerAuthModule;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.provider.WssProviderAuthModule;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class ServerSecurityAuthModule
extends WssProviderAuthModule
implements ServerAuthModule {
    public void initialize(AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler handler, Map options) {
        super.initialize(requestPolicy, responsePolicy, handler, options, false);
    }

    public void validateRequest(AuthParam param, Subject subject, Map sharedState) throws AuthException {
        try {
            ProcessingContextImpl context = new ProcessingContextImpl();
            this._sEnvironment.setRequesterSubject(subject, context.getExtraneousProperties());
            MessagePolicy receiverCnfg = ((DeclarativeSecurityConfiguration)this._policy).receiverSettings();
            context.setSecurityPolicy(receiverCnfg);
            context.setSOAPMessage(((SOAPAuthParam)param).getRequest());
            context.setSecurityEnvironment(this._sEnvironment);
            SecurityRecipient.validateMessage(context);
            this.populateSharedStateFromContext(sharedState, context);
            context.getSecurableSoapMessage().deleteSecurityHeader();
        }
        catch (XWSSecurityException xwsse) {
            xwsse.printStackTrace();
            throw new AuthException(xwsse.getMessage());
        }
    }

    public void secureResponse(AuthParam param, Subject subject, Map sharedState) throws AuthException {
        try {
            ProcessingContextImpl context = new ProcessingContextImpl();
            this._sEnvironment.setSubject(subject, context.getExtraneousProperties());
            this.populateContextFromSharedState(context, sharedState);
            MessagePolicy senderCnfg = ((DeclarativeSecurityConfiguration)this._policy).senderSettings();
            SOAPMessage msg = ((SOAPAuthParam)param).getResponse();
            context.setSecurityPolicy(senderCnfg);
            context.setSOAPMessage(msg);
            context.setSecurityEnvironment(this._sEnvironment);
            if (this.optimize != 0 && this.isOptimized(msg)) {
                context.setConfigType(this.optimize);
            } else {
                try {
                    msg.getSOAPBody();
                    msg.getSOAPHeader();
                    context.setConfigType(0);
                }
                catch (SOAPException ex) {
                    throw new AuthException(ex.getMessage());
                }
            }
            SecurityAnnotator.secureMessage(context);
        }
        catch (XWSSecurityException xwsse) {
            xwsse.printStackTrace();
            throw new AuthException(xwsse.getMessage());
        }
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        if (subject == null) {
            throw new AuthException("Subject is null in disposeSubject");
        }
        if (!subject.isReadOnly()) {
            return;
        }
        Set<Principal> principals = subject.getPrincipals();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        try {
            principals.clear();
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        Iterator<Object> pi = privateCredentials.iterator();
        while (pi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)pi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
            }
            catch (ClassCastException cce) {}
        }
        Iterator<Object> qi = publicCredentials.iterator();
        while (qi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)qi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
            }
            catch (ClassCastException cce) {}
        }
    }

    private void populateContextFromSharedState(ProcessingContextImpl context, Map sharedState) {
        context.setExtraneousProperty("javax.security.auth.Subject", sharedState.get("REQUESTER_SUBJECT"));
        context.setExtraneousProperty("requester.keyid", sharedState.get("REQUESTER_KEYID"));
        context.setExtraneousProperty("requester.issuername", sharedState.get("REQUESTER_ISSUERNAME"));
        context.setExtraneousProperty("requester.serial", sharedState.get("REQUESTER_SERIAL"));
    }

    private void populateSharedStateFromContext(Map sharedState, ProcessingContextImpl context) {
        sharedState.put("REQUESTER_SUBJECT", context.getExtraneousProperty("javax.security.auth.Subject"));
        sharedState.put("REQUESTER_KEYID", context.getExtraneousProperty("requester.keyid"));
        sharedState.put("REQUESTER_ISSUERNAME", context.getExtraneousProperty("requester.issuername"));
        sharedState.put("REQUESTER_SERIAL", context.getExtraneousProperty("requester.serial"));
    }
}

