/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence
implements Sequence {
    protected final ReadWriteLock messageIdLock = new ReentrantReadWriteLock();
    private final String sequenceId;
    private final String boundSecurityTokenReferenceId;
    private final long expirationTime;
    private final AtomicReference<Sequence.Status> status;
    private final AtomicBoolean ackRequestedFlag;
    private long lastMessageId;
    private long lastActivityTime;

    AbstractSequence(String sequenceId, String securityContextTokenId, long expirationTime, long initalLastMessageId) {
        this.sequenceId = sequenceId;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.expirationTime = expirationTime;
        this.status = new AtomicReference<Sequence.Status>(Sequence.Status.CREATED);
        this.ackRequestedFlag = new AtomicBoolean(false);
        this.lastActivityTime = System.currentTimeMillis();
        this.lastMessageId = initalLastMessageId;
    }

    @Override
    public String getId() {
        return this.sequenceId;
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    @Override
    public long generateNextMessageId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(LocalizationMessages.WSRM_1101_UNSUPPORTED_INTERFACE_OPERATION_IN_IMPLEMENTATION(Sequence.class.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastMessageId() {
        try {
            this.messageIdLock.readLock().lock();
            long l = this.lastMessageId;
            return l;
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
    }

    @Override
    public void storeMessage(long correlationId, long id, Object message) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(LocalizationMessages.WSRM_1101_UNSUPPORTED_INTERFACE_OPERATION_IN_IMPLEMENTATION(Sequence.class.getName()));
    }

    @Override
    public Object retrieveMessage(long correlationId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(LocalizationMessages.WSRM_1101_UNSUPPORTED_INTERFACE_OPERATION_IN_IMPLEMENTATION(Sequence.class.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Sequence.AckRange> getAcknowledgedMessageIds() {
        this.messageIdLock.readLock().lock();
        try {
            if (this.getLastMessageId() == 0L) {
                List<Sequence.AckRange> list = Collections.emptyList();
                return list;
            }
            if (this.getUnackedMessageIdStorage().isEmpty()) {
                List<Sequence.AckRange> list = Arrays.asList(new Sequence.AckRange(1L, this.getLastMessageId()));
                return list;
            }
            LinkedList<Sequence.AckRange> result = new LinkedList<Sequence.AckRange>();
            Iterator<Long> unackedIndexIterator = this.getUnackedMessageIdStorage().iterator();
            long lastBottomAckRange = 1L;
            while (unackedIndexIterator.hasNext()) {
                long lastUnacked = unackedIndexIterator.next();
                if (lastBottomAckRange < lastUnacked) {
                    result.add(new Sequence.AckRange(lastBottomAckRange, lastUnacked - 1L));
                }
                lastBottomAckRange = lastUnacked + 1L;
            }
            if (lastBottomAckRange <= this.getLastMessageId()) {
                result.add(new Sequence.AckRange(lastBottomAckRange, this.getLastMessageId()));
            }
            LinkedList<Sequence.AckRange> linkedList = result;
            return linkedList;
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAcknowledged(long messageId) {
        try {
            this.messageIdLock.readLock().lock();
            if (messageId > this.getLastMessageId()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.getUnackedMessageIdStorage().contains(messageId);
            return bl;
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingAcknowledgements() {
        try {
            this.messageIdLock.readLock().lock();
            boolean bl = !this.getUnackedMessageIdStorage().isEmpty();
            return bl;
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
    }

    @Override
    public Sequence.Status getStatus() {
        return this.status.get();
    }

    @Override
    public void setAckRequestedFlag() {
        this.ackRequestedFlag.set(true);
    }

    @Override
    public void clearAckRequestedFlag() {
        this.ackRequestedFlag.set(false);
    }

    @Override
    public boolean isAckRequested() {
        return this.ackRequestedFlag.get();
    }

    @Override
    public void close() {
        this.status.set(Sequence.Status.CLOSED);
    }

    @Override
    public boolean isClosed() {
        Sequence.Status currentStatus = this.status.get();
        return currentStatus == Sequence.Status.CLOSING || currentStatus == Sequence.Status.CLOSED || currentStatus == Sequence.Status.TERMINATING;
    }

    @Override
    public boolean isExpired() {
        return this.expirationTime == -1L ? false : System.currentTimeMillis() < this.expirationTime;
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    @Override
    public void updateLastActivityTime() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    @Override
    public void preDestroy() {
    }

    abstract Collection<Long> getUnackedMessageIdStorage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long updateLastMessageId(long newValue) {
        try {
            this.messageIdLock.writeLock().lock();
            long oldValue = this.lastMessageId;
            this.lastMessageId = newValue;
            long l = oldValue;
            return l;
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }

    final void setStatus(Sequence.Status newStatus) {
        this.status.set(newStatus);
    }
}

