/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.messagedump;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.messagedump.MessageDumpingFeature;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class MessageDumpingTube
extends AbstractFilterTubeImpl {
    static final String DEFAULT_MSGDUMP_LOGGING_ROOT = "javax.enterprise.resource.webservices.jaxws.messagedump";
    private static final com.sun.xml.ws.commons.Logger TUBE_LOGGER = com.sun.xml.ws.commons.Logger.getLogger("javax.enterprise.resource.webservices.jaxws.messagedump", MessageDumpingTube.class);
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final XMLOutputFactory xmlOutputFactory;
    private final Logger messageLogger;
    private final MessageDumpingFeature messageDumpingFeature;
    private final int tubeId;
    private AtomicBoolean logMissingStaxUtilsWarning;

    MessageDumpingTube(Tube next, MessageDumpingFeature feature) {
        super(next);
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.logMissingStaxUtilsWarning = new AtomicBoolean(false);
        this.messageLogger = Logger.getLogger(feature.getMessageLoggingRoot());
        this.messageDumpingFeature = feature;
        this.tubeId = ID_GENERATOR.incrementAndGet();
    }

    MessageDumpingTube(MessageDumpingTube that, TubeCloner cloner) {
        super(that, cloner);
        this.xmlOutputFactory = that.xmlOutputFactory;
        this.logMissingStaxUtilsWarning = that.logMissingStaxUtilsWarning;
        this.messageLogger = that.messageLogger;
        this.messageDumpingFeature = that.messageDumpingFeature;
        this.tubeId = ID_GENERATOR.incrementAndGet();
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new MessageDumpingTube(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        this.dump(MessageType.Request, this.packetToString(request), Fiber.current().owner.id);
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        this.dump(MessageType.Response, this.packetToString(response), Fiber.current().owner.id);
        return super.processResponse(response);
    }

    public NextAction processException(Throwable t) {
        StringWriter stringOut = new StringWriter();
        t.printStackTrace(new PrintWriter(stringOut));
        this.dump(MessageType.Exception, stringOut.toString(), Fiber.current().owner.id);
        return super.processException(t);
    }

    private void dump(MessageType messageType, String message, String engineId) {
        String logMessage = String.format("%s received on DumpingTube [ %d ] Engine [ %s ] Thread [ %s ]:%n%s", new Object[]{messageType, this.tubeId, engineId, Thread.currentThread().getName(), message});
        if (this.messageDumpingFeature.getMessageLoggingStatus()) {
            this.messageLogger.log(this.messageDumpingFeature.getMessageLoggingLevel(), logMessage);
        }
        this.messageDumpingFeature.offerMessage(logMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String packetToString(Packet packet) {
        StringWriter stringOut = null;
        try {
            stringOut = new StringWriter();
            if (packet.getMessage() == null) {
                stringOut.write("[Empty response]");
            } else {
                XMLStreamWriter writer = null;
                try {
                    writer = this.xmlOutputFactory.createXMLStreamWriter(stringOut);
                    writer = this.createIndenter(writer);
                    packet.getMessage().copy().writeTo(writer);
                }
                catch (XMLStreamException e) {
                    TUBE_LOGGER.log(Level.WARNING, "Unexpected exception occured while dumping message", e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (XMLStreamException ignored) {
                            TUBE_LOGGER.fine("Unexpected exception occured while closing XMLStreamWriter", ignored);
                        }
                    }
                }
            }
            String string2 = stringOut.toString();
            return string2;
        }
        finally {
            if (stringOut != null) {
                try {
                    stringOut.close();
                }
                catch (IOException ex) {
                    TUBE_LOGGER.finest("An exception occured when trying to close StringWriter", ex);
                }
            }
        }
    }

    private XMLStreamWriter createIndenter(XMLStreamWriter writer) {
        block2: {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("javanet.staxutils.IndentingXMLStreamWriter");
                Constructor<?> c = clazz.getConstructor(XMLStreamWriter.class);
                writer = (XMLStreamWriter)XMLStreamWriter.class.cast(c.newInstance(writer));
            }
            catch (Exception ex) {
                if (!this.logMissingStaxUtilsWarning.compareAndSet(false, true)) break block2;
                TUBE_LOGGER.log(Level.WARNING, "Put stax-utils.jar to the classpath to indent the dump output", ex);
            }
        }
        return writer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MessageType {
        Request("Request message"),
        Response("Response message"),
        Exception("Response exception");

        private final String name;

        private MessageType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

