/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.dsig;

import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.ws.security.DerivedKeyToken;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.DerivedKeyTokenImpl;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.DerivedKeyTokenHeaderBlock;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SamlAssertionHeaderBlock;
import com.sun.xml.wss.core.SecurityContextTokenImpl;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.EncryptedKeySHA1Identifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.core.reference.X509ThumbPrintIdentifier;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.dsig.AttachmentData;
import com.sun.xml.wss.impl.dsig.DSigResolver;
import com.sun.xml.wss.impl.dsig.DataWrapper;
import com.sun.xml.wss.impl.dsig.KeySelectorImpl;
import com.sun.xml.wss.impl.dsig.WSSPolicyConsumerImpl;
import com.sun.xml.wss.impl.keyinfo.KeyIdentifierStrategy;
import com.sun.xml.wss.impl.keyinfo.KeyInfoStrategy;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.verifier.SignaturePolicyVerifier;
import com.sun.xml.wss.logging.impl.dsig.LogStringsMessages;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureProcessor {
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static int sign(FilterProcessingContext context) throws XWSSecurityException {
        try {
            block83: {
                block86: {
                    block87: {
                        block81: {
                            block84: {
                                block85: {
                                    block82: {
                                        signaturePolicy = (SignaturePolicy)context.getSecurityPolicy();
                                        soapMessage = context.getSOAPMessage();
                                        secureMessage = context.getSecurableSoapMessage();
                                        keyBinding = (WSSPolicy)signaturePolicy.getKeyBinding();
                                        if (SignatureProcessor.logger.isLoggable(Level.FINEST)) {
                                            SignatureProcessor.logger.log(Level.FINEST, "KeyBinding is " + keyBinding);
                                        }
                                        signingKey /* !! */  = null;
                                        nextSibling = null;
                                        dsigHelper = WSSPolicyConsumerImpl.getInstance();
                                        keyInfo = null;
                                        securityHeader = secureMessage.findOrCreateSecurityHeader();
                                        featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
                                        algSuite = context.getAlgorithmSuite();
                                        wss11Receiver = "true".equals(context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
                                        wss11Sender = "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"));
                                        wss10 = wss11Sender == false;
                                        v0 = sendEKSHA1 = wss11Receiver != false && wss11Sender != false && SignatureProcessor.getEKSHA1Ref(context) != null;
                                        if (PolicyTypeUtil.usernameTokenPolicy(keyBinding)) {
                                            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1326_UNSUPPORTED_USERNAMETOKEN_KEYBINDING());
                                            throw new XWSSecurityException("UsernameToken as KeyBinding for SignaturePolicy is Not Yet Supported");
                                        }
                                        if (!PolicyTypeUtil.derivedTokenKeyBinding(keyBinding)) break block81;
                                        dtk = (DerivedTokenKeyBinding)keyBinding.clone();
                                        originalKeyBinding = dtk.getOriginalKeyBinding();
                                        algorithm = null;
                                        if (algSuite != null) {
                                            algorithm = algSuite.getEncryptionAlgorithm();
                                        }
                                        jceAlgo = SecurityUtil.getSecretKeyAlgorithm(algorithm);
                                        offset = 0L;
                                        length = SecurityUtil.getLengthFromAlgorithm(algorithm);
                                        if (length == 32L) {
                                            length = 24L;
                                        }
                                        if (PolicyTypeUtil.x509CertificateBinding(originalKeyBinding)) {
                                            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1327_UNSUPPORTED_ASYMMETRICBINDING_DERIVEDKEY_X_509_TOKEN());
                                            throw new XWSSecurityException("Asymmetric Binding with DerivedKeys under X509Token Policy Not Yet Supported");
                                        }
                                        if (!PolicyTypeUtil.symmetricKeyBinding(originalKeyBinding)) break block82;
                                        skb = null;
                                        if (context.getSymmetricKeyBinding() != null) {
                                            skb = context.getSymmetricKeyBinding();
                                            context.setSymmetricKeyBinding(null);
                                        }
                                        originalKey = null;
                                        if (context.getCurrentSecret() != null) {
                                            originalKey = context.getCurrentSecret();
                                        } else {
                                            originalKey = skb.getSecretKey();
                                            context.setCurrentSecret(originalKey);
                                        }
                                        secret = originalKey.getEncoded();
                                        dkt = new DerivedKeyTokenImpl(offset, length, secret);
                                        signingKey /* !! */  = dkt.generateSymmetricKey(jceAlgo);
                                        nxtSiblingContainer = new Node[1];
                                        keyInfo = SignatureProcessor.prepareForSymmetricKeySignature(context, keyBinding, originalKey, signaturePolicy, nxtSiblingContainer, null, dkt);
                                        nextSibling = nxtSiblingContainer[0];
                                        break block83;
                                    }
                                    if (!PolicyTypeUtil.issuedTokenKeyBinding(originalKeyBinding)) break block84;
                                    prfKey = context.getTrustContext().getProofKey();
                                    if (prfKey != null) break block85;
                                    cert = context.getTrustContext().getRequestorCertificate();
                                    if (cert == null) {
                                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1328_ILLEGAL_CERTIFICATE_KEY_NULL());
                                        throw new XWSSecurityException("Requestor Certificate and Proof Key are both null for Issued Token");
                                    }
                                    signingKey /* !! */  = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                                    issuedToken = (GenericToken)context.getTrustContext().getSecurityToken();
                                    elem = (Element)issuedToken.getTokenValue();
                                    tokenElem = XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), elem);
                                    tokId = tokenElem.getAttribute("Id");
                                    if ("".equals(tokId) && "EncryptedData".equals(tokenElem.getLocalName())) {
                                        tokenElem.setAttribute("Id", secureMessage.generateId());
                                    }
                                    context.getTokenCache().put(keyBinding.getUUID(), tokenElem);
                                    ikb = (IssuedTokenKeyBinding)originalKeyBinding;
                                    iTokenType = ikb.getIncludeToken();
                                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(iTokenType)) ** GOTO lbl-1000
                                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS.equals(iTokenType)) ** GOTO lbl-1000
                                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_VER2.equals(iTokenType)) ** GOTO lbl-1000
                                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(iTokenType)) lbl-1000:
                                    // 4 sources

                                    {
                                        v1 = true;
                                    } else {
                                        v1 = false;
                                    }
                                    includeToken = v1;
                                    strElem = null;
                                    strElem = includeToken != false ? (Element)context.getTrustContext().getAttachedSecurityTokenReference().getTokenValue() : (Element)context.getTrustContext().getUnAttachedSecurityTokenReference().getTokenValue();
                                    imported = (Element)secureMessage.getSOAPPart().importNode((Node)strElem, true);
                                    str = new SecurityTokenReference(XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), (Element)imported.cloneNode(true)), false);
                                    if (tokenElem != null) {
                                        if (includeToken) {
                                            secureMessage.findOrCreateSecurityHeader().insertHeaderBlockElement(tokenElem);
                                            nextSibling = tokenElem.getNextSibling();
                                        } else {
                                            nextSibling = null;
                                        }
                                        context.setIssuedSAMLToken((Element)tokenElem);
                                    }
                                    keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, str);
                                    SecurityUtil.updateSamlVsKeyCache(str, context, (Key)cert.getPublicKey());
                                    break block83;
                                }
                                dkt = new DerivedKeyTokenImpl(offset, length, prfKey);
                                signingKey /* !! */  = dkt.generateSymmetricKey(jceAlgo);
                                nxtSiblingContainer = new Node[1];
                                secretKeyAlg = "AES";
                                if (algSuite != null) {
                                    secretKeyAlg = SecurityUtil.getSecretKeyAlgorithm(algSuite.getEncryptionAlgorithm());
                                }
                                originalKey = new SecretKeySpec(prfKey, secretKeyAlg);
                                keyInfo = SignatureProcessor.prepareForSymmetricKeySignature(context, keyBinding, originalKey, signaturePolicy, nxtSiblingContainer, null, dkt);
                                nextSibling = nxtSiblingContainer[0];
                                break block83;
                            }
                            if (PolicyTypeUtil.secureConversationTokenKeyBinding(originalKeyBinding)) {
                                dkt = new DerivedKeyTokenImpl(offset, length, context.getSecureConversationContext().getProofKey());
                                signingKey /* !! */  = dkt.generateSymmetricKey(jceAlgo);
                                nxtSiblingContainer = new Node[1];
                                keyInfo = SignatureProcessor.prepareForSymmetricKeySignature(context, keyBinding, null, signaturePolicy, nxtSiblingContainer, null, dkt);
                                nextSibling = nxtSiblingContainer[0];
                            }
                            break block83;
                        }
                        if (!PolicyTypeUtil.issuedTokenKeyBinding(keyBinding)) break block86;
                        nxtSiblingContainer = new Node[1];
                        proofKey = context.getTrustContext().getProofKey();
                        if (proofKey != null) break block87;
                        cert = context.getTrustContext().getRequestorCertificate();
                        if (cert == null) {
                            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1328_ILLEGAL_CERTIFICATE_KEY_NULL());
                            throw new XWSSecurityException("Requestor Certificate and Proof Key are both null for Issued Token");
                        }
                        signingKey /* !! */  = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                        issuedToken = (GenericToken)context.getTrustContext().getSecurityToken();
                        elem = (Element)issuedToken.getTokenValue();
                        tokenElem = XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), elem);
                        tokId = tokenElem.getAttribute("Id");
                        if ("".equals(tokId) && "EncryptedData".equals(tokenElem.getLocalName())) {
                            tokenElem.setAttribute("Id", secureMessage.generateId());
                        }
                        context.getTokenCache().put(keyBinding.getUUID(), tokenElem);
                        ikb = (IssuedTokenKeyBinding)keyBinding;
                        iTokenType = ikb.getIncludeToken();
                        if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(iTokenType)) ** GOTO lbl-1000
                        if (IssuedTokenKeyBinding.INCLUDE_ALWAYS.equals(iTokenType)) ** GOTO lbl-1000
                        if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_VER2.equals(iTokenType)) ** GOTO lbl-1000
                        if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(iTokenType)) lbl-1000:
                        // 4 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        includeToken = v2;
                        strElem = null;
                        strElem = includeToken != false ? (Element)context.getTrustContext().getAttachedSecurityTokenReference().getTokenValue() : (Element)context.getTrustContext().getUnAttachedSecurityTokenReference().getTokenValue();
                        imported = (Element)secureMessage.getSOAPPart().importNode((Node)strElem, true);
                        str = new SecurityTokenReference(XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), (Element)imported.cloneNode(true)), false);
                        if (tokenElem != null) {
                            if (includeToken) {
                                secureMessage.findOrCreateSecurityHeader().insertHeaderBlockElement(tokenElem);
                                nextSibling = tokenElem.getNextSibling();
                            } else {
                                nextSibling = null;
                            }
                            context.setIssuedSAMLToken((Element)tokenElem);
                        }
                        keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, str);
                        SecurityUtil.updateSamlVsKeyCache(str, context, (Key)cert.getPublicKey());
                        break block83;
                    }
                    secretKeyAlg = "AES";
                    if (algSuite != null) {
                        secretKeyAlg = SecurityUtil.getSecretKeyAlgorithm(algSuite.getEncryptionAlgorithm());
                    }
                    signingKey /* !! */  = new SecretKeySpec(proofKey, secretKeyAlg);
                    keyInfo = SignatureProcessor.prepareForSymmetricKeySignature(context, keyBinding, signingKey /* !! */ , signaturePolicy, nxtSiblingContainer, null, null);
                    nextSibling = nxtSiblingContainer[0];
                    break block83;
                }
                if (PolicyTypeUtil.secureConversationTokenKeyBinding(keyBinding)) {
                    nxtSiblingContainer = new Node[1];
                    keyInfo = SignatureProcessor.prepareForSymmetricKeySignature(context, keyBinding, null, signaturePolicy, nxtSiblingContainer, null, null);
                    secretKeyAlg = "AES";
                    if (algSuite != null) {
                        secretKeyAlg = SecurityUtil.getSecretKeyAlgorithm(algSuite.getEncryptionAlgorithm());
                    }
                    signingKey /* !! */  = new SecretKeySpec(context.getSecureConversationContext().getProofKey(), secretKeyAlg);
                    nextSibling = nxtSiblingContainer[0];
                } else if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
                    certInfo = null;
                    if (context.getX509CertificateBinding() != null) {
                        certInfo = context.getX509CertificateBinding();
                        context.setX509CertificateBinding(null);
                    } else {
                        certInfo = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
                    }
                    privKBinding = (PrivateKeyBinding)certInfo.getKeyBinding();
                    signingKey /* !! */  = privKBinding.getPrivateKey();
                    nxtSiblingContainer = new Node[1];
                    keyInfo = SignatureProcessor.handleX509Binding(context, signaturePolicy, certInfo, nxtSiblingContainer);
                    nextSibling = nxtSiblingContainer[0];
                } else if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
                    samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                    privKBinding = (PrivateKeyBinding)samlBinding.getKeyBinding();
                    if (privKBinding == null) {
                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1329_NULL_PRIVATEKEYBINDING_SAML_POLICY());
                        throw new XWSSecurityException("PrivateKey binding not set for SAML Policy by CallbackHandler");
                    }
                    signingKey /* !! */  = privKBinding.getPrivateKey();
                    if (signingKey /* !! */  == null) {
                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1330_NULL_PRIVATEKEY_SAML_POLICY());
                        throw new XWSSecurityException("PrivateKey null inside PrivateKeyBinding set for SAML Policy ");
                    }
                    referenceType = samlBinding.getReferenceType();
                    if (referenceType.equals("Embedded")) {
                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1331_UNSUPPORTED_EMBEDDED_REFERENCE_SAML());
                        throw new XWSSecurityException("Embedded Reference Type for SAML Assertions not supported yet");
                    }
                    assertionId = samlBinding.getAssertionId();
                    _assertion = samlBinding.getAssertion();
                    _authorityBinding = samlBinding.getAuthorityBinding();
                    if (assertionId == null) {
                        if (_assertion == null) {
                            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1332_NULL_SAML_ASSERTION_SAML_ASSERTION_ID());
                            throw new XWSSecurityException("None of SAML Assertion, SAML Assertion Id information was set into  the Policy by the CallbackHandler");
                        }
                        assertionId = _assertion.getAttributeNode("ID") != null ? _assertion.getAttribute("ID") : _assertion.getAttribute("AssertionID");
                    }
                    tokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                    strId = samlBinding.getSTRID();
                    if (strId == null) {
                        strId = secureMessage.generateId();
                    }
                    tokenRef.setWsuId(strId);
                    if (_assertion.getAttributeNode("ID") != null) {
                        tokenRef.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    } else {
                        tokenRef.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                    }
                    if (_authorityBinding != null) {
                        tokenRef.setSamlAuthorityBinding(_authorityBinding, (Document)secureMessage.getSOAPPart());
                    }
                    if (_assertion != null && _authorityBinding == null) {
                        samlHeaderblock = new SamlAssertionHeaderBlock(_assertion, (Document)secureMessage.getSOAPPart());
                        secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(samlHeaderblock);
                        strat = new KeyIdentifierStrategy(assertionId);
                        strat.insertKey(tokenRef, secureMessage);
                        keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, tokenRef);
                        nextSibling = samlHeaderblock.getAsSoapElement().getNextSibling();
                    } else {
                        nextSibling = securityHeader.getNextSiblingOfTimestamp();
                    }
                } else if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
                    skb = null;
                    if (context.getSymmetricKeyBinding() != null) {
                        skb = context.getSymmetricKeyBinding();
                        context.setSymmetricKeyBinding(null);
                    } else {
                        skb = (SymmetricKeyBinding)keyBinding;
                    }
                    if (!skb.getKeyIdentifier().equals(MessageConstants._EMPTY)) {
                        signingKey /* !! */  = skb.getSecretKey();
                        symmetricKeyName = skb.getKeyIdentifier();
                        keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, symmetricKeyName);
                        nextSibling = securityHeader.getNextSiblingOfTimestamp();
                    } else if (sendEKSHA1) {
                        ekSha1Ref = SignatureProcessor.getEKSHA1Ref(context);
                        signingKey /* !! */  = skb.getSecretKey();
                        secTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                        refElem = new EncryptedKeySHA1Identifier((Document)secureMessage.getSOAPPart());
                        refElem.setReferenceValue(ekSha1Ref);
                        secTokenRef.setReference(refElem);
                        keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, secTokenRef);
                        nextSibling = securityHeader.getNextSiblingOfTimestamp();
                    } else if (wss11Sender || wss10) {
                        signingKey /* !! */  = skb.getSecretKey();
                        x509Binding = null;
                        cert = null;
                        if (!skb.getCertAlias().equals(MessageConstants._EMPTY)) {
                            x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                            x509Binding.newPrivateKeyBinding();
                            x509Binding.setCertificateIdentifier(skb.getCertAlias());
                            cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), x509Binding.getCertificateIdentifier(), false);
                            x509Binding.setX509Certificate(cert);
                            x509Binding.setReferenceType("Direct");
                        } else if (context.getX509CertificateBinding() != null) {
                            x509Binding = context.getX509CertificateBinding();
                            context.setX509CertificateBinding(null);
                            cert = x509Binding.getX509Certificate();
                        }
                        tokenCache = context.getTokenCache();
                        insertedX509Cache = context.getInsertedX509Cache();
                        x509id = x509Binding.getUUID();
                        if (x509id == null || x509id.equals("")) {
                            x509id = secureMessage.generateId();
                        }
                        SecurityUtil.checkIncludeTokenPolicy(context, x509Binding, x509id);
                        keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
                        tmp = null;
                        if (algSuite != null) {
                            tmp = algSuite.getAsymmetricKeyAlgorithm();
                        }
                        if (tmp != null && !"".equals(tmp)) {
                            keyEncAlgo = tmp;
                        }
                        if ((referenceType = x509Binding.getReferenceType()).equals("Identifier") && x509Binding.getValueType().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1")) {
                            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1333_UNSUPPORTED_KEYIDENTIFER_X_509_V_1());
                            throw new XWSSecurityException("Key Identifier strategy in X509v1 is not supported");
                        }
                        strategy = KeyInfoStrategy.getInstance(referenceType);
                        keyInfoBlock = null;
                        secureMessage = context.getSecurableSoapMessage();
                        dsigHelper = WSSPolicyConsumerImpl.getInstance();
                        token = null;
                        cert = x509Binding.getX509Certificate();
                        x509TokenId = x509Binding.getUUID();
                        tokenInserted = false;
                        if (x509TokenId == null || x509TokenId.equals("")) {
                            x509TokenId = secureMessage.generateId();
                        }
                        token = (X509SecurityToken)tokenCache.get(x509TokenId);
                        insertedx509 = (X509SecurityToken)context.getInsertedX509Cache().get(x509TokenId);
                        if (token == null) {
                            valueType = x509Binding.getValueType();
                            if (valueType == null || valueType.equals("")) {
                                valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
                            }
                            token = new X509SecurityToken((Document)secureMessage.getSOAPPart(), cert, x509TokenId, valueType);
                            tokenCache.put(x509TokenId, token);
                        } else {
                            tokenInserted = true;
                        }
                        id = null;
                        ekCache = context.getEncryptedKeyCache();
                        if (!tokenInserted) {
                            context.setCurrentSecret(signingKey /* !! */ );
                            context.setExtraneousProperty("SecretKey", signingKey /* !! */ );
                            keyInfoBlock = new KeyInfoHeaderBlock((Document)secureMessage.getSOAPPart());
                            strategy.setCertificate(cert);
                            strategy.insertKey(keyInfoBlock, secureMessage, x509TokenId);
                            apacheKeyInfo = keyInfoBlock.getKeyInfo();
                            encryptedKey = null;
                            keyEncryptor = null;
                            try {
                                keyEncryptor = XMLCipher.getInstance(keyEncAlgo);
                                keyEncryptor.init(3, cert.getPublicKey());
                                if (keyEncryptor != null) {
                                    encryptedKey = keyEncryptor.encryptKey((Document)secureMessage.getSOAPPart(), signingKey /* !! */ );
                                }
                            }
                            catch (Exception e) {
                                SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1334_ERROR_CREATING_ENCRYPTEDKEY());
                                throw new XWSSecurityException(e);
                            }
                            id = secureMessage.generateId();
                            encryptedKey.setId(id);
                            ekCache.put(x509TokenId, id);
                            encryptedKey.setKeyInfo(apacheKeyInfo);
                            se = (SOAPElement)keyEncryptor.martial(encryptedKey);
                            if (insertedx509 == null) {
                                secureMessage.findOrCreateSecurityHeader().insertHeaderBlockElement(se);
                            } else {
                                secureMessage.findOrCreateSecurityHeader().insertBefore((Node)se, insertedx509.getNextSibling());
                            }
                            cipherData = (Element)se.getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                            cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                            decodedCipher = Base64.decode(cipherValue);
                            ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                            encEkSha1 = Base64.encode(ekSha1);
                            context.setExtraneousProperty("EncryptedKeySHA1", encEkSha1);
                            nextSibling = se.getNextSibling();
                        } else {
                            id = (String)ekCache.get(x509TokenId);
                            signingKey /* !! */  = context.getCurrentSecret();
                            nextSibling = secureMessage.getElementById(id).getNextSibling();
                        }
                        if ("Direct".equals(referenceType) && insertedx509 == null) {
                            secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(token);
                            insertedX509Cache.put(x509TokenId, token);
                        }
                        secTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                        reference = new DirectReference();
                        strId = x509Binding.getSTRID();
                        if (strId == null) {
                            strId = secureMessage.generateId();
                        }
                        secTokenRef.setWsuId(strId);
                        reference.setURI("#" + id);
                        reference.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                        secTokenRef.setReference(reference);
                        keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, secTokenRef);
                    }
                } else {
                    SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1335_UNSUPPORTED_KEYBINDING_SIGNATUREPOLICY());
                    throw new XWSSecurityException("Unsupported Key Binding for SignaturePolicy");
                }
            }
            nodeList = securityHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
            if (nodeList != null && nodeList.getLength() > 0) {
                nextSibling = nodeList.item(0).getNextSibling();
            }
            if ((refList = context.getCurrentRefList()) != null) {
                nextSibling = refList;
                context.setCurrentReferenceList(null);
            }
            if (featureBinding.isEndorsingSignature()) {
                nextSibling = securityHeader.getLastChild().getNextSibling();
            }
            signedInfo = WSSPolicyConsumerImpl.getInstance().constructSignedInfo(context);
            signContext = null;
            signContext = nextSibling == null ? new DOMSignContext(signingKey /* !! */ , (Node)securityHeader.getAsSoapElement()) : new DOMSignContext(signingKey /* !! */ , (Node)securityHeader.getAsSoapElement(), nextSibling);
            signContext.setURIDereferencer(DSigResolver.getInstance());
            signature = dsigHelper.constructSignature(signedInfo, keyInfo, signaturePolicy.getUUID());
            signContext.put("http://wss.sun.com#processingContext", context);
            signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            signature.sign(signContext);
            scList = (ArrayList)context.getExtraneousProperty("SignatureConfirmation");
            if (scList != null) {
                scList.add(Base64.encode(signature.getSignatureValue().getValue()));
            }
        }
        catch (XWSSecurityException xe) {
            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1316_SIGN_FAILED(), xe);
            throw xe;
        }
        catch (Exception ex) {
            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1316_SIGN_FAILED(), ex);
            throw new XWSSecurityException(ex);
        }
        return 0;
    }

    public static int verify(FilterProcessingContext context) throws XWSSecurityException {
        try {
            SecurityPolicy policy;
            WSSPolicyConsumerImpl dsigUtil = WSSPolicyConsumerImpl.getInstance();
            SOAPElement signElement = context.getSecurableSoapMessage().findSecurityHeader().getCurrentHeaderElement();
            if (signElement == null || signElement.getLocalName() == null || !"Signature".equals(signElement.getLocalName())) {
                String localName = signElement != null ? signElement.getLocalName() : "";
                context.setPVE(new PolicyViolationException("Expected Signature Element as per receiver requirements, found  " + localName));
                context.isPrimaryPolicyViolation(true);
                int n = 0;
                return n;
            }
            DOMValidateContext validationContext = new DOMValidateContext(KeySelectorImpl.getInstance(), (Node)signElement);
            XMLSignatureFactory signatureFactory = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            XMLSignature signature = signatureFactory.unmarshalXMLSignature(validationContext);
            ArrayList scList = (ArrayList)context.getExtraneousProperty("receivedSignValues");
            if (scList != null) {
                scList.add(Base64.encode(signature.getSignatureValue().getValue()));
            }
            validationContext.setURIDereferencer(DSigResolver.getInstance());
            validationContext.put("http://wss.sun.com#processingContext", context);
            SignaturePolicy currentMessagePolicy = null;
            if (context.getMode() == 0 || context.getMode() == 1) {
                currentMessagePolicy = new SignaturePolicy();
                context.setInferredPolicy(currentMessagePolicy);
            } else if (context.getMode() == 3) {
                currentMessagePolicy = new SignaturePolicy();
                context.getInferredSecurityPolicy().append(currentMessagePolicy);
            }
            boolean coreValidity = signature.validate(validationContext);
            SecurityPolicy securityPolicy = context.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            if (!coreValidity) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Signature failed core validation");
                    boolean sv = signature.getSignatureValue().validate(validationContext);
                    logger.log(Level.FINEST, "Signature validation status: " + sv);
                    Iterator i = signature.getSignedInfo().getReferences().iterator();
                    int j = 0;
                    while (i.hasNext()) {
                        Reference ref = (Reference)i.next();
                        logger.log(Level.FINEST, "Reference ID " + ref.getId());
                        logger.log(Level.FINEST, "Reference URI " + ref.getURI());
                        boolean refValid = ref.validate(validationContext);
                        logger.log(Level.FINEST, "Reference[" + j + "] validity status: " + refValid);
                        ++j;
                    }
                }
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1315_SIGNATURE_VERIFICATION_FAILED());
                XWSSecurityException xwsse = new XWSSecurityException("Signature verification failed");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Signature verification failed ", xwsse);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINE, "Signature Passed Core Validation");
            }
            SignedInfo signInfo = signature.getSignedInfo();
            if (isBSP) {
                Iterator i = signInfo.getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference reference = (Reference)i.next();
                    Iterator t = reference.getTransforms().iterator();
                    int index = 0;
                    while (t.hasNext()) {
                        Transform transform = (Transform)t.next();
                        if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(transform.getAlgorithm())) {
                            logger.log(Level.SEVERE, LogStringsMessages.WSS_1336_ILLEGAL_ENVELOPEDSIGNATURE());
                            throw new XWSSecurityException("Enveloped signatures not permitted by BSP");
                        }
                        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(transform.getAlgorithm()) && transform.getParameterSpec() != null) {
                            ExcC14NParameterSpec spec = (ExcC14NParameterSpec)transform.getParameterSpec();
                            if (spec.getPrefixList().isEmpty()) {
                                logger.log(Level.SEVERE, LogStringsMessages.WSS_1337_INVALID_EMPTYPREFIXLIST());
                            }
                            throw new XWSSecurityException("Prefix List cannot be empty: violation of BSP 5407");
                        }
                        ++index;
                    }
                    ++j;
                }
            }
            if (context.getMode() == 1) {
                policy = (MessagePolicy)context.getSecurityPolicy();
                dsigUtil.constructSignaturePolicy(signInfo, ((MessagePolicy)policy).isBSP(), currentMessagePolicy);
                ((MessagePolicy)policy).append(currentMessagePolicy);
            }
            if (context.getMode() == 0) {
                SignatureProcessor.verifyRequirements(context, signature, validationContext);
                policy = (SignaturePolicy)context.getSecurityPolicy();
                dsigUtil.constructSignaturePolicy(signInfo, ((WSSPolicy)policy).isBSP(), currentMessagePolicy);
                SignaturePolicyVerifier spv = new SignaturePolicyVerifier(context);
                spv.verifyPolicy(policy, currentMessagePolicy);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINE, "Reciever Requirements  are met");
                }
            }
            if (context.getMode() == 3) {
                dsigUtil.constructSignaturePolicy(signInfo, currentMessagePolicy, context.getSecurableSoapMessage());
            }
        }
        catch (XWSSecurityException xwe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1338_ERROR_VERIFY());
            throw xwe;
        }
        catch (XMLSignatureException xse) {
            Throwable t1 = xse.getCause();
            if (t1 == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1338_ERROR_VERIFY());
                throw new XWSSecurityException(xse);
            }
            if (t1 instanceof KeySelectorException || t1 instanceof URIReferenceException) {
                Throwable t2 = t1.getCause();
                if (t2 != null && t2 instanceof WssSoapFaultException) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1338_ERROR_VERIFY());
                    throw (WssSoapFaultException)t2;
                }
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1338_ERROR_VERIFY());
                throw new XWSSecurityException((Exception)t1);
            }
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1338_ERROR_VERIFY());
            throw new XWSSecurityException(xse);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1338_ERROR_VERIFY());
            throw new XWSSecurityException(ex);
        }
        finally {
            context.setInferredPolicy(null);
        }
        return 0;
    }

    public static void verifyRequirements(FilterProcessingContext context, XMLSignature signature, DOMValidateContext validationContext) throws Exception {
        int i;
        SignaturePolicy policy = (SignaturePolicy)context.getSecurityPolicy();
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
        WSSPolicyConsumerImpl dsigUtil = WSSPolicyConsumerImpl.getInstance();
        ArrayList targets = featureBinding.getTargetBindings();
        if (targets == null || targets.size() == 0) {
            return;
        }
        SignedInfo signedInfo = signature.getSignedInfo();
        List signedReferences = signedInfo.getReferences();
        ListIterator sr = signedReferences.listIterator();
        ArrayList<DataWrapper> signedDataList = new ArrayList<DataWrapper>();
        ArrayList<Reference> signedReferenceList = new ArrayList<Reference>();
        while (sr.hasNext()) {
            Reference reference = (Reference)sr.next();
            Data tmpObj = SignatureProcessor.getData(reference, validationContext);
            signedDataList.add(new DataWrapper(tmpObj));
            signedReferenceList.add(reference);
        }
        ArrayList<SignatureTarget> optionalReqList = new ArrayList<SignatureTarget>();
        ArrayList<DataWrapper> requiredDataList = new ArrayList<DataWrapper>();
        ArrayList<Reference> requiredReferenceList = new ArrayList<Reference>();
        ArrayList<DataWrapper> optionalDataList = new ArrayList<DataWrapper>();
        ArrayList<Reference> optionalReferenceList = new ArrayList<Reference>();
        Iterator targetItr = targets.iterator();
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        while (targetItr.hasNext()) {
            List referenceList;
            boolean requiredTarget;
            SignatureTarget signatureTarget;
            block26: {
                signatureTarget = (SignatureTarget)targetItr.next();
                requiredTarget = signatureTarget.getEnforce();
                referenceList = null;
                try {
                    if (requiredTarget) {
                        referenceList = dsigUtil.generateReferenceList(Collections.singletonList(signatureTarget), secureMessage, context, true, featureBinding.isEndorsingSignature());
                    } else {
                        optionalReqList.add(signatureTarget);
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "WSS1302.reflist_error", ex);
                    if (!requiredTarget) break block26;
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1339_INVALID_RECEIVER_REQUIREMENTS());
                    throw new XWSSecurityException("Receiver requirement for SignatureTarget " + signatureTarget.getValue() + " is not met");
                }
            }
            if (!requiredTarget) continue;
            if (referenceList.size() <= 0) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1339_INVALID_RECEIVER_REQUIREMENTS());
                throw new XWSSecurityException("Receiver requirement for SignatureTarget " + signatureTarget.getValue() + " is not met");
            }
            boolean allRef = false;
            for (int i2 = 0; i2 < referenceList.size(); ++i2) {
                Reference reference = (Reference)referenceList.get(i2);
                Data data = null;
                try {
                    data = SignatureProcessor.getData(reference, validationContext);
                    if (!requiredTarget || data == null) continue;
                    DataWrapper tmpObj = new DataWrapper(data);
                    tmpObj.setTarget(signatureTarget);
                    requiredDataList.add(tmpObj);
                    requiredReferenceList.add(reference);
                    continue;
                }
                catch (Exception ex) {
                    if (!requiredTarget) continue;
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1339_INVALID_RECEIVER_REQUIREMENTS());
                    throw new XWSSecurityException("Receiver requirement for SignatureTarget " + signatureTarget.getValue() + " is not met");
                }
            }
        }
        if (optionalReqList.size() == 0 && requiredReferenceList.size() != signedReferenceList.size()) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1340_ILLEGAL_UNMATCHED_NOOF_TARGETS());
            throw new XWSSecurityException("Number of Targets in the message dont match number of Targets in receiver requirements");
        }
        if (requiredDataList.size() == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "No mandatory receiver requirements were provided");
            }
            return;
        }
        for (int i3 = 0; i3 < requiredDataList.size(); ++i3) {
            DataWrapper rData = (DataWrapper)requiredDataList.get(i3);
            boolean found = false;
            for (int j = 0; j < signedDataList.size(); ++j) {
                DataWrapper sData = null;
                sData = (DataWrapper)signedDataList.get(j);
                if (!SignatureProcessor.isEqual(rData, sData, (Reference)requiredReferenceList.get(i3), (Reference)signedReferenceList.get(j))) continue;
                signedDataList.remove(j);
                signedReferenceList.remove(j);
                found = true;
                break;
            }
            if (found) continue;
            String uri = rData.getTarget().getValue();
            String type = rData.getTarget().getType();
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1341_ILLEGAL_UNMATCHED_TYPE_URI());
            throw new XWSSecurityException("Receiver requirement for SignatureTarget having " + type + " type and value " + uri + " is not met");
        }
        if (signedDataList.size() == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "All receiver requirements are met");
            }
            return;
        }
        List referenceList = null;
        for (i = 0; i < optionalReqList.size(); ++i) {
            SignatureTarget signatureTarget;
            block27: {
                signatureTarget = (SignatureTarget)optionalReqList.get(i);
                try {
                    referenceList = null;
                    referenceList = dsigUtil.generateReferenceList(Collections.singletonList(signatureTarget), secureMessage, context, true, featureBinding.isEndorsingSignature());
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.FINE)) break block27;
                    logger.log(Level.FINE, "Optional Target not found in the message ", ex);
                }
            }
            if (referenceList == null || referenceList.size() <= 0) continue;
            Reference reference = (Reference)referenceList.get(0);
            Data data = null;
            try {
                data = SignatureProcessor.getData(reference, validationContext);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (data == null) continue;
            DataWrapper tmpObj = new DataWrapper(data);
            tmpObj.setTarget(signatureTarget);
            optionalDataList.add(tmpObj);
            optionalReferenceList.add(reference);
        }
        for (i = 0; i < signedDataList.size(); ++i) {
            DataWrapper sData = (DataWrapper)signedDataList.get(i);
            DataWrapper oData = null;
            boolean found = false;
            for (int j = 0; j < optionalDataList.size(); ++j) {
                oData = (DataWrapper)optionalDataList.get(j);
                if (!SignatureProcessor.isEqual(oData, sData, (Reference)optionalReferenceList.get(j), (Reference)signedReferenceList.get(i))) continue;
                optionalDataList.remove(j);
                optionalReferenceList.remove(j);
                found = true;
                break;
            }
            if (found) continue;
            Reference st = (Reference)signedReferenceList.get(i);
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1341_ILLEGAL_UNMATCHED_TYPE_URI());
            throw new XWSSecurityException("SignatureTarget in the message with URI " + st.getURI() + " has not met receiver requirements");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "All receiver requirements are met");
        }
    }

    private static boolean isEqual(DataWrapper data1, DataWrapper data2, Reference ref1, Reference ref2) throws XWSSecurityException {
        if (data1.isNodesetData() && data2.isNodesetData()) {
            NodeSetData ns1 = (NodeSetData)data1.getData();
            NodeSetData ns2 = (NodeSetData)data2.getData();
            Node nsd1Root = null;
            Node nsd2Root = null;
            if (ns1 instanceof DOMSubTreeData) {
                nsd1Root = ((DOMSubTreeData)ns1).getRoot();
            }
            if (ns2 instanceof DOMSubTreeData) {
                nsd2Root = ((DOMSubTreeData)ns2).getRoot();
            }
            return nsd1Root != null && nsd2Root != null && (nsd1Root.isSameNode(nsd2Root) || nsd1Root.isEqualNode(nsd2Root));
        }
        if (data1.isOctectData() && data2.isOctectData()) {
            OctetStreamData osd1 = (OctetStreamData)data1.getData();
            OctetStreamData osd2 = (OctetStreamData)data2.getData();
            InputStream stream1 = osd1.getOctetStream();
            InputStream stream2 = osd2.getOctetStream();
            byte[] b1 = new byte[128];
            byte[] b2 = new byte[128];
            block2: while (true) {
                int len1 = 0;
                int len2 = 0;
                try {
                    len1 = stream1.read(b1);
                    len2 = stream2.read(b2);
                }
                catch (IOException ioEx) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Error occurred whilecomparing OctetStreamData objects " + ioEx.getMessage());
                    }
                    return false;
                }
                if (len1 == -1 && len2 == -1) break;
                if (len1 != len2) {
                    return false;
                }
                int i = 0;
                while (true) {
                    if (i >= len1) continue block2;
                    if (b1[i] != b2[i]) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            return true;
        }
        if (data1.isAttachmentData() && data2.isAttachmentData()) {
            AttachmentData ad1 = (AttachmentData)data1.getData();
            AttachmentData ad2 = (AttachmentData)data2.getData();
            String uriOne = ad1.getAttachmentPart().getContentId();
            String uriTwo = ad2.getAttachmentPart().getContentId();
            if (uriOne != null && uriOne.equals(uriTwo)) {
                return SignatureProcessor.isTransformsEqual(ref1, ref2);
            }
            return false;
        }
        return false;
    }

    private static boolean isTransformsEqual(Reference ref1, Reference ref2) throws XWSSecurityException {
        List tList1 = ref1.getTransforms();
        List tList2 = ref2.getTransforms();
        if (tList1.size() != tList2.size()) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1342_ILLEGAL_UNMATCHED_TRANSFORMS());
            throw new XWSSecurityException("Receiver Requirements for the transforms are not met");
        }
        for (int i = 0; i < tList1.size(); ++i) {
            Transform tr1 = (Transform)tList1.get(i);
            Transform tr2 = (Transform)tList2.get(i);
            String alg1 = tr1.getAlgorithm();
            String alg2 = tr2.getAlgorithm();
            if (alg1 == alg2 || alg1 != null && alg1.equals(alg2)) continue;
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1342_ILLEGAL_UNMATCHED_TRANSFORMS());
            throw new XWSSecurityException("Receiver Requirements for the transforms are not met");
        }
        return true;
    }

    private static Data getData(Reference reference, DOMValidateContext context) throws Exception {
        final String uri = reference.getURI();
        URIReference uriRef = new URIReference(){

            public String getURI() {
                return uri;
            }

            public String getType() {
                return null;
            }
        };
        Data inputData = DSigResolver.getInstance().dereference(uriRef, context);
        if (inputData instanceof AttachmentData) {
            return inputData;
        }
        List transformList = reference.getTransforms();
        for (Transform transform : transformList) {
            inputData = SignatureProcessor.getData(transform, inputData, context);
        }
        return inputData;
    }

    private static Data getData(Transform transform, Data inputData, DOMValidateContext context) throws Exception {
        String transformAlgo = transform.getAlgorithm();
        if (transformAlgo == "http://www.w3.org/TR/1999/REC-xpath-19991116" || transformAlgo == "http://www.w3.org/2002/06/xmldsig-filter2" || transformAlgo == "http://www.w3.org/TR/1999/REC-xslt-19991116") {
            TransformService transformImpl = TransformService.getInstance(transformAlgo, "DOM");
            TransformParameterSpec transformParams = null;
            transformParams = (TransformParameterSpec)transform.getParameterSpec();
            transformImpl.init(transformParams);
            return transformImpl.transform(inputData, context);
        }
        return inputData;
    }

    public static boolean verifySignature(Element signElement, FilterProcessingContext context) throws XWSSecurityException {
        try {
            DOMValidateContext validationContext = new DOMValidateContext(KeySelectorImpl.getInstance(), (Node)signElement);
            XMLSignatureFactory signatureFactory = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            XMLSignature signature = signatureFactory.unmarshalXMLSignature(validationContext);
            validationContext.setURIDereferencer(DSigResolver.getInstance());
            validationContext.put("http://wss.sun.com#processingContext", context);
            boolean coreValidity = signature.validate(validationContext);
            if (!coreValidity && logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Signature failed core validation");
                boolean sv = signature.getSignatureValue().validate(validationContext);
                logger.log(Level.FINEST, "Signature validation status: " + sv);
                Iterator i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference ref = (Reference)i.next();
                    logger.log(Level.FINEST, "Reference ID " + ref.getId());
                    logger.log(Level.FINEST, "Reference URI " + ref.getURI());
                    boolean refValid = ref.validate(validationContext);
                    logger.log(Level.FINEST, "Reference[" + j + "] validity status: " + refValid);
                    ++j;
                }
            }
            return coreValidity;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred during signature verification" + e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static KeyInfo prepareForSymmetricKeySignature(FilterProcessingContext context, WSSPolicy keyBinding, Key originalKey, SignaturePolicy signaturePolicy, Node[] nxtSiblingContainer, AuthenticationTokenPolicy.X509CertificateBinding certInfo, DerivedKeyToken dkt) throws XWSSecurityException {
        block67: {
            nextSibling = null;
            keyInfo = null;
            keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            if (context.getAlgorithmSuite() != null) {
                keyEncAlgo = context.getAlgorithmSuite().getAsymmetricKeyAlgorithm();
            }
            referenceType = null;
            strategy = null;
            keyInfoBlock = null;
            secureMessage = context.getSecurableSoapMessage();
            securityHeader = secureMessage.findOrCreateSecurityHeader();
            dsigHelper = WSSPolicyConsumerImpl.getInstance();
            wss11Receiver = "true".equals(context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
            wss11Sender = "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"));
            sendEKSHA1 = wss11Receiver != false && wss11Sender != false && SignatureProcessor.getEKSHA1Ref(context) != null;
            wss10 = wss11Sender == false;
            try {
                block70: {
                    block68: {
                        block69: {
                            if (!PolicyTypeUtil.derivedTokenKeyBinding(keyBinding)) break block68;
                            dtk = (DerivedTokenKeyBinding)keyBinding.clone();
                            originalKeyBinding = dtk.getOriginalKeyBinding();
                            if (PolicyTypeUtil.x509CertificateBinding(originalKeyBinding)) {
                                SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1327_UNSUPPORTED_ASYMMETRICBINDING_DERIVEDKEY_X_509_TOKEN());
                                throw new XWSSecurityException("Asymmetric Binding with DerivedKeys under X509Token Policy Not Yet Supported");
                            }
                            if (PolicyTypeUtil.symmetricKeyBinding(originalKeyBinding)) {
                                if (sendEKSHA1) {
                                    ekSha1Ref = SignatureProcessor.getEKSHA1Ref(context);
                                    tokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                                    refElem = new EncryptedKeySHA1Identifier((Document)secureMessage.getSOAPPart());
                                    refElem.setReferenceValue(ekSha1Ref);
                                    tokenRef.setReference(refElem);
                                    dktId = keyBinding.getUUID();
                                    if (dktId == null) {
                                        dktId = secureMessage.generateId();
                                    }
                                    nonce = Base64.encode(dkt.getNonce());
                                    dktHeadrBlock = new DerivedKeyTokenHeaderBlock(securityHeader.getOwnerDocument(), tokenRef, nonce, dkt.getOffset(), dkt.getLength(), dktId);
                                    secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(dktHeadrBlock);
                                    nxtSiblingContainer[0] = nextSibling = dktHeadrBlock.getAsSoapElement().getNextSibling();
                                    reference = new DirectReference();
                                    reference.setURI("#" + dktId);
                                    sigTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                                    sigTokenRef.setReference(reference);
                                    keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, sigTokenRef);
                                    return keyInfo;
                                }
                                if (!wss11Sender && !wss10) break block67;
                                x509Binding = null;
                                cert = null;
                                if (context.getX509CertificateBinding() != null) {
                                    x509Binding = context.getX509CertificateBinding();
                                    context.setX509CertificateBinding(null);
                                }
                                tokenCache = context.getTokenCache();
                                insertedX509Cache = context.getInsertedX509Cache();
                                x509id = x509Binding.getUUID();
                                if (x509id == null || x509id.equals("")) {
                                    x509id = secureMessage.generateId();
                                }
                                SecurityUtil.checkIncludeTokenPolicy(context, x509Binding, x509id);
                                referenceType = x509Binding.getReferenceType();
                                strategy = KeyInfoStrategy.getInstance(referenceType);
                                token = null;
                                cert = x509Binding.getX509Certificate();
                                x509TokenId = x509Binding.getUUID();
                                tokenInserted = false;
                                if (x509TokenId == null || x509TokenId.equals("")) {
                                    x509TokenId = secureMessage.generateId();
                                }
                                insertedx509 = (X509SecurityToken)context.getInsertedX509Cache().get(x509TokenId);
                                token = (X509SecurityToken)tokenCache.get(x509TokenId);
                                if (token == null) {
                                    if (insertedx509 != null) {
                                        token = insertedx509;
                                        tokenCache.put(x509TokenId, insertedx509);
                                    } else {
                                        valueType = x509Binding.getValueType();
                                        if (valueType == null || valueType.equals("")) {
                                            valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
                                        }
                                        token = new X509SecurityToken((Document)secureMessage.getSOAPPart(), cert, x509TokenId, valueType);
                                        tokenCache.put(x509TokenId, token);
                                    }
                                    context.setCurrentSecret(originalKey);
                                } else {
                                    tokenInserted = true;
                                }
                                dktId = keyBinding.getUUID();
                                if (dktId == null) {
                                    dktId = secureMessage.generateId();
                                }
                                nonce = Base64.encode(dkt.getNonce());
                                ekCache = context.getEncryptedKeyCache();
                                ekId = (String)ekCache.get(x509TokenId);
                                encryptedKey = null;
                                keyEncryptor = null;
                                if (!tokenInserted) {
                                    context.setExtraneousProperty("SecretKey", originalKey);
                                    keyInfoBlock = new KeyInfoHeaderBlock((Document)secureMessage.getSOAPPart());
                                    strategy.setCertificate(cert);
                                    strategy.insertKey(keyInfoBlock, secureMessage, x509TokenId);
                                    apacheKeyInfo = keyInfoBlock.getKeyInfo();
                                    try {
                                        keyEncryptor = XMLCipher.getInstance(keyEncAlgo);
                                        keyEncryptor.init(3, cert.getPublicKey());
                                        if (keyEncryptor != null) {
                                            encryptedKey = keyEncryptor.encryptKey((Document)secureMessage.getSOAPPart(), originalKey);
                                        }
                                    }
                                    catch (Exception e) {
                                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1335_UNSUPPORTED_KEYBINDING_SIGNATUREPOLICY());
                                        throw new XWSSecurityException(e);
                                    }
                                    ekId = secureMessage.generateId();
                                    ekCache.put(x509TokenId, ekId);
                                    encryptedKey.setId(ekId);
                                    encryptedKey.setKeyInfo(apacheKeyInfo);
                                }
                                tokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                                reference = new DirectReference();
                                reference.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                                reference.setURI("#" + ekId);
                                tokenRef.setReference(reference);
                                dktHeadrBlock = new DerivedKeyTokenHeaderBlock(securityHeader.getOwnerDocument(), tokenRef, nonce, dkt.getOffset(), dkt.getLength(), dktId);
                                if (!tokenInserted) {
                                    nsX509 = null;
                                    if (insertedx509 != null) {
                                        nsX509 = insertedx509.getNextSibling();
                                    }
                                    if (nsX509 == null) {
                                        secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(dktHeadrBlock);
                                    } else {
                                        secureMessage.findOrCreateSecurityHeader().insertBefore(dktHeadrBlock, nsX509);
                                    }
                                    if (insertedx509 != null) {
                                        nsX509 = insertedx509.getNextSibling();
                                    }
                                    se = (SOAPElement)keyEncryptor.martial(encryptedKey);
                                    if (nsX509 == null) {
                                        secureMessage.findOrCreateSecurityHeader().insertHeaderBlockElement(se);
                                    } else {
                                        secureMessage.findOrCreateSecurityHeader().insertBefore((Node)se, nsX509);
                                    }
                                    if ("Direct".equals(referenceType) && insertedX509Cache.get(x509TokenId) == null) {
                                        secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(token);
                                        insertedX509Cache.put(x509TokenId, token);
                                    }
                                    cipherData = (Element)se.getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                                    cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                                    decodedCipher = Base64.decode(cipherValue);
                                    ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                                    encEkSha1 = Base64.encode(ekSha1);
                                    context.setExtraneousProperty("EncryptedKeySHA1", encEkSha1);
                                } else {
                                    ekElem = secureMessage.getElementById(ekId);
                                    secureMessage.findOrCreateSecurityHeader().insertBefore(dktHeadrBlock, ekElem.getNextSibling());
                                }
                                refSig = new DirectReference();
                                refSig.setURI("#" + dktId);
                                sigTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                                sigTokenRef.setReference(refSig);
                                keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, sigTokenRef);
                                nxtSiblingContainer[0] = nextSibling = dktHeadrBlock.getAsSoapElement().getNextSibling();
                                return keyInfo;
                            }
                            if (!PolicyTypeUtil.issuedTokenKeyBinding(originalKeyBinding)) break block69;
                            itk = (IssuedTokenKeyBinding)originalKeyBinding;
                            issuedTokenContext = context.getTrustContext();
                            issuedToken = (GenericToken)issuedTokenContext.getSecurityToken();
                            tokenElem = null;
                            str = null;
                            strElem = null;
                            ikb = (IssuedTokenKeyBinding)originalKeyBinding;
                            ikbPolicyId = ikb.getUUID();
                            tokCache = context.getTokenCache();
                            tok = tokCache.get(ikbPolicyId);
                            issuedTokenElementFromMsg = null;
                            iTokenType = ikb.getIncludeToken();
                            if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(iTokenType)) ** GOTO lbl-1000
                            if (IssuedTokenKeyBinding.INCLUDE_ALWAYS.equals(iTokenType)) ** GOTO lbl-1000
                            if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_VER2.equals(iTokenType)) ** GOTO lbl-1000
                            if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(iTokenType)) lbl-1000:
                            // 4 sources

                            {
                                v0 = true;
                            } else {
                                v0 = includeIST = false;
                            }
                            if (includeIST && issuedToken == null) {
                                SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1343_NULL_ISSUED_TOKEN());
                                throw new XWSSecurityException("Issued Token to be inserted into the Message was Null");
                            }
                            if (issuedToken != null) {
                                elem = (Element)issuedToken.getTokenValue();
                                if (tok == null) {
                                    tokenElem = XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), elem);
                                    tokId = tokenElem.getAttribute("Id");
                                    if ("".equals(tokId) && "EncryptedData".equals(tokenElem.getLocalName())) {
                                        tokenElem.setAttribute("Id", secureMessage.generateId());
                                    }
                                    tokCache.put(ikbPolicyId, tokenElem);
                                } else {
                                    wsuId = SecurityUtil.getWsuIdOrId((Element)tok);
                                    issuedTokenElementFromMsg = (SOAPElement)secureMessage.getElementById(wsuId);
                                    if (issuedTokenElementFromMsg == null) {
                                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1344_ERROR_LOCATE_ISSUE_TOKEN_MESSAGE());
                                        throw new XWSSecurityException("Could not locate Issued Token in Message");
                                    }
                                }
                            }
                            strElem = includeIST != false ? (Element)issuedTokenContext.getAttachedSecurityTokenReference().getTokenValue() : (Element)issuedTokenContext.getUnAttachedSecurityTokenReference().getTokenValue();
                            imported = (Element)secureMessage.getSOAPPart().importNode((Node)strElem, true);
                            str = new SecurityTokenReference(XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), imported), false);
                            if (originalKey != null) {
                                SecurityUtil.updateSamlVsKeyCache(str, context, originalKey);
                            }
                            if ((dktId = keyBinding.getUUID()) == null) {
                                dktId = secureMessage.generateId();
                            }
                            derivedKeyTokenHeaderBlock = new DerivedKeyTokenHeaderBlock((Document)secureMessage.getSOAPPart(), str, Base64.encode(dkt.getNonce()), dkt.getOffset(), dkt.getLength(), dktId);
                            if (issuedTokenElementFromMsg != null) {
                                _secHeader = secureMessage.findOrCreateSecurityHeader();
                                _secHeader.insertBefore(derivedKeyTokenHeaderBlock, issuedTokenElementFromMsg.getNextSibling());
                            } else {
                                reflist = context.getCurrentRefList();
                                if (reflist != null) {
                                    secureMessage.findOrCreateSecurityHeader().insertBefore(derivedKeyTokenHeaderBlock, reflist);
                                    context.setCurrentReferenceList(null);
                                } else {
                                    secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(derivedKeyTokenHeaderBlock);
                                }
                            }
                            if (tokenElem != null) {
                                if (includeIST) {
                                    secureMessage.findOrCreateSecurityHeader().insertHeaderBlockElement(tokenElem);
                                }
                                context.setIssuedSAMLToken((Element)tokenElem);
                            }
                            refSig = new DirectReference();
                            refSig.setURI("#" + dktId);
                            sigTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                            sigTokenRef.setReference(refSig);
                            keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, sigTokenRef);
                            nxtSiblingContainer[0] = nextSibling = derivedKeyTokenHeaderBlock.getAsSoapElement().getNextSibling();
                            return keyInfo;
                        }
                        if (PolicyTypeUtil.samlTokenPolicy(originalKeyBinding)) {
                            SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1345_UNSUPPORTED_DERIVEDKEYS_SAML_TOKEN());
                            throw new UnsupportedOperationException("DerivedKeys with SAMLToken not yet supported");
                        }
                        if (PolicyTypeUtil.secureConversationTokenKeyBinding(originalKeyBinding)) {
                            sctBinding = (SecureConversationTokenKeyBinding)originalKeyBinding;
                            tokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                            sctElement = SignatureProcessor.insertSCT(context, sctBinding, tokenRef);
                            dktId = keyBinding.getUUID();
                            if (dktId == null) {
                                dktId = secureMessage.generateId();
                            }
                            nonce = Base64.encode(dkt.getNonce());
                            dktHeaderBlock = new DerivedKeyTokenHeaderBlock(securityHeader.getOwnerDocument(), tokenRef, nonce, dkt.getOffset(), dkt.getLength(), dktId);
                            v1 = next = sctElement != null ? sctElement.getNextSibling() : null;
                            if (next == null && (reflist = context.getCurrentRefList()) != null) {
                                next = reflist;
                                context.setCurrentReferenceList(null);
                            }
                            dktElem = (SOAPElement)securityHeader.insertBefore((Node)dktHeaderBlock.getAsSoapElement(), next);
                            refSig = new DirectReference();
                            refSig.setURI("#" + dktId);
                            sigTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                            sigTokenRef.setReference(refSig);
                            nxtSiblingContainer[0] = nextSibling = dktElem.getNextSibling();
                            keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, sigTokenRef);
                            return keyInfo;
                        }
                        break block67;
                    }
                    if (!PolicyTypeUtil.issuedTokenKeyBinding(keyBinding)) break block70;
                    issuedTokenContext = context.getTrustContext();
                    issuedToken = (GenericToken)issuedTokenContext.getSecurityToken();
                    tokenElem = null;
                    str = null;
                    strElem = null;
                    issuedTokenElementFromMsg = null;
                    ikb = (IssuedTokenKeyBinding)keyBinding;
                    ikbPolicyId = ikb.getUUID();
                    tokCache = context.getTokenCache();
                    tok = tokCache.get(ikbPolicyId);
                    iTokenType = ikb.getIncludeToken();
                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(iTokenType)) ** GOTO lbl-1000
                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS.equals(iTokenType)) ** GOTO lbl-1000
                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_VER2.equals(iTokenType)) ** GOTO lbl-1000
                    if (IssuedTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(iTokenType)) lbl-1000:
                    // 4 sources

                    {
                        v2 = true;
                    } else {
                        v2 = includeIST = false;
                    }
                    if (includeIST && issuedToken == null) {
                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1343_NULL_ISSUED_TOKEN());
                        throw new XWSSecurityException("Issued Token to be inserted into the Message was Null");
                    }
                    if (issuedToken != null) {
                        elem = (Element)issuedToken.getTokenValue();
                        if (tok == null) {
                            tokenElem = XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), elem);
                            tokId = tokenElem.getAttribute("Id");
                            if ("".equals(tokId) && "EncryptedData".equals(tokenElem.getLocalName())) {
                                tokenElem.setAttribute("Id", secureMessage.generateId());
                            }
                            tokCache.put(ikbPolicyId, tokenElem);
                        } else {
                            wsuId = SecurityUtil.getWsuIdOrId((Element)tok);
                            issuedTokenElementFromMsg = (SOAPElement)secureMessage.getElementById(wsuId);
                            if (issuedTokenElementFromMsg == null) {
                                SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1344_ERROR_LOCATE_ISSUE_TOKEN_MESSAGE());
                                throw new XWSSecurityException("Could not locate Issued Token in Message");
                            }
                        }
                    }
                    if ((strElem = includeIST != false ? SecurityUtil.convertSTRToElement(issuedTokenContext.getAttachedSecurityTokenReference().getTokenValue(), (Document)secureMessage.getSOAPPart()) : SecurityUtil.convertSTRToElement(issuedTokenContext.getUnAttachedSecurityTokenReference().getTokenValue(), (Document)secureMessage.getSOAPPart())) == null) {
                        SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1378_UNABLETO_REFER_ISSUE_TOKEN());
                        throw new XWSSecurityException("Cannot determine how to reference the Issued Token in the Message");
                    }
                    imported = (Element)secureMessage.getSOAPPart().importNode((Node)strElem, true);
                    str = new SecurityTokenReference(XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), (Element)imported.cloneNode(true)), false);
                    if (originalKey != null) {
                        SecurityUtil.updateSamlVsKeyCache(str, context, originalKey);
                    }
                    if (tokenElem != null) {
                        if (includeIST) {
                            secureMessage.findOrCreateSecurityHeader().insertHeaderBlockElement(tokenElem);
                            nxtSiblingContainer[0] = tokenElem.getNextSibling();
                        } else {
                            nxtSiblingContainer[0] = null;
                        }
                        context.setIssuedSAMLToken((Element)tokenElem);
                    } else if (issuedTokenElementFromMsg != null) {
                        nxtSiblingContainer[0] = issuedTokenElementFromMsg.getNextSibling();
                    }
                    keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, str);
                    return keyInfo;
                }
                if (PolicyTypeUtil.secureConversationTokenKeyBinding(keyBinding)) {
                    sctBinding = (SecureConversationTokenKeyBinding)keyBinding;
                    secTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                    sctElement = SignatureProcessor.insertSCT(context, sctBinding, secTokenRef);
                    nxtSiblingContainer[0] = nextSibling = sctElement != null ? sctElement.getNextSibling() : null;
                    keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, secTokenRef);
                    return keyInfo;
                }
            }
            catch (SOAPException ex) {
                SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1346_ERROR_PREPARING_SYMMETRICKEY_SIGNATURE(), ex);
                throw new XWSSecurityException(ex);
            }
            catch (Base64DecodingException ex) {
                SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1346_ERROR_PREPARING_SYMMETRICKEY_SIGNATURE(), ex);
                throw new XWSSecurityException(ex);
            }
            catch (NoSuchAlgorithmException ex) {
                SignatureProcessor.logger.log(Level.SEVERE, LogStringsMessages.WSS_1346_ERROR_PREPARING_SYMMETRICKEY_SIGNATURE(), ex);
                throw new XWSSecurityException(ex);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SOAPElement insertSCT(FilterProcessingContext context, SecureConversationTokenKeyBinding sctBinding, SecurityTokenReference secTokenRef) throws XWSSecurityException {
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        String sctPolicyId = sctBinding.getUUID();
        HashMap tokCache = context.getTokenCache();
        SecurityContextTokenImpl sct = null;
        sct = (SecurityContextTokenImpl)tokCache.get(sctPolicyId);
        boolean tokenInserted = false;
        SOAPElement sctElement = null;
        IssuedTokenContext ictx = context.getSecureConversationContext();
        if (sct == null) {
            SecurityContextToken sct1 = (SecurityContextToken)ictx.getSecurityToken();
            if (sct1 == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1347_NULL_SECURE_CONVERSATION_TOKEN());
                throw new XWSSecurityException("SecureConversation Token not Found");
            }
            sct = new SecurityContextTokenImpl((Document)secureMessage.getSOAPPart(), sct1.getIdentifier().toString(), sct1.getInstance(), sct1.getWsuId(), sct1.getExtElements());
            tokCache.put(sctPolicyId, sct);
        } else {
            tokenInserted = true;
            sctElement = secureMessage.getElementByWsuId(sct.getWsuId());
        }
        String sctWsuId = sct.getWsuId();
        if (sctWsuId == null) {
            sct.setId(secureMessage.generateId());
        }
        sctWsuId = sct.getWsuId();
        String iTokenType = sctBinding.getIncludeToken();
        if (!SecureConversationTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(iTokenType)) {
            if (!SecureConversationTokenKeyBinding.INCLUDE_ALWAYS.equals(iTokenType)) {
                if (!SecureConversationTokenKeyBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(iTokenType)) {
                    if (!SecureConversationTokenKeyBinding.INCLUDE_ALWAYS_VER2.equals(iTokenType)) {
                        DirectReference reference = new DirectReference();
                        reference.setSCTURI(sct.getIdentifier().toString(), sct.getInstance());
                        secTokenRef.setReference(reference);
                        return sctElement;
                    }
                }
            }
        }
        if (!tokenInserted) {
            secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(sct);
            sctElement = secureMessage.getElementByWsuId(sct.getWsuId());
        }
        DirectReference reference = new DirectReference();
        reference.setURI("#" + sctWsuId);
        secTokenRef.setReference(reference);
        return sctElement;
    }

    private static KeyInfo handleX509Binding(FilterProcessingContext context, SignaturePolicy signaturePolicy, AuthenticationTokenPolicy.X509CertificateBinding certInfo, Node[] nxtSiblingContainer) throws XWSSecurityException {
        Object nextSibling = null;
        KeyInfo keyInfo = null;
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        SecurityHeader securityHeader = secureMessage.findOrCreateSecurityHeader();
        WSSPolicyConsumerImpl dsigHelper = WSSPolicyConsumerImpl.getInstance();
        HashMap tokenCache = context.getTokenCache();
        HashMap insertedX509Cache = context.getInsertedX509Cache();
        String x509id = certInfo.getUUID();
        if (x509id == null || x509id.equals("")) {
            x509id = secureMessage.generateId();
        }
        SecurityUtil.checkIncludeTokenPolicy(context, certInfo, x509id);
        String referenceType = certInfo.getReferenceType();
        String strId = certInfo.getSTRID();
        if (strId == null) {
            strId = secureMessage.generateId();
        }
        try {
            if (referenceType.equals("Direct")) {
                DirectReference reference = new DirectReference();
                String valueType = certInfo.getValueType();
                if (valueType == null || valueType.equals("")) {
                    valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
                }
                reference.setValueType(valueType);
                String id = certInfo.getUUID();
                if (id == null || id.equals("")) {
                    id = secureMessage.generateId();
                }
                reference.setURI("#" + id);
                SecurityTokenReference secTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                secTokenRef.setReference(reference);
                secTokenRef.setWsuId(strId);
                keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, secTokenRef);
                X509SecurityToken token = null;
                token = (X509SecurityToken)tokenCache.get(id);
                if (token == null) {
                    valueType = certInfo.getValueType();
                    if (valueType == null || valueType.equals("")) {
                        valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
                    }
                    token = new X509SecurityToken((Document)secureMessage.getSOAPPart(), certInfo.getX509Certificate(), id, valueType);
                    tokenCache.put(id, token);
                }
                if (insertedX509Cache.get(id) == null) {
                    secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(token);
                    insertedX509Cache.put(id, token);
                }
                nextSibling = token.getAsSoapElement().getNextSibling();
                nxtSiblingContainer[0] = nextSibling;
                return keyInfo;
            }
            if (referenceType.equals("Identifier")) {
                String valueType = certInfo.getValueType();
                if (valueType == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1" || valueType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1")) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1333_UNSUPPORTED_KEYIDENTIFER_X_509_V_1());
                    throw new XWSSecurityException("Key Identifier reference Type is not allowed for X509v1 Certificates");
                }
                KeyIdentifierStrategy keyIdentifier = new KeyIdentifierStrategy(certInfo.getCertificateIdentifier(), true);
                keyIdentifier.setCertificate(certInfo.getX509Certificate());
                SecurityTokenReference secTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                keyIdentifier.insertKey(secTokenRef, secureMessage);
                secTokenRef.setWsuId(strId);
                X509SubjectKeyIdentifier re = (X509SubjectKeyIdentifier)secTokenRef.getReference();
                String id = re.getReferenceValue();
                tokenCache.put(id, re);
                re.setCertificate(certInfo.getX509Certificate());
                keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, secTokenRef);
                nextSibling = securityHeader.getNextSiblingOfTimestamp();
                nxtSiblingContainer[0] = nextSibling;
                return keyInfo;
            }
            if (referenceType.equals("Thumbprint")) {
                String valueType = certInfo.getValueType();
                if (valueType == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1" || valueType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1")) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1348_ILLEGAL_THUMBPRINT_X_509_V_1());
                    throw new XWSSecurityException("Thumb reference Type is not allowed for X509v1 Certificates");
                }
                KeyIdentifierStrategy keyIdentifier = new KeyIdentifierStrategy(certInfo.getCertificateIdentifier(), true, true);
                keyIdentifier.setCertificate(certInfo.getX509Certificate());
                SecurityTokenReference secTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                keyIdentifier.insertKey(secTokenRef, secureMessage);
                secTokenRef.setWsuId(strId);
                X509ThumbPrintIdentifier re = (X509ThumbPrintIdentifier)secTokenRef.getReference();
                String id = re.getReferenceValue();
                tokenCache.put(id, re);
                re.setCertificate(certInfo.getX509Certificate());
                keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, secTokenRef);
                nextSibling = securityHeader.getNextSiblingOfTimestamp();
                nxtSiblingContainer[0] = nextSibling;
                return keyInfo;
            }
            if (referenceType.equals("IssuerSerialNumber")) {
                X509Certificate xCert = certInfo.getX509Certificate();
                X509IssuerSerial xis = new X509IssuerSerial((Document)secureMessage.getSOAPPart(), xCert.getIssuerDN().getName(), xCert.getSerialNumber());
                SecurityTokenReference secTokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                secTokenRef.setReference(xis);
                secTokenRef.setWsuId(strId);
                xis.setCertificate(xCert);
                tokenCache.put(xis.getIssuerName() + xis.getSerialNumber(), xis);
                keyInfo = dsigHelper.constructKeyInfo((MLSPolicy)signaturePolicy, secTokenRef);
                nextSibling = securityHeader.getNextSiblingOfTimestamp();
                nxtSiblingContainer[0] = nextSibling;
                return keyInfo;
            }
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1308_UNSUPPORTED_REFERENCE_MECHANISM());
            throw new XWSSecurityException("Reference type " + referenceType + "not supported");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1349_ERROR_HANDLING_X_509_BINDING(), e);
            throw new XWSSecurityException(e);
        }
    }

    private static String getEKSHA1Ref(FilterProcessingContext context) {
        String ekSha1Ref = null;
        ekSha1Ref = (String)context.getExtraneousProperty("EKSHA1Value");
        return ekSha1Ref;
    }
}

