/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceMaintenanceTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.HighlyAvailableMap;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.InVmSequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.ReplicationManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.SequenceDataPojo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InVmSequenceManager
implements SequenceManager,
ReplicationManager<String, AbstractSequence> {
    private static final Logger LOGGER = Logger.getLogger(InVmSequenceManager.class);
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final HighlyAvailableMap<String, AbstractSequence> sequences;
    private final BackingStore<String, SequenceDataPojo> sequenceDataBs;
    private final HighlyAvailableMap<String, String> boundSequences;
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final String uniqueEndpointId;
    private final long sequenceInactivityTimeout;
    private final long maxConcurrentInboundSequences;
    private final AtomicLong actualConcurrentInboundSequences;

    public InVmSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, RmConfiguration configuration) {
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
        this.sequenceInactivityTimeout = configuration.getRmFeature().getSequenceInactivityTimeout();
        this.actualConcurrentInboundSequences = new AtomicLong(0L);
        this.maxConcurrentInboundSequences = configuration.getRmFeature().getMaxConcurrentSessions();
        BackingStoreFactory bsFactory = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
        this.boundSequences = HighlyAvailableMap.newInstanceForBs(new HashMap(), HighAvailabilityProvider.INSTANCE.createBackingStore(bsFactory, uniqueEndpointId + "_BOUND_SEQUENCE_BS", String.class, String.class));
        this.sequenceDataBs = HighAvailabilityProvider.INSTANCE.createBackingStore(bsFactory, uniqueEndpointId + "_SEQUENCE_DATA_BS", String.class, SequenceDataPojo.class);
        this.sequences = HighlyAvailableMap.newInstance(new HashMap(), this);
        MaintenanceTaskExecutor.INSTANCE.register(new SequenceMaintenanceTask(this, configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS), configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Sequence> sequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>(this.sequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> boundSequences() {
        try {
            this.dataLock.readLock().lock();
            Map<String, String> map = this.boundSequences.getLocalMapCopy();
            return map;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public long concurrentlyOpenedInboundSequencesCount() {
        return this.actualConcurrentInboundSequences.longValue();
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        SequenceDataPojo sequenceDataPojo = new SequenceDataPojo(sequenceId, strId, expirationTime, false, this.sequenceDataBs);
        sequenceDataPojo.setState(Sequence.State.CREATED);
        sequenceDataPojo.setAckRequestedFlag(false);
        sequenceDataPojo.setLastMessageNumber(0L);
        sequenceDataPojo.setLastActivityTime(this.currentTimeInMillis());
        sequenceDataPojo.setLastAcknowledgementRequestTime(0L);
        InVmSequenceData data = InVmSequenceData.newInstace(this, sequenceDataPojo);
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this));
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        long actualSessions = this.actualConcurrentInboundSequences.incrementAndGet();
        if (this.maxConcurrentInboundSequences >= 0L && this.maxConcurrentInboundSequences < actualSessions) {
            this.actualConcurrentInboundSequences.decrementAndGet();
            throw new RxRuntimeException(LocalizationMessages.WSRM_1156_MAX_CONCURRENT_SESSIONS_REACHED(this.maxConcurrentInboundSequences));
        }
        SequenceDataPojo sequenceDataPojo = new SequenceDataPojo(sequenceId, strId, expirationTime, true, this.sequenceDataBs);
        sequenceDataPojo.setState(Sequence.State.CREATED);
        sequenceDataPojo.setAckRequestedFlag(false);
        sequenceDataPojo.setLastMessageNumber(0L);
        sequenceDataPojo.setLastActivityTime(this.currentTimeInMillis());
        sequenceDataPojo.setLastAcknowledgementRequestTime(0L);
        InVmSequenceData data = InVmSequenceData.newInstace(this, sequenceDataPojo);
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this));
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.readLock().lock();
            Sequence sequence = this.sequences.get(sequenceId);
            if (sequence == null) {
                throw new UnknownSequenceException(sequenceId);
            }
            if (this.shouldTeminate(sequence)) {
                this.dataLock.readLock().unlock();
                this.tryTerminateSequence(sequenceId);
                this.dataLock.readLock().lock();
            }
            Sequence sequence2 = sequence;
            return sequence2;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        try {
            this.dataLock.readLock().lock();
            Sequence s = this.sequences.get(sequenceId);
            boolean bl = s != null && s.getState() != Sequence.State.TERMINATING;
            return bl;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence tryTerminateSequence(String sequenceId) {
        try {
            this.dataLock.writeLock().lock();
            Sequence sequence = this.sequences.get(sequenceId);
            if (sequence == null) {
                Sequence sequence2 = null;
                return sequence2;
            }
            if (sequence.getState() != Sequence.State.TERMINATING) {
                if (sequence instanceof InboundSequence) {
                    this.actualConcurrentInboundSequences.decrementAndGet();
                }
                sequence.preDestroy();
            }
            Sequence sequence3 = sequence;
            return sequence3;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.tryTerminateSequence(sequenceId);
        if (sequence == null) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (!this.sequences.containsKey(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (!this.sequences.containsKey(boundSequenceId)) {
                throw new UnknownSequenceException(boundSequenceId);
            }
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.readLock().lock();
            if (!this.isValid(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            AbstractSequence abstractSequence = this.boundSequences.containsKey(referenceSequenceId) ? this.sequences.get(this.boundSequences.get(referenceSequenceId)) : null;
            return abstractSequence;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence registerSequence(AbstractSequence sequence) throws DuplicateSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (this.sequences.containsKey(sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            this.sequences.put(sequence.getId(), sequence);
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMaintenance() {
        LOGGER.entering();
        try {
            this.dataLock.writeLock().lock();
            Iterator<String> sequenceKeyIterator = this.sequences.keySet().iterator();
            while (sequenceKeyIterator.hasNext()) {
                String key = sequenceKeyIterator.next();
                Sequence sequence = this.sequences.get(key);
                if (this.shouldRemove(sequence)) {
                    LOGGER.config(LocalizationMessages.WSRM_1152_REMOVING_SEQUENCE(sequence.getId()));
                    sequenceKeyIterator.remove();
                    this.sequences.getReplicationManager().remove(key);
                    if (!this.boundSequences.containsKey(sequence.getId())) continue;
                    this.boundSequences.remove(sequence.getId());
                    continue;
                }
                if (!this.shouldTeminate(sequence)) continue;
                LOGGER.config(LocalizationMessages.WSRM_1153_TERMINATING_SEQUENCE(sequence.getId()));
                this.tryTerminateSequence(sequence.getId());
            }
        }
        finally {
            this.dataLock.writeLock().unlock();
            LOGGER.exiting();
        }
    }

    private boolean shouldTeminate(Sequence sequence) {
        return sequence.getState() != Sequence.State.TERMINATING && (sequence.isExpired() || sequence.getLastActivityTime() + this.sequenceInactivityTimeout < this.currentTimeInMillis());
    }

    private boolean shouldRemove(Sequence sequence) {
        return sequence.getState() == Sequence.State.TERMINATING;
    }

    @Override
    public AbstractSequence load(String key) {
        SequenceDataPojo state = HighAvailabilityProvider.loadFrom(this.sequenceDataBs, key, null);
        if (state == null) {
            return null;
        }
        state.setBackingStore(this.sequenceDataBs);
        InVmSequenceData data = InVmSequenceData.loadReplica(null, state);
        return state.isInbound() ? new InboundSequence(data, this.outboundQueueBuilder, this) : new OutboundSequence(data, this.outboundQueueBuilder, this);
    }

    @Override
    public String save(String key, AbstractSequence value, boolean isNew) {
        SequenceData _data = value.getData();
        if (!(_data instanceof InVmSequenceData)) {
            throw new IllegalArgumentException("Unsupported sequence data class: " + _data.getClass().getName());
        }
        InVmSequenceData data = (InVmSequenceData)_data;
        return HighAvailabilityProvider.saveTo(this.sequenceDataBs, key, data.getSequenceStatePojo(), isNew);
    }

    @Override
    public void remove(String key) {
        HighAvailabilityProvider.removeFrom(this.sequenceDataBs, key);
    }

    @Override
    public void close() {
        HighAvailabilityProvider.close(this.sequenceDataBs);
    }

    @Override
    public void destroy() {
        HighAvailabilityProvider.destroy(this.sequenceDataBs);
    }
}

