/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.logging.Level;

public class KeyValueTokenBuilder
extends TokenBuilder {
    AuthenticationTokenPolicy.KeyValueTokenBinding binding = null;

    public KeyValueTokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.KeyValueTokenBinding binding) {
        super(context);
        this.binding = binding;
    }

    public BuilderResult process() throws XWSSecurityException {
        String referenceType = this.binding.getReferenceType();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, LogStringsMessages.WSS_1851_REFERENCETYPE_X_509_TOKEN(referenceType));
        }
        PrivateKey dataProtectionKey = null;
        BuilderResult result = new BuilderResult();
        KeyPair keyPair = (KeyPair)this.context.getExtraneousProperties().get("UseKey-RSAKeyPair");
        if (keyPair != null) {
            dataProtectionKey = keyPair.getPrivate();
            if (dataProtectionKey == null) {
                throw new XWSSecurityException("PrivateKey null inside PrivateKeyBinding set for KeyValueToken/RsaToken Policy ");
            }
            this.buildKeyInfo(keyPair.getPublic());
            result.setDataProtectionKey(dataProtectionKey);
            result.setKeyInfo(this.keyInfo);
        }
        return result;
    }
}

