/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.metro.parser;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;

public class MetroParser {
    private static final Logger LOGGER = Logger.getLogger(MetroParser.class);
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    private static final String JAR_PREFIX = "META-INF/";
    private static final String WAR_PREFIX = "/WEB-INF/";
    private static final String WEBSERVICES_NAME = "webservices.xml";
    private static final String METRO_WEBSERVICES_NAME = "metro-webservices.xml";
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    private MetroParser() {
    }

    public static void parse(Container container) {
        URL metroWs = MetroParser.findConfigFile(METRO_WEBSERVICES_NAME, container);
        URL metro = MetroParser.findConfigFile(WEBSERVICES_NAME, container);
    }

    private static URL findConfigFile(String configFileName, Container container) throws WebServiceException {
        URL configFileUrl = null;
        try {
            block8: {
                ResourceLoader resourceLoader;
                ResourceLoader resourceLoader2 = resourceLoader = container != null ? container.getSPI(ResourceLoader.class) : null;
                if (resourceLoader != null) {
                    configFileUrl = resourceLoader.getResource(configFileName);
                }
                if (configFileUrl == null && container != null) {
                    try {
                        Class<?> contextClass = Class.forName(SERVLET_CONTEXT_CLASSNAME);
                        Object context = container.getSPI(contextClass);
                        if (context != null) {
                            configFileUrl = PolicyUtils.ConfigFile.loadFromContext(WAR_PREFIX + configFileName, context);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block8;
                        LOGGER.fine("Cannot find servlet context");
                    }
                }
            }
            if (configFileUrl == null) {
                StringBuilder examinedPath = new StringBuilder(JAR_PREFIX).append(configFileName);
                configFileUrl = PolicyUtils.ConfigFile.loadFromClasspath(examinedPath.toString());
            }
            return configFileUrl;
        }
        catch (MalformedURLException e) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to load file", (Throwable)e));
        }
    }

    private static XMLStreamReader urlToReader(URL url) throws WebServiceException {
        try {
            return inputFactory.createXMLStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to load URL", (Throwable)e));
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to load URL", (Throwable)e));
        }
    }
}

