/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common.endpoint;

import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATFaultFactory;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATSynchronization;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.api.Transactional;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import com.sun.xml.ws.tx.coord.common.EndpointReferenceBuilder;
import com.sun.xml.ws.tx.coord.common.RegistrationIF;
import com.sun.xml.ws.tx.coord.common.WSCUtil;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterResponseType;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterType;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRegistration<T extends EndpointReference, K, P>
implements RegistrationIF<T, K, P> {
    WebServiceContext context;
    Transactional.Version version;

    protected BaseRegistration(WebServiceContext context, Transactional.Version version) {
        this.context = context;
        this.version = version;
    }

    @Override
    public BaseRegisterResponseType<T, P> registerOperation(BaseRegisterType<T, K> parameters) {
        String txId = WSATHelper.getInstance().getWSATTidFromWebServiceContextHeaderList(this.context);
        Xid xidFromWebServiceContextHeaderList = TransactionIdHelper.getInstance().wsatid2xid(txId);
        byte[] bqual = this.processRegisterTypeAndEnlist(parameters, xidFromWebServiceContextHeaderList);
        BaseRegisterResponseType<T, P> registerResponseType = this.createRegisterResponseType(xidFromWebServiceContextHeaderList, bqual);
        return registerResponseType;
    }

    byte[] processRegisterTypeAndEnlist(BaseRegisterType<T, K> parameters, Xid xid) {
        if (parameters == null) {
            WSATFaultFactory.throwInvalidParametersFault();
        }
        String protocolIdentifier = parameters.getProtocolIdentifier();
        if (parameters.isDurable()) {
            return this.enlistResource(xid, parameters.getParticipantProtocolService());
        }
        if (parameters.isVolatile()) {
            this.registerSynchronization(xid, parameters.getParticipantProtocolService());
            return null;
        }
        throw new WebServiceException("unknown participant identifier:" + protocolIdentifier);
    }

    BaseRegisterResponseType<T, P> createRegisterResponseType(Xid xid, byte[] bqual) {
        BaseRegisterResponseType<T, P> registerResponseType = this.newRegisterResponseType();
        String coordinatorHostAndPort = this.getCoordinatorAddress();
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        String branchQual = new String(bqual);
        EndpointReferenceBuilder<T> builder = this.getEndpointReferenceBuilder();
        T endpointReference = builder.address(coordinatorHostAndPort).referenceParameter(WSCUtil.referenceElementTxId(txId), WSCUtil.referenceElementBranchQual(branchQual), WSCUtil.referenceElementRoutingInfo()).build();
        registerResponseType.setCoordinatorProtocolService(endpointReference);
        return registerResponseType;
    }

    private byte[] enlistResource(Xid xid, T epr) {
        WSATXAResource wsatXAResource = new WSATXAResource(this.version, (EndpointReference)epr, xid);
        try {
            byte[] bqual = this.getTransactionServices().enlistResource(wsatXAResource, xid);
            wsatXAResource.setBranchQualifier(bqual);
            return bqual;
        }
        catch (WSATException e) {
            e.printStackTrace();
            throw new WebServiceException((Throwable)e);
        }
    }

    private void registerSynchronization(Xid xid, T epr) {
        WSATSynchronization wsatXAResource = new WSATSynchronization(this.version, (EndpointReference)epr, xid);
        try {
            this.getTransactionServices().registerSynchronization(wsatXAResource, xid);
        }
        catch (WSATException e) {
            WSATFaultFactory.throwContextRefusedFault();
        }
    }

    protected abstract EndpointReferenceBuilder<T> getEndpointReferenceBuilder();

    protected abstract BaseRegisterResponseType<T, P> newRegisterResponseType();

    protected abstract String getCoordinatorAddress();

    protected TransactionServices getTransactionServices() {
        return WSATHelper.getTransactionServices();
    }
}

