/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.config;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.config.metro.dev.FeatureReader;
import com.sun.xml.ws.config.metro.util.ParserUtil;
import com.sun.xml.ws.runtime.config.TubelineFeature;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.ws.WebServiceException;

public class TubelineFeatureReader
implements FeatureReader {
    private static final Logger LOGGER = Logger.getLogger(TubelineFeatureReader.class);

    public TubelineFeature parse(XMLEventReader reader) throws WebServiceException {
        try {
            boolean attributeEnabled = true;
            StartElement element = reader.nextEvent().asStartElement();
            QName elementName = element.getName();
            Iterator iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute nextAttribute = (Attribute)iterator.next();
                QName attributeName = nextAttribute.getName();
                if (ENABLED_ATTRIBUTE_NAME.equals(attributeName)) {
                    attributeEnabled = ParserUtil.parseBooleanValue(nextAttribute.getValue());
                    continue;
                }
                throw LOGGER.logSevereException(new WebServiceException("Unexpected attribute"));
            }
            EndElement endElement = reader.nextEvent().asEndElement();
            if (!elementName.equals(endElement.getName())) {
                throw LOGGER.logSevereException(new WebServiceException("Expected end element"));
            }
            return new TubelineFeature(attributeEnabled);
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal XML document", (Throwable)e));
        }
    }
}

