/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.persistence;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.ConfigReader;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.EndpointStarter;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.commons.DelayedTaskManager;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.config.management.server.ReDelegate;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConfigReader<T>
implements ConfigReader<T> {
    private static final Logger LOGGER = Logger.getLogger(JdbcConfigReader.class);
    private static final QName POLLING_INTERVAL_PARAMETER_NAME = new QName("http://java.sun.com/xml/ns/metro/management", "PollingInterval");
    private static final long DEFAULT_POLLING_INTERVAL = 10000L;
    private ManagedEndpoint<T> endpoint;
    private ManagedServiceAssertion assertion;
    private EndpointCreationAttributes creationAttributes;
    private ClassLoader endpointClassLoader;
    private EndpointStarter endpointStarter;
    private long pollingInterval;
    private volatile ConfigPoller<T> poller = null;

    @Override
    public synchronized void init(ManagedEndpoint<T> endpoint, ManagedServiceAssertion assertion, EndpointCreationAttributes attributes, ClassLoader classLoader, EndpointStarter starter) {
        String className;
        this.endpoint = endpoint;
        this.assertion = assertion;
        this.creationAttributes = attributes;
        this.endpointClassLoader = classLoader;
        this.endpointStarter = starter;
        this.pollingInterval = 10000L;
        ManagedServiceAssertion.ImplementationRecord record = assertion.getConfigReaderImplementation();
        if (record != null && ((className = record.getImplementation()) == null || className.equals(JdbcConfigReader.class.getName()))) {
            String pollingIntervalText = null;
            try {
                Map<QName, String> classParameters = record.getParameters();
                pollingIntervalText = classParameters.get(POLLING_INTERVAL_PARAMETER_NAME);
                if (pollingIntervalText != null) {
                    this.pollingInterval = Long.parseLong(pollingIntervalText);
                }
            }
            catch (NumberFormatException e) {
                throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5039_FAILED_NUMBER_CONVERSION(POLLING_INTERVAL_PARAMETER_NAME, pollingIntervalText), (Throwable)e));
            }
        }
    }

    @Override
    public synchronized void start(NamedParameters parameters) throws IllegalStateException {
        if (this.poller != null && !this.poller.isStopped()) {
            throw LOGGER.logSevereException(new IllegalStateException(ManagementMessages.WSM_5087_FAILED_POLLER_START()));
        }
        this.poller = new ConfigPoller<T>(this.endpoint, this.assertion, this.creationAttributes, this.endpointClassLoader, this.endpointStarter, this.pollingInterval);
        this.poller.start();
    }

    @Override
    public synchronized void stop() throws IllegalStateException {
        if (this.poller == null) {
            throw LOGGER.logSevereException(new IllegalStateException(ManagementMessages.WSM_5033_POLLER_STOP_FAILED(this.getClass().getName())));
        }
        this.poller.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigPoller<T>
    implements DelayedTaskManager.DelayedTask {
        private static final String START_ATTRIBUTE_NOTIFY_VALUE_NAME = "notify";
        private static final String POLLER_NAME = "JDBC configuration management poller";
        private final ManagedEndpoint<T> endpoint;
        private final EndpointCreationAttributes creationAttributes;
        private final ClassLoader classLoader;
        private final EndpointStarter endpointStarter;
        private final ManagedServiceAssertion managedService;
        private final long executionDelay;
        private volatile boolean stopped;
        private volatile long version = 0L;

        public ConfigPoller(ManagedEndpoint<T> endpoint, ManagedServiceAssertion assertion, EndpointCreationAttributes attributes, ClassLoader classLoader, EndpointStarter starter, long executionDelay) {
            this.endpoint = endpoint;
            this.creationAttributes = attributes;
            this.classLoader = classLoader;
            this.endpointStarter = starter;
            this.managedService = assertion;
            this.executionDelay = executionDelay;
            this.stopped = true;
            String start = this.managedService.getStart();
            if (start == null || !start.equals(START_ATTRIBUTE_NOTIFY_VALUE_NAME)) {
                if (LOGGER.isLoggable(Level.CONFIG)) {
                    LOGGER.config(ManagementMessages.WSM_5035_START_ENDPOINT_IMMEDIATELY(start));
                }
                this.endpointStarter.startEndpoint();
            } else if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(ManagementMessages.WSM_5036_WAIT_ENDPOINT_START(start));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5040_CREATED_POLLER(executionDelay));
            }
        }

        @Override
        public String getName() {
            return POLLER_NAME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(DelayedTaskManager manager) {
            if (this.stopped) {
                return;
            }
            Connection connection = null;
            DataSource source = null;
            try {
                ManagedServiceAssertion.ImplementationRecord record = this.managedService.getConfigReaderImplementation();
                ManagementUtil.JdbcTableNames tableNames = ManagementUtil.getJdbcTableNames(record, JdbcConfigReader.class.getName());
                source = ManagementUtil.getJdbcDataSource(record, JdbcConfigReader.class.getName());
                connection = source.getConnection();
                this.pollData(connection, tableNames, this.endpoint.getId());
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.warning(ManagementMessages.WSM_5021_NO_DB_CONNECT(source), e);
            }
            catch (Exception e) {
                LOGGER.severe(ManagementMessages.WSM_5037_FAILED_RECONFIGURE(), e);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.warning(ManagementMessages.WSM_5022_NO_DB_CLOSE(connection), e);
                }
                if (!this.stopped) {
                    MaintenanceTaskExecutor.INSTANCE.register(this, this.executionDelay, TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start() {
            LOGGER.entering();
            try {
                if (this.stopped) {
                    this.stopped = false;
                    MaintenanceTaskExecutor.INSTANCE.register(this, 0L, TimeUnit.MILLISECONDS);
                } else {
                    LOGGER.warning(ManagementMessages.WSM_5034_DUPLICATE_START(this.getName()));
                }
            }
            finally {
                LOGGER.exiting();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop() {
            LOGGER.entering();
            try {
                this.stopped = true;
            }
            finally {
                LOGGER.exiting();
            }
        }

        synchronized boolean isStopped() {
            return this.stopped;
        }

        private void pollData(Connection connection, ManagementUtil.JdbcTableNames tableNames, String endpointId) {
            Statement statement = null;
            try {
                String query = "SELECT " + tableNames.getVersionName() + ", " + tableNames.getConfigName() + " FROM " + tableNames.getTableName() + " WHERE " + tableNames.getIdName() + " = ? AND " + tableNames.getVersionName() + " > ?";
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(ManagementMessages.WSM_5023_EXECUTE_SQL(query));
                }
                statement = connection.prepareStatement(query);
                statement.setString(1, endpointId);
                statement.setLong(2, this.version);
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(ManagementMessages.WSM_5029_FOUND_UPDATED_CONFIG());
                    }
                    this.version = result.getLong(tableNames.getVersionName());
                    Reader data = result.getCharacterStream(tableNames.getConfigName());
                    this.reconfigure(data);
                } else if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finer(ManagementMessages.WSM_5030_NO_UPDATED_CONFIG());
                }
            }
            catch (SQLException e) {
                throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5038_FAILED_CONFIG_READ(), (Throwable)e));
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        LOGGER.warning(ManagementMessages.WSM_5026_FAILED_STATEMENT_CLOSE(statement), e);
                    }
                }
            }
        }

        private void reconfigure(Reader reader) {
            NamedParameters parameters = new NamedParameters().put("ENDPOINT_INSTANCE", this.endpoint).put("CREATION_ATTRIBUTES", this.creationAttributes).put("CLASS_LOADER", this.classLoader).put("CONFIGURATION_DATA", ManagementUtil.convert(reader));
            ReDelegate.recreate(parameters);
            this.endpointStarter.startEndpoint();
        }
    }
}

