/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.server;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.policy.ModelGenerator;
import com.sun.xml.ws.config.management.server.FragmentSerializer;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelMarshaller;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.policy.sourcemodel.attach.ExternalAttachmentsUnmarshaller;
import com.sun.xml.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.ws.policy.sourcemodel.wspolicy.XmlToken;
import com.sun.xml.ws.resources.ManagementMessages;
import com.sun.xml.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementWSDLPatcher
extends XMLStreamReaderToXMLStreamWriter {
    private static final Logger LOGGER = Logger.getLogger(ManagementWSDLPatcher.class);
    private static final PolicyModelMarshaller POLICY_MARSHALLER = PolicyModelMarshaller.getXmlMarshaller(true);
    private static final PolicyModelGenerator POLICY_GENERATOR = ModelGenerator.getGenerator();
    private final Map<URI, Policy> urnToPolicy;
    private long skipDepth = -1L;
    private boolean inBinding = false;

    public ManagementWSDLPatcher(Map<URI, Policy> urnToPolicy) {
        this.urnToPolicy = urnToPolicy;
    }

    @Override
    protected void handleStartElement() throws XMLStreamException {
        if (this.skipDepth >= 0L) {
            ++this.skipDepth;
            return;
        }
        QName elementName = this.in.getName();
        XmlToken policyToken = NamespaceVersion.resolveAsToken(elementName);
        if (policyToken != XmlToken.UNKNOWN) {
            ++this.skipDepth;
            return;
        }
        if (elementName.equals(WSDLConstants.QNAME_BINDING)) {
            this.inBinding = true;
            super.handleStartElement();
            Policy bindingPolicy = this.urnToPolicy.get(ExternalAttachmentsUnmarshaller.BINDING_ID);
            if (bindingPolicy != null) {
                this.writePolicy(bindingPolicy);
            }
        } else if (this.inBinding && elementName.equals(WSDLConstants.QNAME_OPERATION)) {
            super.handleStartElement();
            Policy operationPolicy = this.urnToPolicy.get(ExternalAttachmentsUnmarshaller.BINDING_OPERATION_ID);
            if (operationPolicy != null) {
                this.writePolicy(operationPolicy);
            }
        } else if (this.inBinding && elementName.equals(WSDLConstants.QNAME_INPUT)) {
            super.handleStartElement();
            Policy inputPolicy = this.urnToPolicy.get(ExternalAttachmentsUnmarshaller.BINDING_OPERATION_INPUT_ID);
            if (inputPolicy != null) {
                this.writePolicy(inputPolicy);
            }
        } else if (this.inBinding && elementName.equals(WSDLConstants.QNAME_OUTPUT)) {
            super.handleStartElement();
            Policy outputPolicy = this.urnToPolicy.get(ExternalAttachmentsUnmarshaller.BINDING_OPERATION_OUTPUT_ID);
            if (outputPolicy != null) {
                this.writePolicy(outputPolicy);
            }
        } else if (this.inBinding && elementName.equals(WSDLConstants.QNAME_FAULT)) {
            super.handleStartElement();
            Policy faultPolicy = this.urnToPolicy.get(ExternalAttachmentsUnmarshaller.BINDING_OPERATION_FAULT_ID);
            if (faultPolicy != null) {
                this.writePolicy(faultPolicy);
            }
        } else {
            super.handleStartElement();
        }
    }

    @Override
    protected void handleEndElement() throws XMLStreamException {
        QName elementName = this.in.getName();
        if (this.inBinding) {
            boolean bl = this.inBinding = !elementName.equals(WSDLConstants.QNAME_BINDING);
        }
        if (this.skipDepth < 0L) {
            super.handleEndElement();
            return;
        }
        --this.skipDepth;
    }

    @Override
    protected void handleAttribute(int i) throws XMLStreamException {
        QName attributeName = this.in.getAttributeName(i);
        XmlToken policyToken = NamespaceVersion.resolveAsToken(attributeName);
        switch (policyToken) {
            case PolicyUris: {
                return;
            }
        }
        super.handleAttribute(i);
    }

    @Override
    protected void handleCharacters() throws XMLStreamException {
        super.handleCharacters();
    }

    private void writePolicy(Policy policy) {
        try {
            PolicySourceModel policyModel = POLICY_GENERATOR.translate(policy);
            FragmentSerializer serializer = new FragmentSerializer(this.out);
            POLICY_MARSHALLER.marshal(policyModel, (Object)serializer);
        }
        catch (PolicyException ex) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_0004_CANNOT_MARSHAL(this.out)), ex);
        }
    }
}

