/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.DataSourceProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DefaultDataSourceProvider
implements DataSourceProvider {
    private static final String RM_JDBC_POOL_NAME = "jdbc/ReliableMessagingPool";
    private static final Logger LOGGER = Logger.getLogger(DefaultDataSourceProvider.class);
    private final DataSource ds = DefaultDataSourceProvider.getDataSource("jdbc/ReliableMessagingPool");

    private static synchronized DataSource getDataSource(String jndiName) throws PersistenceException {
        try {
            InitialContext ic = new InitialContext();
            Object __ds = ic.lookup(jndiName);
            if (!(__ds instanceof DataSource)) {
                throw new PersistenceException(String.format("Object of class '%s' bound in the JNDI under '%s' is not an instance of '%s'.", __ds.getClass().getName(), jndiName, DataSource.class.getName()));
            }
            DataSource ds = (DataSource)DataSource.class.cast(__ds);
            return ds;
        }
        catch (NamingException ex) {
            throw LOGGER.logSevereException(new PersistenceException("Unable to lookup Metro reliable messaging JDBC connection pool", ex));
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }
}

