/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.security.core.ai.IdentityType;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.EndpointReferenceExtensionContributor;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secext10.BinarySecurityTokenType;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.wss.jaxws.impl.ServerTubeConfiguration;
import com.sun.xml.wss.jaxws.impl.TubeConfiguration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityComponent
implements EndpointComponent {
    protected TubeConfiguration pipeConfig = null;
    PolicyMap pm = null;
    WSEndpoint e = null;
    Map props = null;
    Certificate cs = null;
    SOAPVersion sp = null;

    public IdentityComponent(WSEndpoint e, PolicyMap pm, Map props) {
        this.pm = pm;
        this.e = e;
        this.props = props;
        this.sp = e.getBinding().getSOAPVersion();
        try {
            this.getServerKeyStore();
        }
        catch (IOException ex) {
            Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public <T> T getSPI(@NotNull Class<T> spiType) {
        if (spiType.isAssignableFrom(EndpointReferenceExtensionContributor.class)) {
            return (T)new IdentityEPRExtnContributor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getServerKeyStore() throws IOException {
        String alias = null;
        String password = null;
        String location = null;
        FileInputStream fis = null;
        WSDLPort port = (WSDLPort)this.props.get("WSDL_MODEL");
        this.pipeConfig = new ServerTubeConfiguration(this.pm, port, this.e);
        QName serviceName = this.pipeConfig.getWSDLPort().getOwner().getName();
        QName portName = this.pipeConfig.getWSDLPort().getName();
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
        try {
            Policy ep = this.pm.getEndpointEffectivePolicy(endpointKey);
            block15: for (AssertionSet assertionSet : ep) {
                for (PolicyAssertion pa : assertionSet) {
                    if (!PolicyUtil.isConfigPolicyAssertion(pa)) continue;
                    HashMap atts = (HashMap)pa.getAttributes();
                    Set ks = atts.keySet();
                    for (QName name : ks) {
                        if (name.getLocalPart().equals("storepass")) {
                            password = (String)atts.get(name);
                            continue;
                        }
                        if (name.getLocalPart().equals("location")) {
                            location = (String)atts.get(name);
                            if (!location.startsWith("$WSIT")) continue;
                            String path = System.getProperty("WSIT_HOME");
                            StringBuffer sb = new StringBuffer(location);
                            sb.replace(0, 10, path);
                            location = sb.toString();
                            continue;
                        }
                        if (!name.getLocalPart().equals("alias")) continue;
                        alias = (String)atts.get(name);
                    }
                    KeyStore keyStore = null;
                    try {
                        keyStore = KeyStore.getInstance("JKS");
                        fis = new FileInputStream(location);
                        keyStore.load(fis, password.toCharArray());
                        this.cs = keyStore.getCertificate(alias);
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (CertificateException ex) {
                        Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (KeyStoreException ex) {
                        Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
                        ex.printStackTrace();
                    }
                    finally {
                        keyStore = null;
                        fis.close();
                        continue block15;
                    }
                }
            }
        }
        catch (PolicyException ex) {
            Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public XMLStreamReader readHeader(IdentityType identityElem) throws XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement<IdentityType> idElem = new com.sun.xml.security.core.ai.ObjectFactory().createIdentity(identityElem);
        try {
            JAXBUtil.createMarshaller(this.sp).marshal(idElem, (Result)xbr);
        }
        catch (JAXBException je) {
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }

    class IdentityEPRExtnContributor
    extends EndpointReferenceExtensionContributor {
        QName ID_QNAME = new QName("http://example.com/addressingidentity", "Identity");

        IdentityEPRExtnContributor() {
        }

        public WSEndpointReference.EPRExtension getEPRExtension(@Nullable WSEndpointReference.EPRExtension extension) {
            return new WSEndpointReference.EPRExtension(){

                public XMLStreamReader readAsXMLStreamReader() throws XMLStreamException {
                    XMLStreamReader reader = null;
                    try {
                        String id = PolicyUtil.randomUUID();
                        BinarySecurityTokenType bst = new BinarySecurityTokenType();
                        bst.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                        bst.setId(id);
                        bst.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
                        if (IdentityComponent.this.cs != null) {
                            bst.setValue(IdentityComponent.this.cs.getEncoded());
                        }
                        JAXBElement<BinarySecurityTokenType> bstElem = new ObjectFactory().createBinarySecurityToken(bst);
                        IdentityType identityElement = new IdentityType();
                        identityElement.getDnsOrSpnOrUpn().add(bstElem);
                        reader = IdentityComponent.this.readHeader(identityElement);
                    }
                    catch (CertificateEncodingException ex) {
                        Logger.getLogger(IdentityComponent.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return reader;
                }

                public QName getQName() {
                    return IdentityEPRExtnContributor.this.ID_QNAME;
                }
            };
        }

        public QName getQName() {
            return this.ID_QNAME;
        }
    }
}

