/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InvalidAcknowledgementException;
import com.sun.xml.ws.rx.rm.runtime.sequence.MessageNumberRolloverException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutboundSequence
extends AbstractSequence {
    public static final long INITIAL_LAST_MESSAGE_ID = 0L;
    private static final Logger LOGGER = Logger.getLogger(OutboundSequence.class);

    public OutboundSequence(SequenceData data, DeliveryQueueBuilder deliveryQueueBuilder, TimeSynchronizer timeSynchronizer) {
        super(data, deliveryQueueBuilder, timeSynchronizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessage(ApplicationMessage message, boolean storeMessageFlag) throws DuplicateMessageRegistrationException, AbstractSoapFaultException {
        this.checkSequenceCreatedStatus("", AbstractSoapFaultException.Code.Sender);
        if (message.getSequenceId() != null) {
            throw new IllegalArgumentException(String.format("Cannot register message: Application message has been already registered on a sequence [ %s ].", message.getSequenceId()));
        }
        try {
            this.data.lockWrite();
            message.setSequenceData(this.getId(), this.generateNextMessageId());
            if (storeMessageFlag) {
                this.data.attachMessageToUnackedMessageNumber(message);
            }
        }
        finally {
            this.data.unlockWrite();
        }
    }

    private long generateNextMessageId() throws MessageNumberRolloverException, IllegalStateException, DuplicateMessageRegistrationException {
        long nextId = this.getLastMessageNumber() + 1L;
        if (nextId > Long.MAX_VALUE) {
            throw LOGGER.logSevereException(new MessageNumberRolloverException(this.getId(), nextId));
        }
        this.data.setLastMessageNumber(nextId);
        this.data.registerUnackedMessageNumber(nextId, true);
        return nextId;
    }

    @Override
    public void acknowledgeMessageNumber(long messageId) {
        throw new UnsupportedOperationException(String.format("This operation is not supported on %s class", this.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessageNumbers(List<Sequence.AckRange> ranges) throws InvalidAcknowledgementException, AbstractSoapFaultException {
        this.checkSequenceCreatedStatus("", AbstractSoapFaultException.Code.Sender);
        try {
            this.data.lockWrite();
            if (ranges == null || ranges.isEmpty()) {
                return;
            }
            if (ranges.size() > 1) {
                Collections.sort(ranges, new Comparator<Sequence.AckRange>(){

                    @Override
                    public int compare(Sequence.AckRange range1, Sequence.AckRange range2) {
                        if (range1.lower <= range2.lower) {
                            return -1;
                        }
                        return 1;
                    }
                });
            }
            Sequence.AckRange lastAckRange = ranges.get(ranges.size() - 1);
            if (this.getLastMessageNumber() < lastAckRange.upper) {
                throw new InvalidAcknowledgementException(this.getId(), lastAckRange.upper, ranges);
            }
            Collection<Long> unackedMessageNumbers = this.data.getUnackedMessageNumbers();
            if (unackedMessageNumbers.isEmpty()) {
                return;
            }
            Iterator<Sequence.AckRange> rangeIterator = ranges.iterator();
            Sequence.AckRange currentRange = rangeIterator.next();
            for (long unackedMessageNumber : unackedMessageNumbers) {
                if (unackedMessageNumber >= currentRange.lower && unackedMessageNumber <= currentRange.upper) {
                    this.data.markAsAcknowledged(unackedMessageNumber);
                    continue;
                }
                if (rangeIterator.hasNext()) {
                    currentRange = rangeIterator.next();
                    continue;
                }
                break;
            }
        }
        finally {
            this.data.unlockWrite();
        }
        this.getDeliveryQueue().onSequenceAcknowledgement();
    }
}

