/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.typelib;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.DumpToString;
import org.glassfish.gmbal.typelib.EvaluatedArrayType;
import org.glassfish.gmbal.typelib.EvaluatedArrayTypeBase;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclarationBase;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclarationBase;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclarationBase;
import org.glassfish.gmbal.typelib.EvaluatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationFactory {
    private static boolean DEBUG = false;
    private static DprintUtil dputil = new DprintUtil(DeclarationFactory.class);
    private static final Map<EvaluatedType, EvaluatedArrayType> arrayMap = new HashMap<EvaluatedType, EvaluatedArrayType>();
    private static final Map<String, EvaluatedClassDeclaration> simpleClassMap = new HashMap<String, EvaluatedClassDeclaration>();

    private DeclarationFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EvaluatedArrayType egat(EvaluatedType compType) {
        EvaluatedArrayType result = arrayMap.get(compType);
        if (result == null) {
            if (DEBUG) {
                dputil.enter("egat", "compType", compType);
            }
            try {
                result = new EvaluatedArrayTypeImpl(compType);
                arrayMap.put(compType, result);
            }
            finally {
                if (DEBUG) {
                    dputil.exit(result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EvaluatedClassDeclaration ecdecl(int modifiers, String name, List<EvaluatedClassDeclaration> inheritance, List<EvaluatedMethodDeclaration> methods, List<EvaluatedFieldDeclaration> fields, Class cls, boolean isImmutable) {
        EvaluatedClassDeclaration result = null;
        if (cls.getTypeParameters().length == 0) {
            result = simpleClassMap.get(name);
        }
        if (result == null) {
            if (DEBUG) {
                dputil.enter("ecdecl", "name", name);
            }
            try {
                result = new EvaluatedClassDeclarationImpl(modifiers, name, inheritance, methods, fields, cls, isImmutable);
                if (result.simpleClass()) {
                    simpleClassMap.put(name, result);
                }
            }
            finally {
                if (DEBUG) {
                    dputil.exit(result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EvaluatedFieldDeclaration efdecl(EvaluatedClassDeclaration ecdecl, int modifiers, EvaluatedType ftype, String name, Field field) {
        if (DEBUG) {
            dputil.enter("efdecl", "name", name, "ftype", ftype);
        }
        EvaluatedFieldDeclarationImpl result = null;
        try {
            result = new EvaluatedFieldDeclarationImpl(ecdecl, modifiers, ftype, name, field);
            if (DEBUG) {
                dputil.exit(result);
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                dputil.exit(result);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EvaluatedMethodDeclaration emdecl(EvaluatedClassDeclaration ecdecl, int modifiers, EvaluatedType rtype, String name, List<EvaluatedType> ptypes, Method method) {
        if (DEBUG) {
            dputil.enter("emdecl", "name", name, "ptypes", ptypes);
        }
        EvaluatedMethodDeclarationImpl result = null;
        try {
            result = new EvaluatedMethodDeclarationImpl(ecdecl, modifiers, rtype, name, ptypes, method);
            if (DEBUG) {
                dputil.exit(result);
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                dputil.exit(result);
            }
            throw throwable;
        }
        return result;
    }

    public static EvaluatedClassDeclaration ecdecl(int modifiers, String name, Class cls) {
        return DeclarationFactory.ecdecl(modifiers, name, cls, false);
    }

    public static EvaluatedClassDeclaration ecdecl(int modifiers, String name, Class cls, boolean isImmutable) {
        return DeclarationFactory.ecdecl(modifiers, name, new ArrayList<EvaluatedClassDeclaration>(0), new ArrayList<EvaluatedMethodDeclaration>(0), new ArrayList<EvaluatedFieldDeclaration>(0), cls, isImmutable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvaluatedClassDeclarationImpl
    extends EvaluatedClassDeclarationBase {
        private final int modifiers;
        private final String name;
        private List<EvaluatedClassDeclaration> inheritance;
        private List<EvaluatedMethodDeclaration> methods;
        @DumpToString
        private final Class cls;
        private List<EvaluatedType> instantiations = new ArrayList<EvaluatedType>(0);
        private boolean simpleClass;
        private boolean frozen;
        private List<EvaluatedFieldDeclaration> fields;
        private boolean isImmutable;

        public EvaluatedClassDeclarationImpl(int modifiers, String name, List<EvaluatedClassDeclaration> inheritance, List<EvaluatedMethodDeclaration> methods, List<EvaluatedFieldDeclaration> fields, Class cls, boolean isImmutable) {
            this.modifiers = modifiers;
            this.name = name;
            this.inheritance = inheritance;
            this.methods = methods;
            this.fields = fields;
            this.cls = cls;
            this.simpleClass = cls.getTypeParameters().length == 0;
            this.frozen = false;
            this.isImmutable = isImmutable;
        }

        @Override
        public void freeze() {
            this.frozen = true;
        }

        @Override
        public boolean simpleClass() {
            return this.simpleClass;
        }

        @Override
        public <T extends Annotation> T annotation(Class<T> annotationType) {
            if (this.cls == null) {
                throw new UnsupportedOperationException("Not supported in constructed ClassDeclaration.");
            }
            return this.cls.getAnnotation(annotationType);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.cls == null) {
                throw new UnsupportedOperationException("Not supported in constructed ClassDeclaration.");
            }
            return Arrays.asList(this.cls.getAnnotations());
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int modifiers() {
            return this.modifiers;
        }

        @Override
        public Class cls() {
            return this.cls;
        }

        @Override
        public List<EvaluatedMethodDeclaration> methods() {
            return this.methods;
        }

        @Override
        public List<EvaluatedClassDeclaration> inheritance() {
            return this.inheritance;
        }

        private void checkFrozen() {
            if (this.frozen) {
                throw new IllegalStateException("Cannot modify frozen instance for " + this);
            }
        }

        @Override
        public void methods(List<EvaluatedMethodDeclaration> meths) {
            this.checkFrozen();
            this.methods = meths;
        }

        @Override
        public void inheritance(List<EvaluatedClassDeclaration> inh) {
            this.checkFrozen();
            this.inheritance = inh;
        }

        @Override
        public AnnotatedElement element() {
            return this.cls;
        }

        @Override
        public List<EvaluatedType> instantiations() {
            return this.instantiations;
        }

        @Override
        public void instantiations(List<EvaluatedType> arg) {
            this.checkFrozen();
            if (this.simpleClass) {
                throw new IllegalStateException("Cannot add instantiations to a class with no type args");
            }
            this.instantiations = arg;
        }

        @Override
        public List<EvaluatedFieldDeclaration> fields() {
            return this.fields;
        }

        @Override
        public void fields(List<EvaluatedFieldDeclaration> arg) {
            this.checkFrozen();
            this.fields = arg;
        }

        @Override
        public boolean isImmutable() {
            return this.isImmutable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvaluatedMethodDeclarationImpl
    extends EvaluatedMethodDeclarationBase {
        private final EvaluatedClassDeclaration container;
        private final int modifiers;
        private final EvaluatedType rtype;
        private final String name;
        private final List<EvaluatedType> ptypes;
        @DumpToString
        private final Method method;

        public EvaluatedMethodDeclarationImpl(EvaluatedClassDeclaration cdecl, int modifiers, EvaluatedType rtype, String name, List<EvaluatedType> ptypes, Method method) {
            this.container = cdecl;
            this.modifiers = modifiers;
            this.rtype = rtype;
            this.name = name;
            this.ptypes = ptypes;
            this.method = method;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int modifiers() {
            return this.modifiers;
        }

        @Override
        public List<EvaluatedType> parameterTypes() {
            return this.ptypes;
        }

        @Override
        public EvaluatedType returnType() {
            return this.rtype;
        }

        @Override
        public EvaluatedClassDeclaration containingClass() {
            return this.container;
        }

        @Override
        public Method method() {
            return this.method;
        }

        @Override
        public <T extends Annotation> T annotation(Class<T> annotationType) {
            if (this.method == null) {
                throw new UnsupportedOperationException("Not supported in constructed ClassDeclaration.");
            }
            return this.method.getAnnotation(annotationType);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.method == null) {
                throw new UnsupportedOperationException("Not supported in constructed ClassDeclaration.");
            }
            return Arrays.asList(this.method.getAnnotations());
        }

        @Override
        public AnnotatedElement element() {
            return this.method;
        }

        @Override
        public AccessibleObject accessible() {
            return this.method;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvaluatedFieldDeclarationImpl
    extends EvaluatedFieldDeclarationBase {
        private final EvaluatedClassDeclaration container;
        private final int modifiers;
        private final EvaluatedType fieldType;
        private final String name;
        @DumpToString
        private final Field field;

        public EvaluatedFieldDeclarationImpl(EvaluatedClassDeclaration cdecl, int modifiers, EvaluatedType fieldType, String name, Field field) {
            this.container = cdecl;
            this.modifiers = modifiers;
            this.fieldType = fieldType;
            this.name = name;
            this.field = field;
        }

        @Override
        public <T extends Annotation> T annotation(Class<T> annotationType) {
            if (this.field == null) {
                throw new UnsupportedOperationException("Not supported in constructed ClassDeclaration.");
            }
            return this.field.getAnnotation(annotationType);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.field == null) {
                throw new UnsupportedOperationException("Not supported in constructed ClassDeclaration.");
            }
            return Arrays.asList(this.field.getAnnotations());
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int modifiers() {
            return this.modifiers;
        }

        @Override
        public AnnotatedElement element() {
            return this.field;
        }

        @Override
        public AccessibleObject accessible() {
            return this.field;
        }

        @Override
        public EvaluatedType fieldType() {
            return this.fieldType;
        }

        @Override
        public EvaluatedClassDeclaration containingClass() {
            return this.container;
        }

        @Override
        public Field field() {
            return this.field;
        }
    }

    private static class EvaluatedArrayTypeImpl
    extends EvaluatedArrayTypeBase {
        private EvaluatedType compType;

        public EvaluatedArrayTypeImpl(EvaluatedType compType) {
            this.compType = compType;
        }

        public EvaluatedType componentType() {
            return this.compType;
        }
    }
}

