/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.delivery;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.InOrderDeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.rm.runtime.delivery.SimpleDeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;

public final class DeliveryQueueBuilder {
    @NotNull
    private final RuntimeContext rc;
    @NotNull
    private final Postman postman;
    @NotNull
    private final Postman.Callback deliveryCallback;
    private Sequence sequence;

    public static DeliveryQueueBuilder getBuilder(@NotNull RuntimeContext rc, @NotNull Postman postman, @NotNull Postman.Callback deliveryCallback) {
        return new DeliveryQueueBuilder(rc, postman, deliveryCallback);
    }

    private DeliveryQueueBuilder(@NotNull RuntimeContext rc, @NotNull Postman postman, @NotNull Postman.Callback deliveryCallback) {
        assert (rc != null);
        assert (postman != null);
        assert (deliveryCallback != null);
        this.rc = rc;
        this.postman = postman;
        this.deliveryCallback = deliveryCallback;
    }

    public void sequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public DeliveryQueue build() {
        if (this.rc.configuration.isOrderedDeliveryEnabled()) {
            return new InOrderDeliveryQueue(this.postman, this.deliveryCallback, this.sequence, this.rc.configuration.getDestinationBufferQuota());
        }
        return new SimpleDeliveryQueue(this.postman, this.deliveryCallback, this.sequence);
    }
}

