/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.xml.ws.resources.HttpserverMessages;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.server.ServerConnectionImpl;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

final class WSHttpHandler
implements HttpHandler {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private final HttpAdapter adapter;
    private final Executor executor;

    public WSHttpHandler(@NotNull HttpAdapter adapter, @Nullable Executor executor) {
        assert (adapter != null);
        this.adapter = adapter;
        this.executor = executor;
    }

    public void handle(HttpExchange msg) {
        try {
            logger.fine("Received HTTP request:" + msg.getRequestURI());
            if (this.executor != null) {
                this.executor.execute(new HttpHandlerRunnable(msg));
            } else {
                this.handleExchange(msg);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExchange(HttpExchange msg) throws IOException {
        ServerConnectionImpl con = new ServerConnectionImpl(this.adapter, msg);
        try {
            logger.fine("Received HTTP request:" + msg.getRequestURI());
            String method = msg.getRequestMethod();
            if (method.equals(GET_METHOD) || method.equals(POST_METHOD) || method.equals(HEAD_METHOD) || method.equals(PUT_METHOD) || method.equals(DELETE_METHOD)) {
                this.adapter.handle(con);
            } else {
                logger.warning(HttpserverMessages.UNEXPECTED_HTTP_METHOD(method));
            }
        }
        finally {
            msg.close();
        }
    }

    class HttpHandlerRunnable
    implements Runnable {
        final HttpExchange msg;

        HttpHandlerRunnable(HttpExchange msg) {
            this.msg = msg;
        }

        public void run() {
            try {
                WSHttpHandler.this.handleExchange(this.msg);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

