/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing.policy;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsawAddressingModelConfiguratorProvider
implements ModelConfiguratorProvider {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(WsawAddressingModelConfiguratorProvider.class);
    private static final QName WSAW_ADDRESSING_ASSERTION = new QName(AddressingVersion.W3C.policyNsUri, "UsingAddressing");

    @Override
    public Collection<WebServiceFeature> getFeatures(PolicyMapKey key, PolicyMap policyMap) throws PolicyException {
        Policy policy;
        LOGGER.entering(key, policyMap);
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (key != null && policyMap != null && null != (policy = policyMap.getEndpointEffectivePolicy(key)) && policy.contains(WSAW_ADDRESSING_ASSERTION)) {
            for (AssertionSet assertionSet : policy) {
                for (PolicyAssertion assertion : assertionSet) {
                    if (!assertion.getName().equals(WSAW_ADDRESSING_ASSERTION)) continue;
                    AddressingFeature feature = new AddressingFeature(true, !assertion.isOptional());
                    features.add((WebServiceFeature)feature);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Added addressing feature \"" + feature + "\" to element \"" + key + "\"");
                }
            }
        }
        LOGGER.exiting(features);
        return features;
    }
}

