/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.testing;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.runtime.PacketAdapter;

public abstract class PacketFilter {
    protected static final long UNSPECIFIED = -1L;
    private static final Logger LOGGER = Logger.getLogger(PacketFilter.class);
    private RmVersion rmVersion;
    private SOAPVersion soapVersion;
    private AddressingVersion addressingVersion;

    protected PacketFilter() {
    }

    public abstract Packet filterClientRequest(Packet var1) throws Exception;

    public abstract Packet filterServerResponse(Packet var1) throws Exception;

    protected final String getSequenceId(Packet packet) {
        try {
            if (this.notInitialized(packet)) {
                return null;
            }
            PacketAdapter pa = PacketAdapter.getInstance(this.rmVersion, this.soapVersion, this.addressingVersion, packet);
            return pa.getSequenceId();
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return null;
        }
    }

    protected final long getMessageId(Packet packet) {
        try {
            if (this.notInitialized(packet)) {
                return -1L;
            }
            PacketAdapter pa = PacketAdapter.getInstance(this.rmVersion, this.soapVersion, this.addressingVersion, packet);
            return pa.getMessageNumber();
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return -1L;
        }
    }

    protected final RmVersion getRmVersion() {
        return this.rmVersion;
    }

    final void configure(RmVersion rmVersion, SOAPVersion soapVersion, AddressingVersion addressingVersion) {
        this.rmVersion = rmVersion;
        this.soapVersion = soapVersion;
        this.addressingVersion = addressingVersion;
    }

    private boolean notInitialized(Packet packet) {
        return this.rmVersion == null || packet == null || packet.getMessage() == null;
    }
}

