/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import javax.xml.namespace.QName;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.WSDLPortImpl;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Port
extends AbstractHandler {
    private WSDLPortImpl port;
    private WSDLContentHandlerEx runtime;
    private String expectedNamespace;

    public Port(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNamespace = expectedNamespace;
    }

    protected Port(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        super(source, parent, parentCookie);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("port")) {
            this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
            Attributes test = this.runtime.getCurrentAttributes();
            this.processAttributes(test);
        } else {
            super.enterElement(uri, localName, qname, atts);
        }
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("port")) {
            this.endProcessingExtentionElement(this.port);
            this.revertToParentFromLeaveElement(this.port, this._cookie, uri, localName, qname);
            this.port.setDocumentation(this.getWSDLDocumentation());
        }
    }

    private void processAttributes(Attributes test) throws SAXException {
        int index;
        int[] validattrs = new int[test.getLength()];
        String name = XmlUtil.fixNull(test.getValue("name"));
        if (name.equals("")) {
            this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.missingName", "wsdl:message", name), this.runtime.getLocator()));
        }
        if ((index = test.getIndex("name")) >= 0) {
            validattrs[index] = 1;
        }
        this.port = new WSDLPortImpl(this.runtime.getLocator(), new QName(this.runtime.currentWSDL.getName().getNamespaceURI(), name), this.runtime.document);
        index = test.getIndex("binding");
        if (index >= 0) {
            validattrs[index] = 1;
            String qname = test.getValue(index);
            String uri = this.runtime.resolveNamespacePrefix(XmlUtil.getPrefix(qname));
            String localname = XmlUtil.getLocalPart(qname);
            if (uri == null || localname == null) {
                this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.invalidPortTypeDescriptor", qname, name), this.runtime.getLocator()));
            } else {
                this.port.setBinding(new QName(uri, localname));
            }
        }
        this.validateAttribute(this.runtime.getErrorHandler(), test, validattrs);
    }
}

