/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing.policy;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapUpdateProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

public class WsawAddressingMapUpdateProvider
implements PolicyMapUpdateProvider {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(WsawAddressingMapUpdateProvider.class);

    public void update(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LOGGER.entering(policyMapMutator, policyMap, model, wsBinding);
        if (policyMap != null) {
            AddressingFeature addressingFeature = wsBinding.getFeature(AddressingFeature.class);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("addressingFeature = " + addressingFeature);
            }
            if (addressingFeature != null && addressingFeature.isEnabled()) {
                this.addWsawUsingAddressingForCompatibility(policyMapMutator, policyMap, model, addressingFeature);
            }
        }
        LOGGER.exiting();
    }

    private void addWsawUsingAddressingForCompatibility(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, AddressingFeature addressingFeature) throws PolicyException {
        AddressingVersion addressingVersion = AddressingVersion.fromFeature((WebServiceFeature)addressingFeature);
        QName usingAddressing = new QName(addressingVersion.policyNsUri, "UsingAddressing");
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
        Policy existingPolicy = policyMap.getEndpointEffectivePolicy(endpointKey);
        if (existingPolicy == null || !existingPolicy.contains(usingAddressing)) {
            QName bindingName = model.getBoundPortTypeName();
            Policy addressingPolicy = this.createWsawAddressingPolicy(bindingName, usingAddressing, addressingFeature.isRequired());
            PolicySubject addressingPolicySubject = new PolicySubject((Object)bindingName, addressingPolicy);
            PolicyMapKey aKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
            policyMapMutator.putEndpointSubject(aKey, addressingPolicySubject);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Added addressing policy with ID \"" + addressingPolicy.getIdOrName() + "\" to binding element \"" + bindingName + "\"");
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Addressing policy exists already, doing nothing");
        }
    }

    private Policy createWsawAddressingPolicy(QName bindingName, QName assertionName, boolean isRequired) {
        ArrayList<AssertionSet> assertionSets = new ArrayList<AssertionSet>(1);
        ArrayList<AddressingAssertion> assertions = new ArrayList<AddressingAssertion>(1);
        AssertionData addressingData = AssertionData.createAssertionData(assertionName);
        if (!isRequired) {
            addressingData.setOptionalAttribute(true);
        }
        assertions.add(new AddressingAssertion(addressingData));
        assertionSets.add(AssertionSet.createAssertionSet(assertions));
        return Policy.createPolicy(null, bindingName.getLocalPart() + "_Wsaw_Addressing_Policy", assertionSets);
    }

    private static final class AddressingAssertion
    extends PolicyAssertion {
        AddressingAssertion(AssertionData assertionData) {
            super(assertionData, null);
        }
    }
}

