/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.gmbal.generic.BinaryFunction;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.generic.Predicate;
import org.glassfish.gmbal.generic.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Algorithms {
    private Algorithms() {
    }

    public static <T> List<T> list(T ... arg) {
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : arg) {
            result.add(obj);
        }
        return result;
    }

    public static <S, T> Pair<S, T> pair(S first, T second) {
        return new Pair<S, T>(first, second);
    }

    public static <K, V> Map<K, V> map(Pair<K, V> ... pairs) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            result.put(pair.first(), pair.second());
        }
        return result;
    }

    public static <A, R> UnaryFunction<A, R> mapToFunction(final Map<A, R> map) {
        return new UnaryFunction<A, R>(){

            @Override
            public R evaluate(A arg) {
                return map.get(arg);
            }
        };
    }

    public static <A, R> void map(Collection<A> arg, Collection<R> result, UnaryFunction<A, R> func) {
        for (A a : arg) {
            R newArg = func.evaluate(a);
            if (newArg == null) continue;
            result.add(newArg);
        }
    }

    public static <K, A, R> Map<K, R> map(Map<K, A> arg, UnaryFunction<A, R> func) {
        HashMap<K, R> result = new HashMap<K, R>();
        for (Map.Entry<K, A> entry : arg.entrySet()) {
            result.put(entry.getKey(), func.evaluate(entry.getValue()));
        }
        return result;
    }

    public static <A, R> List<R> map(List<A> arg, UnaryFunction<A, R> func) {
        ArrayList result = new ArrayList();
        Algorithms.map(arg, result, func);
        return result;
    }

    public static <A> Predicate<A> and(final Predicate<A> arg1, final Predicate<A> arg2) {
        return new Predicate<A>(){

            @Override
            public boolean evaluate(A arg) {
                return arg1.evaluate(arg) && arg2.evaluate(arg);
            }
        };
    }

    public static <A> Predicate<A> or(final Predicate<A> arg1, final Predicate<A> arg2) {
        return new Predicate<A>(){

            @Override
            public boolean evaluate(A arg) {
                return arg1.evaluate(arg) || arg2.evaluate(arg);
            }
        };
    }

    public static <T> Predicate<T> FALSE(Class<T> cls) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T arg) {
                return false;
            }
        };
    }

    public static <T> Predicate<T> TRUE(Class<T> cls) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T arg) {
                return true;
            }
        };
    }

    public static <A> Predicate<A> not(final Predicate<A> arg1) {
        return new Predicate<A>(){

            @Override
            public boolean evaluate(A arg) {
                return !arg1.evaluate(arg);
            }
        };
    }

    public static <A> void filter(List<A> arg, List<A> result, final Predicate<A> predicate) {
        UnaryFunction filter = new UnaryFunction<A, A>(){

            @Override
            public A evaluate(A arg) {
                return predicate.evaluate(arg) ? arg : null;
            }
        };
        Algorithms.map(arg, result, filter);
    }

    public static <A> List<A> filter(List<A> arg, Predicate<A> predicate) {
        ArrayList result = new ArrayList();
        Algorithms.filter(arg, result, predicate);
        return result;
    }

    public static <A> A find(List<A> arg, Predicate<A> predicate) {
        for (A a : arg) {
            if (!predicate.evaluate(a)) continue;
            return a;
        }
        return null;
    }

    public static <A, R> R fold(List<A> list, R initial, BinaryFunction<R, A, R> func) {
        R result = initial;
        for (A elem : list) {
            result = func.evaluate(result, elem);
        }
        return result;
    }

    public static <S, T> List<T> flatten(List<S> list, final UnaryFunction<S, List<T>> map) {
        return Algorithms.fold(list, new ArrayList(), new BinaryFunction<List<T>, S, List<T>>(){

            @Override
            public List<T> evaluate(List<T> arg1, S arg2) {
                arg1.addAll((Collection)map.evaluate(arg2));
                return arg1;
            }
        });
    }

    public static <T> T getOne(Collection<T> list, String zeroMsg, String manyMsg) {
        T result = null;
        for (T element : list) {
            if (result == null) {
                result = element;
                continue;
            }
            throw new IllegalArgumentException(manyMsg);
        }
        if (result == null) {
            throw new IllegalArgumentException(zeroMsg);
        }
        return result;
    }

    public static <T> T getFirst(Collection<T> list, String zeroMsg) {
        Iterator<T> i$ = list.iterator();
        if (i$.hasNext()) {
            T element = i$.next();
            return element;
        }
        throw new IllegalArgumentException(zeroMsg);
    }
}

