/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TCPAdapterList
extends AbstractList<TCPAdapter>
implements DeploymentDescriptorParser.AdapterFactory<TCPAdapter> {
    private final List<TCPAdapter> adapters = new ArrayList<TCPAdapter>();
    private final Map<String, String> addressMap = new HashMap<String, String>();

    @Override
    public TCPAdapter createAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
        TCPAdapter tcpAdapter = new TCPAdapter(name, urlPattern, endpoint);
        this.adapters.add(tcpAdapter);
        WSDLPort port = endpoint.getPort();
        if (port != null) {
            this.addressMap.put(port.getName().getLocalPart(), this.getValidPath(urlPattern));
        }
        return tcpAdapter;
    }

    private String getValidPath(@NotNull String urlPattern) {
        if (urlPattern.endsWith("/*")) {
            return urlPattern.substring(0, urlPattern.length() - 2);
        }
        return urlPattern;
    }

    protected PortAddressResolver createPortAddressResolver(final String baseAddress) {
        return new PortAddressResolver(){

            public String getAddressFor(QName serviceName, @NotNull String portName) {
                String urlPattern = (String)TCPAdapterList.this.addressMap.get(portName);
                return urlPattern == null ? null : baseAddress + urlPattern;
            }
        };
    }

    @Override
    public TCPAdapter get(int index) {
        return this.adapters.get(index);
    }

    @Override
    public int size() {
        return this.adapters.size();
    }
}

