/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter;

import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.Invocation;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.InvocationProcessingException;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.InvocationProcessor;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.FilteringStateMachine;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.InvocationTransformer;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class FilteringInvocationProcessor
implements InvocationProcessor {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(FilteringInvocationProcessor.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter originalWriter;
    private final XMLStreamWriter mirrorWriter;
    private final LinkedList<InvocationBuffer> invocationBuffers;
    private final StateMachineContext[] stateMachineContexts;
    private final List<StateMachineContext> startBufferingCandidates;
    private final List<StateMachineContext> stopBufferingCandidates;
    private final List<StateMachineContext> startFilteringCandidates;
    private final InvocationTransformer invocationTransformer;
    private int filteringCount;
    private boolean filtering;

    public FilteringInvocationProcessor(XMLStreamWriter writer, FilteringStateMachine ... stateMachines) throws XMLStreamException {
        this(writer, (InvocationTransformer)null, stateMachines);
    }

    public FilteringInvocationProcessor(XMLStreamWriter writer, InvocationTransformer transformer, FilteringStateMachine ... stateMachines) throws XMLStreamException {
        this.originalWriter = writer;
        this.stateMachineContexts = new StateMachineContext[stateMachines.length];
        for (int i = 0; i < stateMachines.length; ++i) {
            this.stateMachineContexts[i] = new StateMachineContext(stateMachines[i]);
        }
        this.mirrorWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(new StringWriter());
        this.invocationBuffers = new LinkedList();
        this.startBufferingCandidates = new LinkedList<StateMachineContext>();
        this.stopBufferingCandidates = new LinkedList<StateMachineContext>();
        this.startFilteringCandidates = new LinkedList<StateMachineContext>();
        this.invocationTransformer = transformer;
    }

    public Object process(Invocation invocation) throws InvocationProcessingException {
        if (invocation.getMethodType().isFilterable()) {
            if (this.invocationTransformer != null) {
                Collection<Invocation> transformedInvocations = this.invocationTransformer.transform(invocation);
                Object returnValue = null;
                for (Invocation transformedInvocation : transformedInvocations) {
                    if (transformedInvocation == invocation) {
                        returnValue = this.filter(transformedInvocation);
                        continue;
                    }
                    this.filter(transformedInvocation);
                }
                return returnValue;
            }
            return this.filter(invocation);
        }
        switch (invocation.getMethodType()) {
            case FLUSH: {
                invocation.execute(this.originalWriter);
                return invocation.execute(this.mirrorWriter);
            }
            case CLOSE: {
                this.executeAllBufferedInvocations(this.originalWriter);
                invocation.execute(this.originalWriter);
                return invocation.execute(this.mirrorWriter);
            }
        }
        return invocation.execute(this.mirrorWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object filter(Invocation invocation) throws InvocationProcessingException {
        LOGGER.entering(invocation);
        try {
            XMLStreamWriter invocationTarget;
            this.resolveStateChangeCandidates(invocation);
            this.processStartFilteringCandidates();
            this.processStopBufferingCandidates();
            this.processStartBufferingCandidates();
            this.updateFilteringStatus();
            if (this.filtering) {
                this.filtering = this.filteringCount > 0;
                invocationTarget = this.mirrorWriter;
            } else if (this.invocationBuffers.isEmpty()) {
                invocation.execute(this.mirrorWriter);
                invocationTarget = this.originalWriter;
            } else {
                this.invocationBuffers.getLast().getQueue().offer(invocation);
                invocationTarget = this.mirrorWriter;
            }
            Object object = invocation.execute(invocationTarget);
            return object;
        }
        finally {
            LOGGER.exiting();
        }
    }

    private void processStartBufferingCandidates() {
        if (this.filteringCount == 0 && this.startBufferingCandidates.size() > 0) {
            InvocationBuffer buffer = new InvocationBuffer(this.startBufferingCandidates.size());
            this.invocationBuffers.addLast(buffer);
            for (StateMachineContext context : this.startBufferingCandidates) {
                context.setBuffer(buffer);
            }
        }
    }

    private void processStartFilteringCandidates() {
        int firstFilteredBufferIndex = this.invocationBuffers.size();
        for (StateMachineContext context : this.startFilteringCandidates) {
            InvocationBuffer buffer = context.getBuffer();
            context.setBuffer(null);
            int currentBufferIndex = this.invocationBuffers.indexOf(buffer);
            if (currentBufferIndex >= firstFilteredBufferIndex) continue;
            firstFilteredBufferIndex = currentBufferIndex;
        }
        while (this.invocationBuffers.size() > firstFilteredBufferIndex) {
            InvocationBuffer filteredBuffer = this.invocationBuffers.removeLast();
            filteredBuffer.clear();
        }
    }

    private void processStopBufferingCandidates() throws InvocationProcessingException {
        for (StateMachineContext context : this.stopBufferingCandidates) {
            int bufferIndex;
            InvocationBuffer buffer = context.getBuffer();
            context.setBuffer(null);
            if (buffer == null || buffer.removeReference() != 0 || (bufferIndex = this.invocationBuffers.indexOf(buffer)) == -1) continue;
            this.invocationBuffers.remove(bufferIndex);
            if (bufferIndex == 0) {
                Invocation.executeBatch(this.originalWriter, buffer.getQueue());
                continue;
            }
            this.invocationBuffers.get(bufferIndex - 1).getQueue().addAll(buffer.getQueue());
        }
    }

    private void resolveStateChangeCandidates(Invocation invocation) {
        this.startBufferingCandidates.clear();
        this.stopBufferingCandidates.clear();
        this.startFilteringCandidates.clear();
        block7: for (StateMachineContext context : this.stateMachineContexts) {
            switch (context.getStateMachine().getStateChange(invocation, this.mirrorWriter)) {
                case START_BUFFERING: {
                    this.startBufferingCandidates.add(context);
                    continue block7;
                }
                case RESTART_BUFFERING: {
                    this.startBufferingCandidates.add(context);
                    if (context.getBuffer() == null) continue block7;
                    this.stopBufferingCandidates.add(context);
                    continue block7;
                }
                case STOP_BUFFERING: {
                    if (context.getBuffer() == null) continue block7;
                    this.stopBufferingCandidates.add(context);
                    continue block7;
                }
                case START_FILTERING: {
                    if (context.getBuffer() != null) {
                        this.startFilteringCandidates.add(context);
                    }
                    ++this.filteringCount;
                    continue block7;
                }
                case STOP_FILTERING: {
                    --this.filteringCount;
                    continue block7;
                }
            }
        }
    }

    private void updateFilteringStatus() {
        if (!this.filtering) {
            this.filtering = this.filteringCount > 0;
        }
    }

    private void executeAllBufferedInvocations(XMLStreamWriter target) {
        while (!this.invocationBuffers.isEmpty()) {
            InvocationBuffer buffer = this.invocationBuffers.removeFirst();
            Invocation.executeBatch(target, buffer.getQueue());
            buffer.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InvocationBuffer {
        private final Queue<Invocation> queue = new LinkedList<Invocation>();
        private int referenceCount;

        InvocationBuffer(int refCount) {
            this.referenceCount = refCount;
        }

        public Queue<Invocation> getQueue() {
            return this.queue;
        }

        public int removeReference() {
            if (this.referenceCount > 0) {
                --this.referenceCount;
            }
            return this.referenceCount;
        }

        public void clear() {
            this.queue.clear();
            this.referenceCount = 0;
        }
    }

    private static final class StateMachineContext {
        private final FilteringStateMachine stateMachine;
        private WeakReference<InvocationBuffer> bufferRef;

        StateMachineContext(FilteringStateMachine stateMachine) {
            this.stateMachine = stateMachine;
            this.bufferRef = null;
        }

        public FilteringStateMachine getStateMachine() {
            return this.stateMachine;
        }

        public InvocationBuffer getBuffer() {
            return this.bufferRef == null ? null : (InvocationBuffer)this.bufferRef.get();
        }

        public void setBuffer(InvocationBuffer buffer) {
            this.bufferRef = new WeakReference<InvocationBuffer>(buffer);
        }
    }
}

