/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class NamedThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean createDeamenoThreads;

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, true);
    }

    public NamedThreadFactory(String namePrefix, boolean createDaemonThreads) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix + "-thread-";
        this.createDeamenoThreads = createDaemonThreads;
    }

    public Thread newThread(Runnable task) {
        Thread newThread = new Thread(this.group, task, this.namePrefix + this.threadNumber.getAndIncrement());
        if (newThread.getPriority() != 5) {
            newThread.setPriority(5);
        }
        if (this.createDeamenoThreads && !newThread.isDaemon()) {
            newThread.setDaemon(true);
        }
        return newThread;
    }
}

