/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.encoding.TagInfoset;
import com.sun.xml.ws.message.AbstractMessageImpl;
import com.sun.xml.ws.message.stream.StreamMessage;
import com.sun.xml.ws.protocol.soap.VersionMismatchException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.TokenValidator;
import com.sun.xml.ws.security.opt.crypto.dsig.Reference;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.attachment.AttachmentImpl;
import com.sun.xml.ws.security.opt.impl.attachment.AttachmentSetImpl;
import com.sun.xml.ws.security.opt.impl.incoming.DerivedKeyToken;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedContentHeaderParser;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedData;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedHeader;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import com.sun.xml.ws.security.opt.impl.incoming.KerberosBinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.incoming.ReferenceListHeader;
import com.sun.xml.ws.security.opt.impl.incoming.SAMLAssertion;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken;
import com.sun.xml.ws.security.opt.impl.incoming.Signature;
import com.sun.xml.ws.security.opt.impl.incoming.SignatureConfirmation;
import com.sun.xml.ws.security.opt.impl.incoming.TargetResolverImpl;
import com.sun.xml.ws.security.opt.impl.incoming.TimestampHeader;
import com.sun.xml.ws.security.opt.impl.incoming.UsernameTokenHeader;
import com.sun.xml.ws.security.opt.impl.incoming.VerifiedStreamMessage;
import com.sun.xml.ws.security.opt.impl.incoming.X509BinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.incoming.processor.SecurityHeaderProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.SecurityTokenProcessor;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.ws.security.opt.impl.util.VerifiedMessageXMLStreamReader;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.wss.BasicSecurityProfile;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyResolver;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.verifier.MessagePolicyVerifier;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityRecipient {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt", "com.sun.xml.wss.logging.impl.opt.LogStrings");
    private static final int TIMESTAMP_ELEMENT = 1;
    private static final int USERNAME_TOKEN_ELEMENT = 2;
    private static final int BINARYSECURITY_TOKEN_ELEMENT = 3;
    private static final int ENCRYPTED_DATA_ELEMENT = 4;
    private static final int ENCRYPTED_KEY_ELEMENT = 5;
    private static final int SIGNATURE_ELEMENT = 6;
    private static final int REFERENCE_LIST_ELEMENT = 7;
    private static final int DERIVED_KEY_ELEMENT = 8;
    private static final int SIGNATURE_CONFIRMATION_ELEMENT = 9;
    private static final int SECURITY_CONTEXT_TOKEN = 10;
    private static final int SAML_ASSERTION_ELEMENT = 11;
    private static final int ENCRYPTED_HEADER_ELEMENT = 12;
    private static final int STR_ELEMENT = 13;
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private final String SOAP_NAMESPACE_URI;
    private final SOAPVersion soapVersion;
    private XMLStreamReader message = null;
    private StreamReaderBufferCreator creator = null;
    private HashMap<String, String> parentNS = new HashMap();
    private HashMap<String, String> securityHeaderNS = new HashMap();
    private HashMap<String, String> bodyENVNS = new HashMap();
    private HashMap<String, String> envshNS = null;
    private XMLInputFactory staxIF = null;
    private JAXBFilterProcessingContext context = null;
    private HeaderList headers = null;
    private TagInfoset headerTag = null;
    private HashMap<String, String> parentNSOnEnvelope = new HashMap();
    private TagInfoset envelopeTag = null;
    private ArrayList processedHeaders = new ArrayList(2);
    private SecurityHeaderElement pendingElement = null;
    private ArrayList bufferedHeaders = new ArrayList();
    private SecurityContext securityContext = null;
    private TagInfoset bodyTag = null;
    private String bodyWsuId = "";
    private String payLoadWsuId = "";
    private String payLoadEncId = "";
    private HashMap<String, String> encIds = new HashMap();
    private HashMap<String, QName> encQNames = new HashMap();
    private HashMap<String, String> edAlgos = new HashMap();
    private BasicSecurityProfile bspContext = new BasicSecurityProfile();

    public SecurityRecipient(XMLStreamReader reader, SOAPVersion soapVersion) {
        this.message = reader;
        this.soapVersion = soapVersion;
        this.SOAP_NAMESPACE_URI = soapVersion.nsUri;
        this.securityContext = new SecurityContext();
    }

    public SecurityRecipient(XMLStreamReader reader, SOAPVersion soapVersion, AttachmentSet attachSet) {
        this(reader, soapVersion);
        this.securityContext.setAttachmentSet(attachSet);
    }

    public Message validateMessage(JAXBFilterProcessingContext ctx) throws XWSSecurityException {
        try {
            int i;
            this.context = ctx;
            this.context.setSecurityContext(this.securityContext);
            this.context.setExtraneousProperty("EnableWSS11PolicyReceiver", "true");
            ArrayList scList = new ArrayList();
            this.context.setExtraneousProperty("receivedSignValues", scList);
            if (this.message.getEventType() != 1) {
                XMLStreamReaderUtil.nextElementContent(this.message);
            }
            XMLStreamReaderUtil.verifyReaderState(this.message, 1);
            if (SOAP_ENVELOPE.equals(this.message.getLocalName()) && !this.SOAP_NAMESPACE_URI.equals(this.message.getNamespaceURI())) {
                throw new VersionMismatchException(this.soapVersion, this.SOAP_NAMESPACE_URI, this.message.getNamespaceURI());
            }
            XMLStreamReaderUtil.verifyTag(this.message, this.SOAP_NAMESPACE_URI, SOAP_ENVELOPE);
            this.envelopeTag = new TagInfoset(this.message);
            for (i = 0; i < this.message.getNamespaceCount(); ++i) {
                this.parentNS.put(this.message.getNamespacePrefix(i), this.message.getNamespaceURI(i));
                this.parentNSOnEnvelope.put(this.message.getNamespacePrefix(i), this.message.getNamespaceURI(i));
            }
            XMLStreamReaderUtil.nextElementContent(this.message);
            XMLStreamReaderUtil.verifyReaderState(this.message, 1);
            if (this.message.getLocalName().equals(SOAP_HEADER) && this.message.getNamespaceURI().equals(this.SOAP_NAMESPACE_URI)) {
                this.headerTag = new TagInfoset(this.message);
                for (i = 0; i < this.message.getNamespaceCount(); ++i) {
                    this.parentNS.put(this.message.getNamespacePrefix(i), this.message.getNamespaceURI(i));
                }
                XMLStreamReaderUtil.nextElementContent(this.message);
                if (this.message.getEventType() == 1) {
                    this.headers = new HeaderList();
                    this.cacheHeaders(this.message, this.parentNS);
                }
                XMLStreamReaderUtil.nextElementContent(this.message);
            }
            return this.createMessage();
        }
        catch (WssSoapFaultException ex) {
            StreamMessage msg = new StreamMessage(this.envelopeTag, this.headerTag, new AttachmentSetImpl(), this.headers, this.bodyTag, this.getEmptyBodyNoException(), this.soapVersion);
            ctx.setPVMessage(msg);
            throw ex;
        }
        catch (WebServiceException te) {
            StreamMessage msg = new StreamMessage(this.envelopeTag, this.headerTag, new AttachmentSetImpl(), this.headers, this.bodyTag, this.getEmptyBodyNoException(), this.soapVersion);
            ctx.setPVMessage(msg);
            throw te;
        }
        catch (XMLStreamException e) {
            StreamMessage msg = new StreamMessage(this.envelopeTag, this.headerTag, new AttachmentSetImpl(), this.headers, this.bodyTag, this.getEmptyBodyNoException(), this.soapVersion);
            ctx.setPVMessage(msg);
            throw new WebServiceException((Throwable)e);
        }
        catch (XWSSecurityException xe) {
            StreamMessage msg = new StreamMessage(this.envelopeTag, this.headerTag, new AttachmentSetImpl(), this.headers, this.bodyTag, this.getEmptyBodyNoException(), this.soapVersion);
            ctx.setPVMessage(msg);
            throw xe;
        }
        catch (XWSSecurityRuntimeException re) {
            StreamMessage msg = new StreamMessage(this.envelopeTag, this.headerTag, new AttachmentSetImpl(), this.headers, this.bodyTag, this.getEmptyBodyNoException(), this.soapVersion);
            ctx.setPVMessage(msg);
            throw re;
        }
        catch (Exception e) {
            StreamMessage msg = new StreamMessage(this.envelopeTag, this.headerTag, new AttachmentSetImpl(), this.headers, this.bodyTag, this.getEmptyBodyNoException(), this.soapVersion);
            ctx.setPVMessage(msg);
            throw new XWSSecurityRuntimeException(e);
        }
    }

    private void cacheHeaders(XMLStreamReader reader, Map<String, String> namespaces) throws XMLStreamException, XWSSecurityException {
        this.creator = new StreamReaderBufferCreator();
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        this.creator.setXMLStreamBuffer(buffer);
        while (reader.getEventType() == 1) {
            XMLStreamBufferMark mark;
            Map<String, String> headerBlockNamespaces = namespaces;
            if (reader.getLocalName() == "Security" && reader.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                if (reader.getNamespaceCount() > 0) {
                    headerBlockNamespaces = new HashMap<String, String>(namespaces);
                    for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                        headerBlockNamespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    }
                }
                mark = new XMLStreamBufferMark(headerBlockNamespaces, this.creator);
                this.handleSecurityHeader();
            } else {
                try {
                    if (reader.getNamespaceCount() > 0) {
                        headerBlockNamespaces = new HashMap<String, String>(namespaces);
                        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                            headerBlockNamespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                        }
                    }
                    mark = new XMLStreamBufferMark(headerBlockNamespaces, this.creator);
                    GenericSecuredHeader gsh = new GenericSecuredHeader(reader, this.soapVersion, this.creator, (HashMap)namespaces, this.staxIF, this.context.getEncHeaderContent());
                    this.headers.add(gsh);
                }
                catch (XMLStreamBufferException ex) {
                    throw new XWSSecurityException("Error occurred while reading SOAP Header" + ex);
                }
            }
            while (reader.isWhiteSpace()) {
                reader.next();
            }
        }
    }

    private void handleSecurityHeader() throws XWSSecurityException {
        try {
            if (this.message.getEventType() == 1 && this.message.getLocalName() == "Security" && this.message.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                for (int i = 0; i < this.message.getNamespaceCount(); ++i) {
                    this.securityHeaderNS.put(this.message.getNamespacePrefix(i), this.message.getNamespaceURI(i));
                }
                StreamUtil.moveToNextStartOREndElement(this.message);
            }
            HashMap<String, String> currentParentNS = new HashMap<String, String>();
            currentParentNS.putAll(this.parentNS);
            currentParentNS.putAll(this.securityHeaderNS);
            this.envshNS = currentParentNS;
            int eventType = this.getSecurityElementType();
            this.securityContext.setSOAPEnvelopeNSDecls(this.parentNSOnEnvelope);
            this.securityContext.setSecurityHdrNSDecls(this.securityHeaderNS);
            this.securityContext.setNonSecurityHeaders(this.headers);
            this.securityContext.setProcessedSecurityHeaders(this.processedHeaders);
            this.securityContext.setBufferedSecurityHeaders(this.bufferedHeaders);
            this.context.setSecurityContext(this.securityContext);
            while (true) {
                if (this.message.getEventType() == 8) break;
                switch (eventType) {
                    case 1: {
                        if (this.context.isBSP() && this.bspContext.isTimeStampFound()) {
                            BasicSecurityProfile.log_bsp_3203();
                        }
                        this.bspContext.setTimeStampFound(true);
                        TimestampHeader timestamp = new TimestampHeader(this.message, this.creator, currentParentNS, this.context);
                        WSSPolicy policy = timestamp.getPolicy();
                        timestamp.validate(this.context);
                        this.processedHeaders.add(timestamp);
                        this.context.getInferredSecurityPolicy().append(timestamp.getPolicy());
                        break;
                    }
                    case 2: {
                        UsernameTokenHeader ut = new UsernameTokenHeader(this.message, this.creator, currentParentNS, this.staxIF);
                        ut.validate(this.context);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(ut);
                        this.context.getInferredSecurityPolicy().append(ut.getPolicy());
                        if (!this.context.isTrustMessage() || this.context.isClient()) break;
                        IssuedTokenContext ctx = null;
                        if (this.context.getTrustContext() == null) {
                            ctx = new IssuedTokenContextImpl();
                            if (this.context.isSecure()) {
                                ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
                            } else {
                                ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                            }
                            this.context.setTrustContext(ctx);
                            break;
                        }
                        ctx = this.context.getTrustContext();
                        if (ctx.getAuthnContextClass() == null) break;
                        if (this.context.isSecure()) {
                            ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
                        } else {
                            ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                        }
                        this.context.setTrustContext(ctx);
                        break;
                    }
                    case 3: {
                        IssuedTokenContext ctx;
                        WSSPolicy policy;
                        String valueType = this.message.getAttributeValue(null, "ValueType");
                        if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(valueType)) {
                            KerberosBinarySecurityToken kbst = new KerberosBinarySecurityToken(this.message, this.creator, currentParentNS, this.staxIF);
                            policy = kbst.getPolicy();
                            kbst.validate(this.context);
                            this.processedHeaders.add(kbst);
                            this.context.getInferredSecurityPolicy().append(kbst.getPolicy());
                            if (!this.context.isTrustMessage() || this.context.isClient()) break;
                            ctx = null;
                            if (this.context.getTrustContext() == null) {
                                ctx = new IssuedTokenContextImpl();
                                ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
                                this.context.setTrustContext(ctx);
                                break;
                            }
                            ctx = this.context.getTrustContext();
                            if (ctx.getAuthnContextClass() == null) break;
                            ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
                            this.context.setTrustContext(ctx);
                            break;
                        }
                        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType) && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(valueType) && valueType != null) break;
                        X509BinarySecurityToken bst = new X509BinarySecurityToken(this.message, this.creator, currentParentNS, this.staxIF);
                        policy = bst.getPolicy();
                        bst.validate(this.context);
                        this.processedHeaders.add(bst);
                        this.context.getInferredSecurityPolicy().append(bst.getPolicy());
                        if (!this.context.isTrustMessage() || this.context.isClient()) break;
                        ctx = null;
                        if (this.context.getTrustContext() == null) {
                            ctx = new IssuedTokenContextImpl();
                            ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
                            this.context.setTrustContext(ctx);
                            break;
                        }
                        ctx = this.context.getTrustContext();
                        if (ctx.getAuthnContextClass() == null) break;
                        ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
                        this.context.setTrustContext(ctx);
                        break;
                    }
                    case 5: {
                        EncryptedKey ek = new EncryptedKey(this.message, this.context, currentParentNS);
                        ArrayList list = (ArrayList)ek.getPendingReferenceList();
                        if (list != null) {
                            this.findAndReplaceED(list, ek);
                            if (ek.getPendingReferenceList().size() > 0) {
                                if (this.pendingElement == null) {
                                    this.pendingElement = ek;
                                }
                                this.addSecurityHeader(ek);
                            }
                        } else {
                            this.addSecurityHeader(ek);
                        }
                        if (ek.getPolicy() == null) break;
                        this.context.getInferredSecurityPolicy().append(ek.getPolicy());
                        break;
                    }
                    case 4: {
                        EncryptedData ed = new EncryptedData(this.message, this.context, currentParentNS);
                        this.handleEncryptedData(ed, currentParentNS);
                        break;
                    }
                    case 12: {
                        throw new XWSSecurityException("wsse11:EncryptedHeader not allowed inside SecurityHeader");
                    }
                    case 7: {
                        ReferenceListHeader refList = new ReferenceListHeader(this.message, this.context);
                        if (this.pendingElement == null) {
                            this.pendingElement = refList;
                        } else {
                            this.addSecurityHeader(refList);
                        }
                        this.context.getInferredSecurityPolicy().append(refList.getPolicy());
                        break;
                    }
                    case 6: {
                        Signature sig = new Signature(this.context, currentParentNS, this.creator);
                        sig.process(this.message);
                        if (!sig.isValidated()) {
                            if (this.pendingElement == null) {
                                this.pendingElement = sig;
                            } else {
                                this.addSecurityHeader(sig);
                            }
                        }
                        this.context.getInferredSecurityPolicy().append(sig.getPolicy());
                        break;
                    }
                    case 8: {
                        DerivedKeyToken dkt = new DerivedKeyToken(this.message, this.context, currentParentNS);
                        this.processedHeaders.add(dkt);
                        break;
                    }
                    case 9: {
                        SignatureConfirmation signConfirm = new SignatureConfirmation(this.message, this.creator, currentParentNS, this.staxIF);
                        WSSPolicy policy = signConfirm.getPolicy();
                        signConfirm.validate(this.context);
                        this.processedHeaders.add(signConfirm);
                        this.context.getInferredSecurityPolicy().append(signConfirm.getPolicy());
                        break;
                    }
                    case 10: {
                        SecurityContextToken sct = new SecurityContextToken(this.message, this.context, currentParentNS);
                        this.processedHeaders.add(sct);
                        break;
                    }
                    case 11: {
                        IssuedTokenContext ctx;
                        SAMLAssertion samlAssertion = new SAMLAssertion(this.message, this.context, null, currentParentNS);
                        this.processedHeaders.add(samlAssertion);
                        if (samlAssertion.isHOK() && !samlAssertion.validateSignature()) {
                            logger.log(Level.SEVERE, LogStringsMessages.WSS_1614_SAML_SIGNATURE_INVALID());
                            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, LogStringsMessages.WSS_1614_SAML_SIGNATURE_INVALID(), new Exception(LogStringsMessages.WSS_1614_SAML_SIGNATURE_INVALID()));
                        }
                        samlAssertion.validate(this.context);
                        samlAssertion.getKey();
                        if (this.context.getExtraneousProperty("incoming_saml_assertion") == null && samlAssertion.isHOK()) {
                            this.context.getExtraneousProperties().put("incoming_saml_assertion", samlAssertion);
                        }
                        if (this.context.isTrustMessage() && !this.context.isClient()) {
                            ctx = null;
                            if (this.context.getTrustContext() == null) {
                                ctx = new IssuedTokenContextImpl();
                                ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                                this.context.setTrustContext(ctx);
                                break;
                            }
                            ctx = this.context.getTrustContext();
                            if (ctx.getAuthnContextClass() == null) break;
                            ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                            this.context.setTrustContext(ctx);
                            break;
                        }
                        if (this.context.isTrustMessage()) break;
                        this.context.getInferredSecurityPolicy().append(samlAssertion.getPolicy());
                        break;
                    }
                    case 13: {
                        SecurityTokenProcessor str = new SecurityTokenProcessor(this.context, null);
                        str.resolveReference(this.message);
                        break;
                    }
                    default: {
                        if (this.message.getEventType() != 1 || this.getSecurityElementType() != -1) break;
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1613_UNRECOGNIZED_SECURITY_ELEMENT(this.message.getLocalName()));
                        throw new XWSSecurityException(LogStringsMessages.WSS_1613_UNRECOGNIZED_SECURITY_ELEMENT(this.message.getLocalName()));
                    }
                }
                if (StreamUtil._break(this.message, "Security", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) break;
                eventType = this.getSecurityElementType();
                if (eventType != -1 || StreamUtil.isStartElement(this.message)) continue;
                if (StreamUtil._break(this.message, "Security", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) break;
                this.message.next();
            }
            this.message.next();
        }
        catch (XMLStreamException ex) {
            logger.log(Level.FINE, "Error occurred while reading SOAP Headers", ex);
            throw new XWSSecurityException(ex);
        }
        catch (XMLStreamBufferException ex) {
            logger.log(Level.FINE, "Error occurred while reading SOAP Headers", ex);
            throw new XWSSecurityException(ex);
        }
    }

    private void handleEncryptedData(EncryptedData ed, HashMap<String, String> currentParentNS) throws XMLStreamException, XWSSecurityException {
        if (this.pendingElement != null && this.pendingElement instanceof EncryptedKey) {
            EncryptedKey ek = (EncryptedKey)this.pendingElement;
            if (ek.getPendingReferenceList() != null && ek.getPendingReferenceList().contains(ed.getId())) {
                if (ek.getPolicy() != null) {
                    ek.getPolicy().setKeyBinding(ek.getInferredKB());
                }
                if (!ed.hasCipherReference()) {
                    XMLStreamReader decryptedData = ed.getDecryptedData(ek.getKey(ed.getEncryptionAlgorithm()));
                    SecurityHeaderProcessor shp = new SecurityHeaderProcessor(this.context, currentParentNS, this.staxIF, this.creator);
                    if (decryptedData.getEventType() != 1) {
                        StreamUtil.moveToNextElement(decryptedData);
                    }
                    SecurityHeaderElement she = shp.createHeader(decryptedData);
                    this.encIds.put(ed.getId(), she.getId());
                    this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
                    ek.getPendingReferenceList().remove(ed.getId());
                    if (ek.getPendingReferenceList().size() == 0) {
                        this.pendingElement = null;
                        this.bufferedHeaders.remove(ek);
                        this.addSecurityHeader(ek);
                    }
                    this.checkDecryptedData(she, ek.getPolicy());
                } else {
                    byte[] decryptedMimeData = ed.getDecryptedMimeData(ek.getKey(ed.getEncryptionAlgorithm()));
                    AttachmentImpl as = new AttachmentImpl(ed.getAttachmentContentId(), decryptedMimeData, ed.getAttachmentMimeType());
                    this.securityContext.getDecryptedAttachmentSet().add(as);
                    ek.getPendingReferenceList().remove(ed.getId());
                    if (ek.getPendingReferenceList().size() == 0) {
                        this.pendingElement = null;
                        this.bufferedHeaders.remove(ek);
                        this.addSecurityHeader(ek);
                    }
                }
            } else if (!this.lookInBufferedHeaders(ed, currentParentNS)) {
                this.addSecurityHeader(ed);
            }
        } else if (this.pendingElement != null && this.pendingElement instanceof ReferenceListHeader) {
            ReferenceListHeader refList = (ReferenceListHeader)this.pendingElement;
            if (refList.getPendingReferenceList().contains(ed.getId())) {
                refList.getPolicy().setKeyBinding(ed.getInferredKB());
                if (!ed.hasCipherReference()) {
                    XMLStreamReader decryptedData = ed.getDecryptedData();
                    if (decryptedData.getEventType() != 1) {
                        StreamUtil.moveToNextElement(decryptedData);
                    }
                    SecurityHeaderProcessor shp = new SecurityHeaderProcessor(this.context, currentParentNS, this.staxIF, this.creator);
                    SecurityHeaderElement she = shp.createHeader(decryptedData);
                    this.encIds.put(ed.getId(), she.getId());
                    this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
                    refList.getPendingReferenceList().remove(ed.getId());
                    if (refList.getPendingReferenceList().size() == 0) {
                        this.pendingElement = null;
                    }
                    this.checkDecryptedData(she, refList.getPolicy());
                } else {
                    byte[] decryptedMimeData = ed.getDecryptedMimeData();
                    AttachmentImpl as = new AttachmentImpl(ed.getAttachmentContentId(), decryptedMimeData, ed.getAttachmentMimeType());
                    this.securityContext.getDecryptedAttachmentSet().add(as);
                    refList.getPendingReferenceList().remove(ed.getId());
                    if (refList.getPendingReferenceList().size() == 0) {
                        this.pendingElement = null;
                    }
                }
            } else if (!this.lookInBufferedHeaders(ed, currentParentNS)) {
                this.decryptStandaloneED(ed, currentParentNS, refList.getPolicy());
            }
        } else if (!this.lookInBufferedHeaders(ed, currentParentNS)) {
            this.decryptStandaloneED(ed, currentParentNS, null);
        }
    }

    private boolean lookInBufferedHeaders(EncryptedData ed, HashMap<String, String> currentParentNS) throws XWSSecurityException, XMLStreamException {
        if (this.bufferedHeaders.size() > 0) {
            for (int i = 0; i < this.bufferedHeaders.size(); ++i) {
                ReferenceListHeader refList;
                SecurityHeaderElement bufShe = (SecurityHeaderElement)this.bufferedHeaders.get(i);
                if (bufShe.getLocalPart() == "EncryptedKey" && bufShe.getNamespaceURI() == "http://www.w3.org/2001/04/xmlenc#") {
                    EncryptedKey ek = (EncryptedKey)bufShe;
                    if (ek.getPendingReferenceList() == null || !ek.getPendingReferenceList().contains(ed.getId())) continue;
                    if (ek.getPolicy() != null) {
                        ek.getPolicy().setKeyBinding(ek.getInferredKB());
                    }
                    if (!ed.hasCipherReference()) {
                        XMLStreamReader decryptedData = ed.getDecryptedData(ek.getKey(ed.getEncryptionAlgorithm()));
                        SecurityHeaderProcessor shp = new SecurityHeaderProcessor(this.context, currentParentNS, this.staxIF, this.creator);
                        if (decryptedData.getEventType() != 1) {
                            StreamUtil.moveToNextElement(decryptedData);
                        }
                        SecurityHeaderElement she = shp.createHeader(decryptedData);
                        this.encIds.put(ed.getId(), she.getId());
                        this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
                        ek.getPendingReferenceList().remove(ed.getId());
                        this.checkDecryptedData(she, ek.getPolicy());
                    } else {
                        byte[] decryptedMimeData = ed.getDecryptedMimeData(ek.getKey(ed.getEncryptionAlgorithm()));
                        AttachmentImpl as = new AttachmentImpl(ed.getAttachmentContentId(), decryptedMimeData, ed.getAttachmentMimeType());
                        this.securityContext.getDecryptedAttachmentSet().add(as);
                        ek.getPendingReferenceList().remove(ed.getId());
                    }
                    return true;
                }
                if (bufShe.getLocalPart() != "ReferenceList" || bufShe.getNamespaceURI() != "http://www.w3.org/2001/04/xmlenc#" || !(refList = (ReferenceListHeader)bufShe).getPendingReferenceList().contains(ed.getId())) continue;
                refList.getPolicy().setKeyBinding(ed.getInferredKB());
                if (!ed.hasCipherReference()) {
                    XMLStreamReader decryptedData = ed.getDecryptedData();
                    if (decryptedData.getEventType() != 1) {
                        StreamUtil.moveToNextElement(decryptedData);
                    }
                    SecurityHeaderProcessor shp = new SecurityHeaderProcessor(this.context, currentParentNS, this.staxIF, this.creator);
                    SecurityHeaderElement she = shp.createHeader(decryptedData);
                    this.encIds.put(ed.getId(), she.getId());
                    this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
                    refList.getPendingReferenceList().remove(ed.getId());
                    this.checkDecryptedData(she, refList.getPolicy());
                } else {
                    byte[] decryptedMimeData = ed.getDecryptedMimeData();
                    AttachmentImpl as = new AttachmentImpl(ed.getAttachmentContentId(), decryptedMimeData, ed.getAttachmentMimeType());
                    this.securityContext.getDecryptedAttachmentSet().add(as);
                    refList.getPendingReferenceList().remove(ed.getId());
                }
                return true;
            }
        }
        return false;
    }

    private void decryptStandaloneED(EncryptedData ed, HashMap<String, String> currentParentNS, WSSPolicy policy) throws XMLStreamException, XWSSecurityException {
        if (ed.getKey() == null) {
            this.bufferedHeaders.add(ed);
            return;
        }
        if (!ed.hasCipherReference()) {
            XMLStreamReader decryptedData = ed.getDecryptedData();
            if (decryptedData.getEventType() != 1) {
                StreamUtil.moveToNextElement(decryptedData);
            }
            SecurityHeaderProcessor shp = new SecurityHeaderProcessor(this.context, currentParentNS, this.staxIF, this.creator);
            SecurityHeaderElement she = shp.createHeader(decryptedData);
            this.encIds.put(ed.getId(), she.getId());
            this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
            this.checkDecryptedData(she, policy);
            if (!this.handleSAMLAssertion(she)) {
                this.addSecurityHeader(she);
            }
        } else {
            byte[] decryptedMimeData = ed.getDecryptedMimeData();
            AttachmentImpl as = new AttachmentImpl(ed.getAttachmentContentId(), decryptedMimeData, ed.getAttachmentMimeType());
            this.securityContext.getDecryptedAttachmentSet().add(as);
        }
    }

    private void checkDecryptedData(SecurityHeaderElement she, WSSPolicy pol) throws XWSSecurityException {
        if (she.getLocalPart() == "Signature") {
            Signature sig;
            if (PolicyTypeUtil.encryptionPolicy(pol)) {
                EncryptionPolicy ep = (EncryptionPolicy)pol;
                EncryptionPolicy.FeatureBinding fb = (EncryptionPolicy.FeatureBinding)ep.getFeatureBinding();
                fb.encryptsSignature(true);
            }
            if ((sig = (Signature)she).getReferences().size() != 0 && this.isPending()) {
                if (this.pendingElement == null) {
                    this.pendingElement = she;
                } else {
                    this.bufferedHeaders.add(sig);
                }
            }
        }
    }

    private Message createMessage() throws XWSSecurityException {
        SecurityHeaderElement she;
        ArrayList clonedBufferedHeaders;
        block44: {
            XMLStreamReaderUtil.verifyTag(this.message, this.SOAP_NAMESPACE_URI, SOAP_BODY);
            this.bodyTag = new TagInfoset(this.message);
            this.bodyENVNS.putAll(this.parentNSOnEnvelope);
            for (int i = 0; i < this.message.getNamespaceCount(); ++i) {
                this.bodyENVNS.put(this.message.getNamespacePrefix(i), this.message.getNamespaceURI(i));
            }
            this.bodyWsuId = StreamUtil.getWsuId(this.message);
            if (this.bodyWsuId == null) {
                this.bodyWsuId = "";
            }
            XMLStreamReaderUtil.nextElementContent(this.message);
            this.cachePayLoadId();
            if (this.pendingElement != null) {
                try {
                    if (this.pendingElement instanceof EncryptedKey && StreamUtil.isStartElement(this.message) && this.isEncryptedData()) {
                        XMLStreamReader reader = this.message;
                        EncryptedData ed = new EncryptedData(this.message, this.context, this.bodyENVNS);
                        this.payLoadWsuId = ed.getId();
                        this.handlePayLoadED(ed);
                        this.payLoadEncId = ed.getId();
                        XMLStreamReaderUtil.close(reader);
                        XMLStreamReaderFactory.recycle(reader);
                        break block44;
                    }
                    if (this.pendingElement instanceof Signature) {
                        Signature sig = (Signature)this.pendingElement;
                        this.handleSignature(sig);
                        this.processedHeaders.add(this.pendingElement);
                        this.pendingElement = null;
                        break block44;
                    }
                    if (!(this.pendingElement instanceof ReferenceListHeader)) break block44;
                    ReferenceListHeader refList = (ReferenceListHeader)this.pendingElement;
                    if (refList.getPendingReferenceList().contains(this.payLoadWsuId)) {
                        XMLStreamReader reader = this.message;
                        EncryptedData ed = new EncryptedData(this.message, this.context, this.bodyENVNS);
                        refList.getPolicy().setKeyBinding(ed.getInferredKB());
                        this.payLoadWsuId = ed.getId();
                        this.handlePayLoadED(ed);
                        refList.getPendingReferenceList().remove(this.payLoadWsuId);
                        this.payLoadEncId = ed.getId();
                        this.cachePayLoadId();
                        XMLStreamReaderUtil.close(reader);
                        XMLStreamReaderFactory.recycle(reader);
                    }
                    if (refList.getPendingReferenceList().size() > 0) {
                        this.findAndReplaceED((ArrayList)refList.getPendingReferenceList(), refList);
                    }
                    if (refList.getPendingReferenceList().size() == 0) {
                        this.pendingElement = null;
                        break block44;
                    }
                    String uri = refList.getPendingReferenceList().get(0);
                    throw new XWSSecurityException("Reference with ID " + uri + " was not found in the message");
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException((Throwable)e);
                }
                catch (XWSSecurityException xse) {
                    throw new WebServiceException((Throwable)xse);
                }
            }
        }
        if ((clonedBufferedHeaders = (ArrayList)this.bufferedHeaders.clone()).size() > 0) {
            for (int i = 0; i < clonedBufferedHeaders.size(); ++i) {
                she = (SecurityHeaderElement)clonedBufferedHeaders.get(i);
                this.processSecurityHeader(she);
            }
        }
        if (this.processedHeaders.size() > 0) {
            for (int i = 0; i < this.processedHeaders.size(); ++i) {
                she = (SecurityHeaderElement)this.processedHeaders.get(i);
                this.processProcessedHeaders(she);
            }
        }
        try {
            if (this.message == null) {
                this.message = this.getEmptyBody();
            }
        }
        catch (XMLStreamException xse) {
            throw new XWSSecurityException(xse);
        }
        AbstractMessageImpl streamMsg = null;
        AttachmentSet as = this.securityContext.getDecryptedAttachmentSet();
        if (as == null || as.isEmpty()) {
            as = this.securityContext.getAttachmentSet();
        }
        if (!(this.context.getDisablePayloadBuffering() || this.context.isSecure() && !"Fault".equals(this.message.getLocalName()))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Buffering Payload from incomming message");
            }
            VerifiedMessageXMLStreamReader verifiedReader = new VerifiedMessageXMLStreamReader(this.message, this.bodyENVNS);
            streamMsg = new VerifiedStreamMessage(this.envelopeTag, this.headerTag, as, this.headers, this.bodyTag, verifiedReader, this.soapVersion, this.bodyENVNS);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Not Buffering Payload from incomming message");
            }
            streamMsg = new StreamMessage(this.envelopeTag, this.headerTag, as, this.headers, this.bodyTag, this.message, this.soapVersion);
        }
        this.context.setMessage(streamMsg);
        boolean scCancel = false;
        if (this.context.getAddressingVersion() != null) {
            String action = ((Message)streamMsg).getHeaders().getAction(this.context.getAddressingVersion(), this.context.getSOAPVersion());
            if ("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get".equals(action)) {
                return streamMsg;
            }
            if ("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel".equals(action) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel".equals(action)) {
                scCancel = true;
            }
        }
        MessagePolicy msgPolicy = (MessagePolicy)this.context.getSecurityPolicy();
        boolean isTrust = this.context.isTrustMessage();
        if (msgPolicy == null || msgPolicy.size() <= 0) {
            PolicyResolver opResolver = (PolicyResolver)this.context.getExtraneousProperty("OperationResolver");
            if (opResolver != null && !isTrust) {
                msgPolicy = opResolver.resolvePolicy(this.context);
            }
        }
        if (this.context.isSecure() && this.context.getInferredSecurityPolicy().size() == 0) {
            if (msgPolicy == null || msgPolicy.size() == 0 || this.context.isMissingTimestampAllowed()) {
                return streamMsg;
            }
            throw new XWSSecurityException("Security Requirements not met - No Security header in message");
        }
        try {
            MessagePolicy inferredMessagePolicy = this.context.getInferredSecurityPolicy();
            for (int i = 0; i < inferredMessagePolicy.size(); ++i) {
                ArrayList targets;
                WSSPolicy fb;
                WSSPolicy wssPolicy = (WSSPolicy)inferredMessagePolicy.get(i);
                if (PolicyTypeUtil.signaturePolicy(wssPolicy)) {
                    fb = (SignaturePolicy.FeatureBinding)wssPolicy.getFeatureBinding();
                    targets = ((SignaturePolicy.FeatureBinding)fb).getTargetBindings();
                    this.modifyTargets(targets);
                    continue;
                }
                if (!PolicyTypeUtil.encryptionPolicy(wssPolicy)) continue;
                fb = (EncryptionPolicy.FeatureBinding)wssPolicy.getFeatureBinding();
                targets = ((EncryptionPolicy.FeatureBinding)fb).getTargetBindings();
                this.modifyTargets(targets);
            }
        }
        catch (Exception ex) {
            throw new XWSSecurityException(ex);
        }
        if (scCancel) {
            boolean securedBody = false;
            boolean allHeaders = false;
            try {
                MessagePolicy mp = this.context.getInferredSecurityPolicy();
                for (int i = 0; i < mp.size(); ++i) {
                    int ei;
                    ArrayList list;
                    WSSPolicy wp = (WSSPolicy)mp.get(i);
                    if (PolicyTypeUtil.encryptionPolicy(wp)) {
                        EncryptionPolicy ep = (EncryptionPolicy)wp;
                        list = ((EncryptionPolicy.FeatureBinding)ep.getFeatureBinding()).getTargetBindings();
                        for (ei = 0; ei < list.size(); ++ei) {
                            EncryptionTarget et = (EncryptionTarget)list.get(ei);
                            if (!et.getValue().equals("{http://schemas.xmlsoap.org/soap/envelope/}Body")) continue;
                            securedBody = true;
                        }
                        continue;
                    }
                    if (!PolicyTypeUtil.signaturePolicy(wp)) continue;
                    SignaturePolicy sp = (SignaturePolicy)wp;
                    list = ((SignaturePolicy.FeatureBinding)sp.getFeatureBinding()).getTargetBindings();
                    for (ei = 0; ei < list.size(); ++ei) {
                        SignatureTarget st = (SignatureTarget)list.get(ei);
                        if (!st.getValue().equals("{http://schemas.xmlsoap.org/soap/envelope/}Body")) continue;
                        securedBody = true;
                    }
                    if (allHeaders) continue;
                    allHeaders = this.areHeadersSecured(sp);
                }
            }
            catch (Exception ex) {
                throw new XWSSecurityException(ex);
            }
            if (!(this.context.isSecure() || securedBody && allHeaders)) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1602_SCCANCEL_SECURITY_UNCONFIGURED());
                throw new XWSSecurityException("Security Requirements not met");
            }
            return streamMsg;
        }
        TargetResolverImpl targetResolver = new TargetResolverImpl(this.context);
        MessagePolicyVerifier mpv = new MessagePolicyVerifier(this.context, targetResolver);
        if (msgPolicy != null && msgPolicy.isSSL() && !this.context.isSecure()) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1601_SSL_NOT_ENABLED());
            throw new XWSSecurityException(LogStringsMessages.WSS_1601_SSL_NOT_ENABLED());
        }
        if (!isTrust) {
            mpv.verifyPolicy(this.context.getInferredSecurityPolicy(), msgPolicy);
        }
        return streamMsg;
    }

    private XMLStreamReader getEmptyBody() throws XMLStreamException {
        String emptyBody = "<S:Body xmlns:S=\"" + this.soapVersion.nsUri + "\"" + "></S:Body>";
        ByteArrayInputStream in = new ByteArrayInputStream(emptyBody.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader empBody = xif.createXMLStreamReader(in);
        empBody.next();
        empBody.next();
        return empBody;
    }

    private XMLStreamReader getEmptyBodyNoException() {
        try {
            return this.getEmptyBody();
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void modifyTargets(ArrayList targets) {
        for (int i = 0; i < targets.size(); ++i) {
            Target target = (Target)targets.get(i);
            if (target.getType() != "uri") continue;
            this.findAndReplaceTargets(target);
        }
    }

    private boolean handleSAMLAssertion(SecurityHeaderElement she) throws XWSSecurityException {
        if (she.getLocalPart() == "Assertion") {
            SAMLAssertion samlAssertion = (SAMLAssertion)she;
            this.processedHeaders.add(samlAssertion);
            if (samlAssertion.isHOK()) {
                samlAssertion.validateSignature();
            }
            samlAssertion.validate(this.context);
            samlAssertion.getKey();
            this.context.getExtraneousProperties().put("incoming_saml_assertion", samlAssertion);
            if (this.context.isTrustMessage() && !this.context.isClient()) {
                IssuedTokenContext ctx = null;
                if (this.context.getTrustContext() == null) {
                    ctx = new IssuedTokenContextImpl();
                    ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                    this.context.setTrustContext(ctx);
                } else {
                    ctx = this.context.getTrustContext();
                    if (ctx.getAuthnContextClass() != null) {
                        ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                        this.context.setTrustContext(ctx);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void findAndReplaceTargets(Target target) {
        int j;
        Object header;
        String uri = target.getValue();
        int index = uri.indexOf("#");
        QName qname = null;
        if (index >= 0) {
            uri = uri.substring(index + 1);
        }
        if (target instanceof EncryptionTarget) {
            String temp = this.encIds.get(uri);
            String edAlgo = this.edAlgos.get(uri);
            ((EncryptionTarget)target).setDataEncryptionAlgorithm(edAlgo);
            if (temp != null) {
                uri = temp;
            } else {
                qname = this.encQNames.get(uri);
            }
        }
        if (uri.equals(this.bodyWsuId)) {
            target.setType("qname");
            target.setValue("SOAP-BODY");
            target.setContentOnly(false);
            return;
        }
        if (uri.equals(this.payLoadWsuId) || uri.equals(this.payLoadEncId)) {
            target.setType("qname");
            target.setValue("SOAP-BODY");
            target.setContentOnly(true);
            return;
        }
        if (this.headers != null && this.headers.size() > 0) {
            ListIterator listItr = this.headers.listIterator();
            while (listItr.hasNext()) {
                header = (GenericSecuredHeader)listItr.next();
                if (((GenericSecuredHeader)header).hasID(uri)) {
                    qname = new QName(((GenericSecuredHeader)header).getNamespaceURI(), ((GenericSecuredHeader)header).getLocalPart());
                    target.setQName(qname);
                    target.setContentOnly(false);
                    return;
                }
                if (qname == null) continue;
                target.setQName(qname);
                target.setContentOnly(false);
                return;
            }
        }
        for (j = 0; j < this.processedHeaders.size(); ++j) {
            header = (SecurityHeaderElement)this.processedHeaders.get(j);
            if (!uri.equals(header.getId())) continue;
            qname = new QName(header.getNamespaceURI(), header.getLocalPart());
            target.setQName(qname);
            target.setContentOnly(false);
            return;
        }
        for (j = 0; j < this.bufferedHeaders.size(); ++j) {
            header = (SecurityHeaderElement)this.bufferedHeaders.get(j);
            if (!uri.equals(header.getId())) continue;
            qname = new QName(header.getNamespaceURI(), header.getLocalPart());
            target.setQName(qname);
            target.setContentOnly(false);
            return;
        }
    }

    private void processProcessedHeaders(SecurityHeaderElement she) throws XWSSecurityException {
        Signature sig;
        if (she instanceof EncryptedData) {
            throw new XWSSecurityException("Error in Processing, EncryptedData inside procesesdHeaders, should never happen");
        }
        if (she instanceof EncryptedKey) {
            EncryptedKey ek = (EncryptedKey)she;
            ArrayList list = (ArrayList)ek.getPendingReferenceList();
            if (list != null && list.size() > 0) {
                throw new XWSSecurityException("Error in processing, ReferenceList inside EK should have been processed");
            }
        } else if (she instanceof ReferenceListHeader) {
            ReferenceListHeader refList = (ReferenceListHeader)she;
            if (refList.getPendingReferenceList() != null && refList.getPendingReferenceList().size() > 0) {
                throw new XWSSecurityException("Error in processing, references in ReferenceList not processed");
            }
        } else if (she instanceof Signature && (sig = (Signature)she).getReferences() != null && sig.getReferences().size() > 0) {
            throw new XWSSecurityException("Error in processing, references in Signature not processed");
        }
    }

    private boolean isPending() throws XWSSecurityException {
        for (int i = 0; i < this.bufferedHeaders.size(); ++i) {
            SecurityHeaderElement she = (SecurityHeaderElement)this.bufferedHeaders.get(i);
            if (!this.isPrimary(she)) continue;
            return false;
        }
        return true;
    }

    private boolean isPrimary(SecurityHeaderElement she) {
        if (she.getLocalPart() == "Signature") {
            return true;
        }
        if (she.getLocalPart() == "EncryptedKey") {
            return true;
        }
        return she.getLocalPart() == "ReferenceList";
    }

    private void processSecurityHeader(SecurityHeaderElement she) throws XWSSecurityException {
        if (she instanceof Signature) {
            this.handleSignature((Signature)she);
            this.processedHeaders.add(she);
        } else if (she instanceof EncryptedData) {
            EncryptedData ed = (EncryptedData)she;
            try {
                if (!ed.hasCipherReference()) {
                    XMLStreamReader decryptedData = ed.getDecryptedData();
                    SecurityHeaderProcessor shp = new SecurityHeaderProcessor(this.context, this.envshNS, this.staxIF, this.creator);
                    if (decryptedData.getEventType() != 1) {
                        StreamUtil.moveToNextElement(decryptedData);
                    }
                    SecurityHeaderElement newHeader = shp.createHeader(decryptedData);
                    this.encIds.put(ed.getId(), newHeader.getId());
                    this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
                    this.processSecurityHeader(newHeader);
                    this.processedHeaders.add(newHeader);
                }
                byte[] decryptedMimeData = ed.getDecryptedMimeData();
                AttachmentImpl as = new AttachmentImpl(ed.getAttachmentContentId(), decryptedMimeData, ed.getAttachmentMimeType());
                this.securityContext.getDecryptedAttachmentSet().add(as);
            }
            catch (XMLStreamException ex) {
                ex.printStackTrace();
                throw new XWSSecurityException("Error occurred while decrypting EncryptedData with ID " + ed.getId(), ex);
            }
        } else if (she instanceof EncryptedKey) {
            EncryptedKey ek = (EncryptedKey)she;
            if (this.pendingElement == null) {
                this.pendingElement = ek;
            }
            this.addSecurityHeader(ek);
            ArrayList list = (ArrayList)ek.getPendingReferenceList();
            if (list != null) {
                this.findAndReplaceED(list, ek);
                if (ek.getPendingReferenceList().size() > 0 && this.payLoadWsuId.length() > 0 && ek.getPendingReferenceList().contains(this.payLoadWsuId)) {
                    try {
                        EncryptedData ed = new EncryptedData(this.message, this.context, this.bodyENVNS);
                        this.payLoadWsuId = ed.getId();
                        this.handlePayLoadED(ed);
                    }
                    catch (XMLStreamException ex) {
                        ex.printStackTrace();
                        throw new XWSSecurityException("Error occurred while parsing EncryptedData" + ex);
                    }
                    ek.getPendingReferenceList().remove(this.payLoadWsuId);
                }
                if (ek.getPendingReferenceList().size() != 0) {
                    throw new XWSSecurityException("Data  Reference under EncryptedKey with ID " + ek.getId() + " is not found");
                }
                this.pendingElement = null;
                this.bufferedHeaders.remove(ek);
                this.addSecurityHeader(ek);
            }
        } else if (she instanceof ReferenceListHeader) {
            ReferenceListHeader refList = (ReferenceListHeader)she;
            if (refList.getPendingReferenceList().contains(this.payLoadWsuId)) {
                try {
                    EncryptedData ed = new EncryptedData(this.message, this.context, this.bodyENVNS);
                    refList.getPolicy().setKeyBinding(ed.getInferredKB());
                    this.payLoadWsuId = ed.getId();
                    this.handlePayLoadED(ed);
                    refList.getPendingReferenceList().remove(this.payLoadWsuId);
                    this.cachePayLoadId();
                    this.payLoadEncId = ed.getId();
                }
                catch (XMLStreamException ex) {
                    throw new XWSSecurityException("Error occurred while processing EncryptedData", ex);
                }
            }
            if (refList.getPendingReferenceList().size() > 0) {
                this.findAndReplaceED((ArrayList)refList.getPendingReferenceList(), refList);
            }
            if (refList.getPendingReferenceList().size() > 0) {
                String uri = refList.getPendingReferenceList().get(0);
                throw new XWSSecurityException("Reference with ID " + uri + " was not found in the message");
            }
        } else {
            throw new XWSSecurityException("Need to support this header, please file a bug." + she);
        }
    }

    private void handleSignature(Signature sig) throws XWSSecurityException {
        Reference bodyRef = null;
        Reference payLoadRef = null;
        if (this.bodyWsuId.length() > 0) {
            bodyRef = sig.removeReferenceWithID("#" + this.bodyWsuId);
        }
        if (this.payLoadWsuId.length() > 0) {
            payLoadRef = sig.removeReferenceWithID("#" + this.payLoadWsuId);
        }
        if (bodyRef != null && payLoadRef != null) {
            throw new XWSSecurityException("Does not support signing of Body and PayLoad together");
        }
        boolean validated = false;
        try {
            validated = sig.validate();
        }
        catch (XWSSecurityException xe) {
            throw new WebServiceException((Throwable)xe);
        }
        if (!validated) {
            ArrayList<Reference> refs = sig.getReferences();
            if (refs != null && refs.size() > 0) {
                throw new WebServiceException("Could not find Reference " + refs.get(0).getURI() + " under Signature with ID" + sig.getId());
            }
            throw new XWSSecurityException("Verification of Signature with ID  " + sig.getId() + " failed, possible cause : proper canonicalized" + "signedinfo was not produced.");
        }
        if (bodyRef != null) {
            this.message = sig.wrapWithDigester(bodyRef, this.message, this.bodyTag, this.parentNSOnEnvelope, false);
        } else if (payLoadRef != null) {
            this.message = sig.wrapWithDigester(payLoadRef, this.message, this.bodyTag, this.bodyENVNS, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handlePayLoadED(EncryptedData ed) throws XWSSecurityException, XMLStreamException {
        if (this.pendingElement != null && this.pendingElement instanceof EncryptedKey) {
            EncryptedKey ek = (EncryptedKey)this.pendingElement;
            if (ek.getPendingReferenceList().contains(ed.getId())) {
                if (ek.getPolicy() != null) {
                    ek.getPolicy().setKeyBinding(ek.getInferredKB());
                }
                this.message = ed.getDecryptedData(ek.getKey(ed.getEncryptionAlgorithm()));
                this.payLoadEncId = this.payLoadWsuId;
                if (this.message != null && this.message.hasNext()) {
                    this.message.next();
                }
                if (this.message == null) {
                    this.message = this.getEmptyBody();
                }
                this.cachePayLoadId();
                ek.getPendingReferenceList().remove(ed.getId());
                this.findAndReplaceED((ArrayList)ek.getPendingReferenceList(), ek);
                if (ek.getPendingReferenceList().size() != 0) {
                    String uri = ek.getPendingReferenceList().get(0);
                    throw new XWSSecurityException("Could not find Reference " + uri + " under EncryptedKey with ID" + ek.getId());
                }
                this.pendingElement = null;
            }
        } else {
            this.message = ed.getDecryptedData();
            if (this.message != null && this.message.hasNext()) {
                this.message.next();
            }
            if (this.message == null) {
                this.message = this.getEmptyBody();
            }
        }
        this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
    }

    private void moveToNextElement() throws XMLStreamException {
        this.message.next();
        while (this.message.getEventType() != 1) {
            this.message.next();
        }
    }

    private boolean isTimeStamp() {
        return this.message.getLocalName() == "Timestamp" && this.message.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    }

    private boolean isBST() {
        return this.message.getLocalName() == "BinarySecurityToken" && this.message.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    private boolean isUsernameToken() {
        return this.message.getLocalName() == "UsernameToken" && this.message.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    private boolean isSignature() {
        return this.message.getLocalName() == "Signature" && this.message.getNamespaceURI() == "http://www.w3.org/2000/09/xmldsig#";
    }

    private boolean isEncryptedKey() {
        return this.message.getLocalName() == "EncryptedKey" && this.message.getNamespaceURI() == "http://www.w3.org/2001/04/xmlenc#";
    }

    private boolean isReferenceList() {
        return this.message.getLocalName() == "ReferenceList" && this.message.getNamespaceURI() == "http://www.w3.org/2001/04/xmlenc#";
    }

    private boolean isEncryptedData() {
        return this.message.getLocalName() == "EncryptedData" && this.message.getNamespaceURI() == "http://www.w3.org/2001/04/xmlenc#";
    }

    private boolean isDerivedKey() {
        return this.message.getLocalName() == "DerivedKeyToken" && (this.message.getNamespaceURI() == "http://schemas.xmlsoap.org/ws/2005/02/sc" || this.message.getNamespaceURI() == "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
    }

    private boolean isSignatureConfirmation() {
        return this.message.getLocalName() == "SignatureConfirmation" && this.message.getNamespaceURI() == "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    }

    private boolean isSCT() {
        return this.message.getLocalName() == "SecurityContextToken" && (this.message.getNamespaceURI() == "http://schemas.xmlsoap.org/ws/2005/02/sc" || this.message.getNamespaceURI() == "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
    }

    private boolean isEncryptedHeader() {
        return this.message.getLocalName() == "EncryptedHeader" && this.message.getNamespaceURI() == "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    }

    private boolean isSTR() {
        return this.message.getLocalName() == "SecurityTokenReference" && this.message.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    private boolean isSAML() {
        String uri;
        return this.message.getLocalName() == "Assertion" && ((uri = this.message.getNamespaceURI()) == "urn:oasis:names:tc:SAML:2.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion");
    }

    private int getSecurityElementType() {
        if (this.message.getEventType() == 1) {
            if (this.isTimeStamp()) {
                return 1;
            }
            if (this.isUsernameToken()) {
                return 2;
            }
            if (this.isBST()) {
                return 3;
            }
            if (this.isSignature()) {
                return 6;
            }
            if (this.isEncryptedKey()) {
                return 5;
            }
            if (this.isEncryptedData()) {
                return 4;
            }
            if (this.isEncryptedHeader()) {
                return 12;
            }
            if (this.isReferenceList()) {
                return 7;
            }
            if (this.isSignatureConfirmation()) {
                return 9;
            }
            if (this.isDerivedKey()) {
                return 8;
            }
            if (this.isSCT()) {
                return 10;
            }
            if (this.isSAML()) {
                return 11;
            }
            if (this.isSTR()) {
                return 13;
            }
        }
        return -1;
    }

    private void findAndReplaceED(ArrayList<String> edList, SecurityHeaderElement ekOrRlh) throws XWSSecurityException {
        EncryptedKey ek = null;
        ReferenceListHeader rlh = null;
        if (ekOrRlh instanceof EncryptedKey) {
            ek = (EncryptedKey)ekOrRlh;
        } else if (ekOrRlh instanceof ReferenceListHeader) {
            rlh = (ReferenceListHeader)ekOrRlh;
        } else {
            return;
        }
        ArrayList refList = (ArrayList)edList.clone();
        for (int i = 0; i < refList.size(); ++i) {
            SecurityHeaderElement header;
            int j;
            String id = (String)refList.get(i);
            boolean found = false;
            ListIterator listItr = this.headers.listIterator();
            while (listItr.hasNext()) {
                GenericSecuredHeader header2 = (GenericSecuredHeader)listItr.next();
                if (!header2.hasID(id)) continue;
                GenericSecuredHeader processedHeader = this.processEncryptedSOAPHeader(header2, ekOrRlh);
                edList.remove(id);
                int index = this.headers.indexOf(header2);
                this.headers.set(index, processedHeader);
                found = true;
                break;
            }
            if (found) continue;
            for (j = 0; j < this.processedHeaders.size(); ++j) {
                header = (SecurityHeaderElement)this.processedHeaders.get(j);
                if (!id.equals(header.getId()) || !(header instanceof EncryptedData)) continue;
                found = true;
                throw new XWSSecurityException("EncryptedKey or ReferenceList must appear before EncryptedData element with ID" + header.getId());
            }
            if (found) continue;
            for (j = 0; j < this.bufferedHeaders.size(); ++j) {
                header = (SecurityHeaderElement)this.bufferedHeaders.get(j);
                if (!id.equals(header.getId()) || !(header instanceof EncryptedData)) continue;
                EncryptedData ed = (EncryptedData)header;
                if (!ed.hasCipherReference()) {
                    XMLStreamReader decryptedData = null;
                    try {
                        if (ek != null) {
                            if (ek.getPolicy() != null) {
                                ek.getPolicy().setKeyBinding(ek.getInferredKB());
                            }
                            decryptedData = ed.getDecryptedData(ek.getKey(ed.getEncryptionAlgorithm()));
                        } else if (rlh != null) {
                            rlh.getPolicy().setKeyBinding(ed.getInferredKB());
                            decryptedData = ed.getDecryptedData();
                        } else {
                            throw new XWSSecurityException("Internal Error: Both EncryptedKey and ReferenceList are set to null");
                        }
                        SecurityHeaderProcessor shp = new SecurityHeaderProcessor(this.context, this.envshNS, this.staxIF, this.creator);
                        if (decryptedData.getEventType() != 1) {
                            StreamUtil.moveToNextElement(decryptedData);
                        }
                        SecurityHeaderElement she = shp.createHeader(decryptedData);
                        edList.remove(ed.getId());
                        this.encIds.put(ed.getId(), she.getId());
                        this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
                        this.bufferedHeaders.set(i, she);
                        continue;
                    }
                    catch (XMLStreamException ex) {
                        ex.printStackTrace();
                        throw new XWSSecurityException("Error occurred while decrypting EncryptedData with ID " + ed.getId(), ex);
                    }
                }
                byte[] decryptedMimeData = null;
                if (ek != null) {
                    decryptedMimeData = ed.getDecryptedMimeData(ek.getKey(ed.getEncryptionAlgorithm()));
                } else if (rlh != null) {
                    decryptedMimeData = ed.getDecryptedMimeData();
                } else {
                    throw new XWSSecurityException("Internal Error: Both EncryptedKey and ReferenceList are set to null");
                }
                AttachmentImpl as = new AttachmentImpl(ed.getAttachmentContentId(), decryptedMimeData, ed.getAttachmentMimeType());
                this.securityContext.getDecryptedAttachmentSet().add(as);
                edList.remove(ed.getId());
            }
        }
    }

    private GenericSecuredHeader processEncryptedSOAPHeader(GenericSecuredHeader header, SecurityHeaderElement ekOrRlh) throws XWSSecurityException {
        EncryptedKey ek = null;
        ReferenceListHeader rlh = null;
        if (ekOrRlh instanceof EncryptedKey) {
            ek = (EncryptedKey)ekOrRlh;
        } else if (ekOrRlh instanceof ReferenceListHeader) {
            rlh = (ReferenceListHeader)ekOrRlh;
        }
        try {
            XMLStreamReader reader = header.readHeader();
            if (reader.getEventType() == 7) {
                reader.next();
            }
            if (reader.getEventType() != 1) {
                StreamUtil.moveToNextElement(reader);
            }
            XMLStreamReader decryptedData = null;
            InputStream decryptedIS = null;
            EncryptedData ed = null;
            EncryptedHeader eh = null;
            boolean encContent = false;
            EncryptedContentHeaderParser encContentparser = null;
            if ("EncryptedData".equals(reader.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(reader.getNamespaceURI())) {
                ed = new EncryptedData(reader, this.context, this.parentNS);
            } else if ("EncryptedHeader".equals(reader.getLocalName()) && "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd".equals(reader.getNamespaceURI())) {
                eh = new EncryptedHeader(reader, this.context, this.parentNS);
                ed = eh.getEncryptedData();
            } else if (this.context.getEncHeaderContent()) {
                encContent = true;
                encContentparser = new EncryptedContentHeaderParser(reader, this.parentNS, this.context);
                ed = encContentparser.getEncryptedData();
            } else {
                throw new XWSSecurityException("Wrong Encrypted SOAP Header");
            }
            if (!encContent) {
                if (ek != null) {
                    if (ek.getPolicy() != null) {
                        ek.getPolicy().setKeyBinding(ek.getInferredKB());
                    }
                    decryptedData = ed.getDecryptedData(ek.getKey(ed.getEncryptionAlgorithm()));
                } else if (rlh != null) {
                    rlh.getPolicy().setKeyBinding(ed.getInferredKB());
                    decryptedData = ed.getDecryptedData();
                } else {
                    throw new XWSSecurityException("Internal Error: Both EncryptedKey and ReferenceList set to null");
                }
                if (decryptedData.getEventType() == 7) {
                    decryptedData.next();
                }
                if (decryptedData.getEventType() != 1) {
                    StreamUtil.moveToNextElement(decryptedData);
                }
            } else if (ek != null) {
                if (ek.getPolicy() != null) {
                    ek.getPolicy().setKeyBinding(ek.getInferredKB());
                }
                decryptedIS = ed.getCipherInputStream(ek.getKey(ed.getEncryptionAlgorithm()));
            } else if (rlh != null) {
                rlh.getPolicy().setKeyBinding(ed.getInferredKB());
                decryptedIS = ed.getCipherInputStream();
            }
            GenericSecuredHeader gsh = null;
            if (!encContent) {
                HashMap<String, String> headerBlockNamespaces = this.parentNS;
                if (decryptedData.getNamespaceCount() > 0) {
                    headerBlockNamespaces = new HashMap<String, String>(this.parentNS);
                    for (int k = 0; k < decryptedData.getNamespaceCount(); ++k) {
                        headerBlockNamespaces.put(decryptedData.getNamespacePrefix(k), decryptedData.getNamespaceURI(k));
                    }
                }
                gsh = new GenericSecuredHeader(decryptedData, this.soapVersion, this.creator, headerBlockNamespaces, this.staxIF, this.context.getEncHeaderContent());
            } else {
                XMLStreamReader decryptedHeader = encContentparser.getDecryptedElement(decryptedIS);
                if (decryptedHeader.getEventType() == 7) {
                    decryptedHeader.next();
                }
                if (decryptedHeader.getEventType() != 1) {
                    StreamUtil.moveToNextElement(decryptedHeader);
                }
                HashMap<String, String> headerBlockNamespaces = this.parentNS;
                if (decryptedHeader.getNamespaceCount() > 0) {
                    headerBlockNamespaces = new HashMap<String, String>(this.parentNS);
                    for (int k = 0; k < decryptedHeader.getNamespaceCount(); ++k) {
                        String prefix = decryptedHeader.getNamespacePrefix(k);
                        if (prefix == null) {
                            prefix = "";
                        }
                        headerBlockNamespaces.put(prefix, decryptedHeader.getNamespaceURI(k));
                    }
                }
                gsh = new GenericSecuredHeader(decryptedHeader, this.soapVersion, this.creator, headerBlockNamespaces, this.staxIF, this.context.getEncHeaderContent());
            }
            QName gshQName = new QName(gsh.getNamespaceURI(), gsh.getLocalPart());
            if (eh != null) {
                this.encQNames.put(eh.getId(), gshQName);
                this.edAlgos.put(eh.getId(), ed.getEncryptionAlgorithm());
            } else {
                this.encQNames.put(ed.getId(), gshQName);
                this.edAlgos.put(ed.getId(), ed.getEncryptionAlgorithm());
            }
            return gsh;
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            throw new XWSSecurityException("Error occurred while decrypting EncryptedData ", ex);
        }
        catch (XMLStreamBufferException ex) {
            throw new XWSSecurityException("Error occurred while decrypting EncryptedData", ex);
        }
    }

    private void addSecurityHeader(SecurityHeaderElement sh) {
        if (this.pendingElement == null || sh instanceof TokenValidator) {
            this.processedHeaders.add(sh);
        } else {
            this.bufferedHeaders.add(sh);
        }
    }

    private void cachePayLoadId() {
        if (this.message != null && this.message.getEventType() == 1) {
            this.payLoadWsuId = StreamUtil.getWsuId(this.message);
            if (this.payLoadWsuId == null) {
                this.payLoadWsuId = StreamUtil.getId(this.message);
            }
            if (this.payLoadWsuId == null) {
                this.payLoadWsuId = "";
            }
        }
    }

    private boolean areHeadersSecured(SignaturePolicy sp) {
        ArrayList list = ((SignaturePolicy.FeatureBinding)sp.getFeatureBinding()).getTargetBindings();
        HeaderList headerList = this.headers;
        for (int hl = 0; hl < headerList.size(); ++hl) {
            Header hdr2 = (Header)headerList.get(hl);
            String localName = hdr2.getLocalPart();
            String uri = hdr2.getNamespaceURI();
            boolean found = false;
            if (!"http://www.w3.org/2005/08/addressing".equals(uri) && !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(uri)) continue;
            for (int i = 0; i < list.size(); ++i) {
                SignatureTarget st = (SignatureTarget)list.get(i);
                QName value = st.getQName();
                if (!value.getLocalPart().equals(localName) || !value.getNamespaceURI().equals(uri)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return found;
        }
        return true;
    }

    static {
        Init.init();
    }
}

