/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundFault;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLInput;
import com.sun.xml.ws.api.model.wsdl.WSDLMessage;
import com.sun.xml.ws.api.model.wsdl.WSDLObject;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOutput;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtensionContext;
import com.sun.xml.ws.policy.EffectivePolicyModifier;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.jaxws.BuilderHandlerEndpointScope;
import com.sun.xml.ws.policy.jaxws.BuilderHandlerMessageScope;
import com.sun.xml.ws.policy.jaxws.BuilderHandlerOperationScope;
import com.sun.xml.ws.policy.jaxws.BuilderHandlerServiceScope;
import com.sun.xml.ws.policy.jaxws.PolicyConfigParser;
import com.sun.xml.ws.policy.jaxws.PolicyMapBuilder;
import com.sun.xml.ws.policy.jaxws.WSDLBoundFaultContainer;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelUnmarshaller;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModelContext;
import com.sun.xml.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.ws.policy.sourcemodel.wspolicy.XmlToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyWSDLParserExtension
extends WSDLParserExtension {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyWSDLParserExtension.class);
    private static final StringBuffer AnonymnousPolicyIdPrefix = new StringBuffer("#__anonymousPolicy__ID");
    private int anonymousPoliciesCount;
    private boolean isForConfigFile = false;
    private PolicyRecord expandQueueHead = null;
    private Map<String, PolicyRecord> policyRecordsPassedBy = null;
    private Map<String, PolicySourceModel> anonymousPolicyModels = null;
    private List<String> unresolvedUris = null;
    final Set<String> urlsRead = new HashSet<String>();
    private final LinkedList<String> urisNeeded = new LinkedList();
    private final Map<String, PolicySourceModel> modelsNeeded = new HashMap<String, PolicySourceModel>();
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4ServiceMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4PortMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4PortTypeMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BoundOperationMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4OperationMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4MessageMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4InputMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4OutputMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4FaultMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingInputOpMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingOutputOpMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingFaultOpMap = null;
    private PolicyMapBuilder policyBuilder = new PolicyMapBuilder();
    private PolicyMapMutator[] externalMutators;

    private boolean isPolicyProcessed(String policyUri) {
        return this.modelsNeeded.containsKey(policyUri);
    }

    private void addNewPolicyNeeded(String policyUri, PolicySourceModel policyModel) {
        if (!this.modelsNeeded.containsKey(policyUri)) {
            this.modelsNeeded.put(policyUri, policyModel);
            this.urisNeeded.addFirst(policyUri);
        }
    }

    private Map<String, PolicySourceModel> getPolicyModels() {
        return this.modelsNeeded;
    }

    private Map<String, PolicyRecord> getPolicyRecordsPassedBy() {
        if (null == this.policyRecordsPassedBy) {
            this.policyRecordsPassedBy = new HashMap<String, PolicyRecord>();
        }
        return this.policyRecordsPassedBy;
    }

    private Map<String, PolicySourceModel> getAnonymousPolicyModels() {
        if (null == this.anonymousPolicyModels) {
            this.anonymousPolicyModels = new HashMap<String, PolicySourceModel>();
        }
        return this.anonymousPolicyModels;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4ServiceMap() {
        if (null == this.handlers4ServiceMap) {
            this.handlers4ServiceMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4ServiceMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4PortMap() {
        if (null == this.handlers4PortMap) {
            this.handlers4PortMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4PortMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4PortTypeMap() {
        if (null == this.handlers4PortTypeMap) {
            this.handlers4PortTypeMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4PortTypeMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingMap() {
        if (null == this.handlers4BindingMap) {
            this.handlers4BindingMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4OperationMap() {
        if (null == this.handlers4OperationMap) {
            this.handlers4OperationMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4OperationMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BoundOperationMap() {
        if (null == this.handlers4BoundOperationMap) {
            this.handlers4BoundOperationMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BoundOperationMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4MessageMap() {
        if (null == this.handlers4MessageMap) {
            this.handlers4MessageMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4MessageMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4InputMap() {
        if (null == this.handlers4InputMap) {
            this.handlers4InputMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4InputMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4OutputMap() {
        if (null == this.handlers4OutputMap) {
            this.handlers4OutputMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4OutputMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4FaultMap() {
        if (null == this.handlers4FaultMap) {
            this.handlers4FaultMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4FaultMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingInputOpMap() {
        if (null == this.handlers4BindingInputOpMap) {
            this.handlers4BindingInputOpMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingInputOpMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingOutputOpMap() {
        if (null == this.handlers4BindingOutputOpMap) {
            this.handlers4BindingOutputOpMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingOutputOpMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingFaultOpMap() {
        if (null == this.handlers4BindingFaultOpMap) {
            this.handlers4BindingFaultOpMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingFaultOpMap;
    }

    private List<String> getUnresolvedUris(boolean emptyListNeeded) {
        if (null == this.unresolvedUris || emptyListNeeded) {
            this.unresolvedUris = new LinkedList<String>();
        }
        return this.unresolvedUris;
    }

    private void policyRecToExpandQueue(PolicyRecord policyRec) {
        this.expandQueueHead = null == this.expandQueueHead ? policyRec : this.expandQueueHead.insert(policyRec);
    }

    public PolicyWSDLParserExtension() {
        this(false, (PolicyMapMutator[])null);
    }

    public PolicyWSDLParserExtension(PolicyMapMutator ... externalMutators) {
        this(false, externalMutators);
    }

    public PolicyWSDLParserExtension(boolean isForConfigFile, PolicyMapMutator ... externalMutators) {
        this.isForConfigFile = isForConfigFile;
        if (null != externalMutators) {
            this.externalMutators = new PolicyMapMutator[externalMutators.length];
            System.arraycopy(externalMutators, 0, this.externalMutators, 0, externalMutators.length);
        }
    }

    private PolicyRecordHandler readSinglePolicy(PolicyRecord policyRec, boolean inner) {
        PolicyRecordHandler handler = null;
        String policyId = policyRec.policyModel.getPolicyId();
        if (policyId == null) {
            policyId = policyRec.policyModel.getPolicyName();
        }
        if (policyId != null) {
            handler = new PolicyRecordHandler(HandlerType.PolicyUri, policyRec.uri);
            this.getPolicyRecordsPassedBy().put(policyRec.uri, policyRec);
            this.policyRecToExpandQueue(policyRec);
        } else if (inner) {
            String anonymousId = AnonymnousPolicyIdPrefix.append(this.anonymousPoliciesCount++).toString();
            handler = new PolicyRecordHandler(HandlerType.AnonymousPolicyId, anonymousId);
            this.getAnonymousPolicyModels().put(anonymousId, policyRec.policyModel);
            if (null != policyRec.unresolvedURIs) {
                this.getUnresolvedUris(false).addAll(policyRec.unresolvedURIs);
            }
        }
        return handler;
    }

    private void addHandlerToMap(Map<WSDLObject, Collection<PolicyRecordHandler>> map, WSDLObject key, PolicyRecordHandler handler) {
        if (map.containsKey(key)) {
            map.get(key).add(handler);
        } else {
            LinkedList<PolicyRecordHandler> newSet = new LinkedList<PolicyRecordHandler>();
            newSet.add(handler);
            map.put(key, newSet);
        }
    }

    private String getBaseUrl(String policyUri) {
        if (null == policyUri) {
            return null;
        }
        int fragmentIdx = policyUri.indexOf(35);
        return fragmentIdx == -1 ? policyUri : policyUri.substring(0, fragmentIdx);
    }

    private String relativeToAbsoluteUrl(String relativeUri, String baseUri) {
        if ('#' != relativeUri.charAt(0)) {
            return relativeUri;
        }
        return null == baseUri ? relativeUri : baseUri + relativeUri;
    }

    private void processReferenceUri(String policyUri, WSDLObject element, XMLStreamReader reader, Map<WSDLObject, Collection<PolicyRecordHandler>> map) {
        if (null == policyUri || policyUri.length() == 0) {
            return;
        }
        if ('#' != policyUri.charAt(0)) {
            this.getUnresolvedUris(false).add(policyUri);
        }
        this.addHandlerToMap(map, element, new PolicyRecordHandler(HandlerType.PolicyUri, this.relativeToAbsoluteUrl(policyUri, reader.getLocation().getSystemId())));
    }

    private boolean processSubelement(WSDLObject element, XMLStreamReader reader, Map<WSDLObject, Collection<PolicyRecordHandler>> map) {
        if (NamespaceVersion.resolveAsToken(reader.getName()) == XmlToken.PolicyReference) {
            this.processReferenceUri(this.readPolicyReferenceElement(reader), element, reader, map);
            return true;
        }
        if (NamespaceVersion.resolveAsToken(reader.getName()) == XmlToken.Policy) {
            PolicyRecordHandler handler = this.readSinglePolicy(this.skipPolicyElement(reader, null == reader.getLocation().getSystemId() ? "" : reader.getLocation().getSystemId()), true);
            if (null != handler) {
                this.addHandlerToMap(map, element, handler);
            }
            return true;
        }
        return false;
    }

    private void processAttributes(WSDLObject element, XMLStreamReader reader, Map<WSDLObject, Collection<PolicyRecordHandler>> map) {
        String[] uriArray = this.getPolicyURIsFromAttr(reader);
        if (null != uriArray) {
            for (String policyUri : uriArray) {
                this.processReferenceUri(policyUri, element, reader, map);
            }
        }
    }

    @Override
    public boolean portElements(WSDLPort port, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(port, reader, this.getHandlers4PortMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void portAttributes(WSDLPort port, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(port, reader, this.getHandlers4PortMap());
        LOGGER.exiting();
    }

    @Override
    public boolean serviceElements(WSDLService service, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(service, reader, this.getHandlers4ServiceMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void serviceAttributes(WSDLService service, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(service, reader, this.getHandlers4ServiceMap());
        LOGGER.exiting();
    }

    @Override
    public boolean definitionsElements(XMLStreamReader reader) {
        LOGGER.entering();
        if (NamespaceVersion.resolveAsToken(reader.getName()) == XmlToken.Policy) {
            this.readSinglePolicy(this.skipPolicyElement(reader, null == reader.getLocation().getSystemId() ? "" : reader.getLocation().getSystemId()), false);
            LOGGER.exiting();
            return true;
        }
        LOGGER.exiting();
        return false;
    }

    @Override
    public boolean bindingElements(WSDLBoundPortType binding, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(binding, reader, this.getHandlers4BindingMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void bindingAttributes(WSDLBoundPortType binding, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(binding, reader, this.getHandlers4BindingMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeElements(WSDLPortType portType, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(portType, reader, this.getHandlers4PortTypeMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void portTypeAttributes(WSDLPortType portType, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(portType, reader, this.getHandlers4PortTypeMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationElements(WSDLOperation operation, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(operation, reader, this.getHandlers4OperationMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void portTypeOperationAttributes(WSDLOperation operation, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(operation, reader, this.getHandlers4OperationMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationElements(WSDLBoundOperation boundOperation, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(boundOperation, reader, this.getHandlers4BoundOperationMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void bindingOperationAttributes(WSDLBoundOperation boundOperation, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(boundOperation, reader, this.getHandlers4BoundOperationMap());
        LOGGER.exiting();
    }

    @Override
    public boolean messageElements(WSDLMessage msg, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(msg, reader, this.getHandlers4MessageMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void messageAttributes(WSDLMessage msg, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(msg, reader, this.getHandlers4MessageMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationInputElements(WSDLInput input, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(input, reader, this.getHandlers4InputMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void portTypeOperationInputAttributes(WSDLInput input, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(input, reader, this.getHandlers4InputMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationOutputElements(WSDLOutput output, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(output, reader, this.getHandlers4OutputMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void portTypeOperationOutputAttributes(WSDLOutput output, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(output, reader, this.getHandlers4OutputMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationFaultElements(WSDLFault fault, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(fault, reader, this.getHandlers4FaultMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void portTypeOperationFaultAttributes(WSDLFault fault, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(fault, reader, this.getHandlers4FaultMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationInputElements(WSDLBoundOperation operation, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(operation, reader, this.getHandlers4BindingInputOpMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void bindingOperationInputAttributes(WSDLBoundOperation operation, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(operation, reader, this.getHandlers4BindingInputOpMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationOutputElements(WSDLBoundOperation operation, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(operation, reader, this.getHandlers4BindingOutputOpMap());
        LOGGER.exiting();
        return result;
    }

    @Override
    public void bindingOperationOutputAttributes(WSDLBoundOperation operation, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(operation, reader, this.getHandlers4BindingOutputOpMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationFaultElements(WSDLBoundFault fault, XMLStreamReader reader) {
        LOGGER.entering();
        boolean result = this.processSubelement(fault, reader, this.getHandlers4BindingFaultOpMap());
        LOGGER.exiting(result);
        return result;
    }

    @Override
    public void bindingOperationFaultAttributes(WSDLBoundFault fault, XMLStreamReader reader) {
        LOGGER.entering();
        this.processAttributes(fault, reader, this.getHandlers4BindingFaultOpMap());
        LOGGER.exiting();
    }

    private PolicyMapBuilder getPolicyMapBuilder() {
        if (null == this.policyBuilder) {
            this.policyBuilder = new PolicyMapBuilder();
        }
        return this.policyBuilder;
    }

    private Collection<String> getPolicyURIs(Collection<PolicyRecordHandler> handlers, PolicySourceModelContext modelContext) throws PolicyException {
        ArrayList<String> result = new ArrayList<String>(handlers.size());
        for (PolicyRecordHandler handler : handlers) {
            String policyUri = handler.handler;
            if (HandlerType.AnonymousPolicyId == handler.type) {
                PolicySourceModel policyModel = this.getAnonymousPolicyModels().get(policyUri);
                policyModel.expand(modelContext);
                while (this.getPolicyModels().containsKey(policyUri)) {
                    policyUri = AnonymnousPolicyIdPrefix.append(this.anonymousPoliciesCount++).toString();
                }
                this.getPolicyModels().put(policyUri, policyModel);
            }
            result.add(policyUri);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean readExternalFile(String fileUrl) {
        boolean bl;
        InputStream ios = null;
        XMLStreamReader reader = null;
        try {
            URL xmlURL = new URL(fileUrl);
            ios = xmlURL.openStream();
            reader = XMLInputFactory.newInstance().createXMLStreamReader(ios);
            while (reader.hasNext()) {
                if (reader.isStartElement() && NamespaceVersion.resolveAsToken(reader.getName()) == XmlToken.Policy) {
                    this.readSinglePolicy(this.skipPolicyElement(reader, fileUrl), false);
                }
                reader.next();
            }
            bl = true;
        }
        catch (IOException ioe) {
            boolean bl2 = false;
            PolicyUtils.IO.closeResource(reader);
            PolicyUtils.IO.closeResource(ios);
            return bl2;
        }
        catch (XMLStreamException xmlse) {
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    PolicyUtils.IO.closeResource(reader);
                    PolicyUtils.IO.closeResource(ios);
                    throw throwable;
                }
            }
            PolicyUtils.IO.closeResource(reader);
            PolicyUtils.IO.closeResource(ios);
            return bl3;
        }
        PolicyUtils.IO.closeResource(reader);
        PolicyUtils.IO.closeResource(ios);
        return bl;
    }

    @Override
    public void finished(WSDLParserExtensionContext context) {
        LOGGER.entering();
        if (null != this.expandQueueHead) {
            List<String> externalUris = this.getUnresolvedUris(false);
            this.getUnresolvedUris(true);
            LinkedList<String> baseUnresolvedUris = new LinkedList<String>();
            PolicyRecord currentRec = this.expandQueueHead;
            while (null != currentRec) {
                baseUnresolvedUris.addFirst(currentRec.uri);
                currentRec = currentRec.next;
            }
            this.getUnresolvedUris(false).addAll(baseUnresolvedUris);
            this.expandQueueHead = null;
            this.getUnresolvedUris(false).addAll(externalUris);
        }
        while (!this.getUnresolvedUris(false).isEmpty()) {
            List<String> urisToBeSolvedList = this.getUnresolvedUris(false);
            this.getUnresolvedUris(true);
            for (String currentUri : urisToBeSolvedList) {
                if (this.isPolicyProcessed(currentUri)) continue;
                PolicyRecord policyRecord = this.getPolicyRecordsPassedBy().get(currentUri);
                if (null == policyRecord) {
                    if (this.urlsRead.contains(this.getBaseUrl(currentUri))) {
                        LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_1042_CAN_NOT_FIND_POLICY(currentUri)));
                        continue;
                    }
                    if (!this.readExternalFile(this.getBaseUrl(currentUri))) continue;
                    this.getUnresolvedUris(false).add(currentUri);
                    continue;
                }
                if (null != policyRecord.unresolvedURIs) {
                    this.getUnresolvedUris(false).addAll(policyRecord.unresolvedURIs);
                }
                this.addNewPolicyNeeded(currentUri, policyRecord.policyModel);
            }
        }
        PolicySourceModelContext modelContext = PolicySourceModelContext.createContext();
        for (String policyUri : this.urisNeeded) {
            PolicySourceModel policySourceModel = this.modelsNeeded.get(policyUri);
            try {
                policySourceModel.expand(modelContext);
                modelContext.addModel(new URI(policyUri), policySourceModel);
            }
            catch (URISyntaxException e) {
                LOGGER.logSevereException(e);
            }
            catch (PolicyException e) {
                LOGGER.logSevereException(e);
            }
        }
        try {
            HashSet<BuilderHandlerMessageScope> messageSet = new HashSet<BuilderHandlerMessageScope>();
            for (WSDLService wSDLService : context.getWSDLModel().getServices().values()) {
                if (this.getHandlers4ServiceMap().containsKey(wSDLService)) {
                    this.getPolicyMapBuilder().registerHandler(new BuilderHandlerServiceScope(this.getPolicyURIs(this.getHandlers4ServiceMap().get(wSDLService), modelContext), this.getPolicyModels(), wSDLService, wSDLService.getName()));
                }
                for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                    if (this.getHandlers4PortMap().containsKey(wSDLPort)) {
                        this.getPolicyMapBuilder().registerHandler(new BuilderHandlerEndpointScope(this.getPolicyURIs(this.getHandlers4PortMap().get(wSDLPort), modelContext), this.getPolicyModels(), wSDLPort, wSDLPort.getOwner().getName(), wSDLPort.getName()));
                    }
                    if (null == wSDLPort.getBinding()) continue;
                    if (this.getHandlers4BindingMap().containsKey(wSDLPort.getBinding())) {
                        this.getPolicyMapBuilder().registerHandler(new BuilderHandlerEndpointScope(this.getPolicyURIs(this.getHandlers4BindingMap().get(wSDLPort.getBinding()), modelContext), this.getPolicyModels(), wSDLPort.getBinding(), wSDLService.getName(), wSDLPort.getName()));
                    }
                    if (this.getHandlers4PortTypeMap().containsKey(wSDLPort.getBinding().getPortType())) {
                        this.getPolicyMapBuilder().registerHandler(new BuilderHandlerEndpointScope(this.getPolicyURIs(this.getHandlers4PortTypeMap().get(wSDLPort.getBinding().getPortType()), modelContext), this.getPolicyModels(), wSDLPort.getBinding().getPortType(), wSDLService.getName(), wSDLPort.getName()));
                    }
                    for (WSDLBoundOperation wSDLBoundOperation : wSDLPort.getBinding().getBindingOperations()) {
                        WSDLMessage outputMsg;
                        WSDLOutput output;
                        WSDLMessage inputMsg;
                        WSDLInput input;
                        WSDLOperation operation = wSDLBoundOperation.getOperation();
                        QName operationName = new QName(wSDLBoundOperation.getBoundPortType().getName().getNamespaceURI(), wSDLBoundOperation.getName().getLocalPart());
                        if (this.getHandlers4BoundOperationMap().containsKey(wSDLBoundOperation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerOperationScope(this.getPolicyURIs(this.getHandlers4BoundOperationMap().get(wSDLBoundOperation), modelContext), this.getPolicyModels(), wSDLBoundOperation, wSDLService.getName(), wSDLPort.getName(), operationName));
                        }
                        if (this.getHandlers4OperationMap().containsKey(operation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerOperationScope(this.getPolicyURIs(this.getHandlers4OperationMap().get(operation), modelContext), this.getPolicyModels(), operation, wSDLService.getName(), wSDLPort.getName(), operationName));
                        }
                        if (null != (input = operation.getInput()) && (inputMsg = input.getMessage()) != null && this.getHandlers4MessageMap().containsKey(inputMsg)) {
                            messageSet.add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4MessageMap().get(inputMsg), modelContext), this.getPolicyModels(), inputMsg, BuilderHandlerMessageScope.Scope.InputMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, null));
                        }
                        if (this.getHandlers4BindingInputOpMap().containsKey(wSDLBoundOperation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4BindingInputOpMap().get(wSDLBoundOperation), modelContext), this.getPolicyModels(), wSDLBoundOperation, BuilderHandlerMessageScope.Scope.InputMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, null));
                        }
                        if (null != input && this.getHandlers4InputMap().containsKey(input)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4InputMap().get(input), modelContext), this.getPolicyModels(), input, BuilderHandlerMessageScope.Scope.InputMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, null));
                        }
                        if (null != (output = operation.getOutput()) && (outputMsg = output.getMessage()) != null && this.getHandlers4MessageMap().containsKey(outputMsg)) {
                            messageSet.add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4MessageMap().get(outputMsg), modelContext), this.getPolicyModels(), outputMsg, BuilderHandlerMessageScope.Scope.OutputMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, null));
                        }
                        if (this.getHandlers4BindingOutputOpMap().containsKey(wSDLBoundOperation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4BindingOutputOpMap().get(wSDLBoundOperation), modelContext), this.getPolicyModels(), wSDLBoundOperation, BuilderHandlerMessageScope.Scope.OutputMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, null));
                        }
                        if (null != output && this.getHandlers4OutputMap().containsKey(output)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4OutputMap().get(output), modelContext), this.getPolicyModels(), output, BuilderHandlerMessageScope.Scope.OutputMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, null));
                        }
                        for (WSDLBoundFault wSDLBoundFault : wSDLBoundOperation.getFaults()) {
                            WSDLFault fault = wSDLBoundFault.getFault();
                            WSDLMessage faultMessage = fault.getMessage();
                            QName faultName = new QName(wSDLBoundOperation.getBoundPortType().getName().getNamespaceURI(), wSDLBoundFault.getName());
                            if (faultMessage != null && this.getHandlers4MessageMap().containsKey(faultMessage)) {
                                messageSet.add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4MessageMap().get(faultMessage), modelContext), this.getPolicyModels(), new WSDLBoundFaultContainer(wSDLBoundFault, wSDLBoundOperation), BuilderHandlerMessageScope.Scope.FaultMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, faultName));
                            }
                            if (fault != null && this.getHandlers4FaultMap().containsKey(fault)) {
                                messageSet.add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4FaultMap().get(fault), modelContext), this.getPolicyModels(), new WSDLBoundFaultContainer(wSDLBoundFault, wSDLBoundOperation), BuilderHandlerMessageScope.Scope.FaultMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, faultName));
                            }
                            if (!this.getHandlers4BindingFaultOpMap().containsKey(wSDLBoundFault)) continue;
                            messageSet.add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4BindingFaultOpMap().get(wSDLBoundFault), modelContext), this.getPolicyModels(), new WSDLBoundFaultContainer(wSDLBoundFault, wSDLBoundOperation), BuilderHandlerMessageScope.Scope.FaultMessageScope, wSDLService.getName(), wSDLPort.getName(), operationName, faultName));
                        }
                    }
                }
            }
            for (BuilderHandlerMessageScope builderHandlerMessageScope : messageSet) {
                this.getPolicyMapBuilder().registerHandler(builderHandlerMessageScope);
            }
        }
        catch (PolicyException e) {
            LOGGER.logSevereException(e);
        }
        EffectivePolicyModifier modifier = EffectivePolicyModifier.createEffectivePolicyModifier();
        PolicyMapExtender extender = PolicyMapExtender.createPolicyMapExtender();
        try {
            if (null != this.externalMutators && this.externalMutators.length > 0) {
                PolicyMapMutator[] policyMapMutatorArray = new PolicyMapMutator[this.externalMutators.length + 2];
                policyMapMutatorArray[0] = modifier;
                policyMapMutatorArray[1] = extender;
                System.arraycopy(this.externalMutators, 0, policyMapMutatorArray, 2, this.externalMutators.length);
                context.getWSDLModel().addExtension(new WSDLPolicyMapWrapper(this.policyBuilder.getPolicyMap(policyMapMutatorArray), modifier, extender));
            } else {
                context.getWSDLModel().addExtension(new WSDLPolicyMapWrapper(this.policyBuilder.getPolicyMap(modifier, extender), modifier, extender));
            }
        }
        catch (PolicyException policyException) {
            LOGGER.logSevereException(policyException);
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1018_POLICY_EXCEPTION_WHILE_FINISHING_PARSING_WSDL(), (Throwable)policyException));
        }
        LOGGER.exiting();
    }

    private String readPolicyReferenceElement(XMLStreamReader reader) {
        try {
            if (NamespaceVersion.resolveAsToken(reader.getName()) == XmlToken.PolicyReference) {
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if (XmlToken.resolveToken(reader.getAttributeName(i).getLocalPart()) != XmlToken.Uri) continue;
                    String uriValue = reader.getAttributeValue(i);
                    reader.next();
                    return uriValue;
                }
            }
            reader.next();
            return null;
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1001_XML_EXCEPTION_WHEN_PROCESSING_POLICY_REFERENCE(), (Throwable)e));
        }
    }

    private String[] getPolicyURIsFromAttr(XMLStreamReader reader) {
        StringBuffer policyUriBuffer = new StringBuffer();
        for (NamespaceVersion version : NamespaceVersion.values()) {
            String value = reader.getAttributeValue(version.toString(), XmlToken.PolicyUris.toString());
            if (value == null) continue;
            policyUriBuffer.append(value).append(" ");
        }
        return policyUriBuffer.length() > 0 ? policyUriBuffer.toString().split("[\\n ]+") : null;
    }

    private PolicyRecord skipPolicyElement(XMLStreamReader reader, String baseUrl) {
        if (null == reader || !reader.isStartElement()) {
            return null;
        }
        StringBuffer elementCode = new StringBuffer();
        PolicyRecord policyRec = new PolicyRecord();
        QName elementName = reader.getName();
        int depth = 0;
        try {
            do {
                switch (reader.getEventType()) {
                    case 1: {
                        boolean insidePolicyReferenceAttr;
                        QName curName = reader.getName();
                        boolean bl = insidePolicyReferenceAttr = NamespaceVersion.resolveAsToken(curName) == XmlToken.PolicyReference;
                        if (elementName.equals(curName)) {
                            ++depth;
                        }
                        StringBuffer xmlnsCode = new StringBuffer();
                        HashSet<String> tmpNsSet = new HashSet<String>();
                        if (null == curName.getPrefix() || "".equals(curName.getPrefix())) {
                            elementCode.append('<').append(curName.getLocalPart());
                            xmlnsCode.append(" xmlns=\"").append(curName.getNamespaceURI()).append('\"');
                        } else {
                            elementCode.append('<').append(curName.getPrefix()).append(':').append(curName.getLocalPart());
                            xmlnsCode.append(" xmlns:").append(curName.getPrefix()).append("=\"").append(curName.getNamespaceURI()).append('\"');
                            tmpNsSet.add(curName.getPrefix());
                        }
                        int attrCount = reader.getAttributeCount();
                        StringBuffer attrCode = new StringBuffer();
                        for (int i = 0; i < attrCount; ++i) {
                            boolean uriAttrFlg = false;
                            if (insidePolicyReferenceAttr && "URI".equals(reader.getAttributeName(i).getLocalPart())) {
                                uriAttrFlg = true;
                                if (null == policyRec.unresolvedURIs) {
                                    policyRec.unresolvedURIs = new HashSet<String>();
                                }
                                policyRec.unresolvedURIs.add(this.relativeToAbsoluteUrl(reader.getAttributeValue(i), baseUrl));
                            }
                            if ("xmlns".equals(reader.getAttributePrefix(i)) && tmpNsSet.contains(reader.getAttributeLocalName(i))) continue;
                            if (null == reader.getAttributePrefix(i) || "".equals(reader.getAttributePrefix(i))) {
                                attrCode.append(' ').append(reader.getAttributeLocalName(i)).append("=\"").append(uriAttrFlg ? this.relativeToAbsoluteUrl(reader.getAttributeValue(i), baseUrl) : reader.getAttributeValue(i)).append('\"');
                                continue;
                            }
                            attrCode.append(' ').append(reader.getAttributePrefix(i)).append(':').append(reader.getAttributeLocalName(i)).append("=\"").append(uriAttrFlg ? this.relativeToAbsoluteUrl(reader.getAttributeValue(i), baseUrl) : reader.getAttributeValue(i)).append('\"');
                            if (tmpNsSet.contains(reader.getAttributePrefix(i))) continue;
                            xmlnsCode.append(" xmlns:").append(reader.getAttributePrefix(i)).append("=\"").append(reader.getAttributeNamespace(i)).append('\"');
                            tmpNsSet.add(reader.getAttributePrefix(i));
                        }
                        elementCode.append(xmlnsCode).append(attrCode).append('>');
                        break;
                    }
                    case 2: {
                        QName curName = reader.getName();
                        if (elementName.equals(curName)) {
                            --depth;
                        }
                        elementCode.append("</").append("".equals(curName.getPrefix()) ? "" : curName.getPrefix() + ':').append(curName.getLocalPart()).append('>');
                        break;
                    }
                    case 4: {
                        elementCode.append(reader.getText());
                        break;
                    }
                    case 12: {
                        elementCode.append("<![CDATA[").append(reader.getText()).append("]]>");
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                if (!reader.hasNext() || depth <= 0) continue;
                reader.next();
            } while (8 != reader.getEventType() && depth > 0);
            policyRec.policyModel = PolicyModelUnmarshaller.getXmlUnmarshaller().unmarshalModel(new StringReader(elementCode.toString()));
            if (null != policyRec.policyModel.getPolicyId()) {
                policyRec.uri = baseUrl + "#" + policyRec.policyModel.getPolicyId();
            } else if (policyRec.policyModel.getPolicyName() != null) {
                policyRec.uri = policyRec.policyModel.getPolicyName();
            }
        }
        catch (Exception e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1033_EXCEPTION_WHEN_READING_POLICY_ELEMENT(elementCode.toString()), (Throwable)e));
        }
        this.urlsRead.add(baseUrl);
        return policyRec;
    }

    @Override
    public void postFinished(WSDLParserExtensionContext context) {
        LOGGER.entering();
        WSDLPolicyMapWrapper mapWrapper = context.getWSDLModel().getExtension(WSDLPolicyMapWrapper.class);
        if (mapWrapper != null) {
            if (context.isClientSide() && !this.isForConfigFile) {
                try {
                    PolicyMap clientPolicyMap = PolicyConfigParser.parse("client", context.getContainer(), new PolicyMapMutator[0]);
                    if (clientPolicyMap != null) {
                        mapWrapper.addClientConfigToMap("client", clientPolicyMap);
                    } else {
                        LOGGER.config(LocalizationMessages.WSP_1040_CLIENT_CONFIG_PROCESSING_SKIPPED());
                    }
                }
                catch (PolicyException e) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1017_ERROR_WHILE_PROCESSING_CLIENT_CONFIG(), (Throwable)e));
                }
                LOGGER.fine(LocalizationMessages.WSP_1024_INVOKING_CLIENT_POLICY_ALTERNATIVE_SELECTION());
                try {
                    mapWrapper.doAlternativeSelection();
                }
                catch (PolicyException e) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1003_VALID_POLICY_ALTERNATIVE_NOT_FOUND(), (Throwable)e));
                }
            }
            if (!context.isClientSide() && !this.isForConfigFile) {
                try {
                    mapWrapper.validateServerSidePolicies();
                }
                catch (PolicyException e) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1050_SERVER_SIDE_POLICY_VALIDATION_FAILED(), (Throwable)e));
                }
            }
            mapWrapper.configureModel(context.getWSDLModel());
        }
        LOGGER.exiting();
    }

    static final class PolicyRecord {
        PolicyRecord next;
        String uri;
        PolicySourceModel policyModel;
        Set<String> unresolvedURIs;

        PolicyRecord() {
        }

        PolicyRecord insert(PolicyRecord insertedRec) {
            if (null == insertedRec.unresolvedURIs || insertedRec.unresolvedURIs.isEmpty()) {
                insertedRec.next = this;
                return insertedRec;
            }
            PolicyRecord head = this;
            PolicyRecord oneBeforeCurrent = null;
            PolicyRecord current = head;
            while (null != current.next) {
                if (null != current.unresolvedURIs && current.unresolvedURIs.contains(insertedRec.uri)) {
                    if (null == oneBeforeCurrent) {
                        insertedRec.next = current;
                        return insertedRec;
                    }
                    oneBeforeCurrent.next = insertedRec;
                    insertedRec.next = current;
                    return head;
                }
                if (insertedRec.unresolvedURIs.remove(current.uri) && insertedRec.unresolvedURIs.isEmpty()) {
                    insertedRec.next = current.next;
                    current.next = insertedRec;
                    return head;
                }
                oneBeforeCurrent = current;
                current = current.next;
            }
            insertedRec.next = null;
            current.next = insertedRec;
            return head;
        }

        public String toString() {
            String result = this.uri;
            if (null != this.next) {
                result = result + "->" + this.next.toString();
            }
            return result;
        }
    }

    static final class PolicyRecordHandler {
        String handler;
        HandlerType type;

        PolicyRecordHandler(HandlerType type, String handler) {
            this.type = type;
            this.handler = handler;
        }

        HandlerType getType() {
            return this.type;
        }

        String getHandler() {
            return this.handler;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HandlerType {
        PolicyUri,
        AnonymousPolicyId;

    }
}

