/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.wssx.elements;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.policy.impl.bindings.PolicyReference;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.BinaryExchange;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.DelegateTo;
import com.sun.xml.ws.security.trust.elements.Encryption;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Issuer;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.Participants;
import com.sun.xml.ws.security.trust.elements.ProofEncryption;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.SignChallenge;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.AllowPostdatingType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.BinaryExchangeType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.CancelTargetType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ClaimsType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.DelegateToType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.EncryptionType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.LifetimeType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.OnBehalfOfType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ParticipantsType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ProofEncryptionType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RenewTargetType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RenewingType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.SecondaryParametersType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.SignChallengeType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.UseKeyType;
import com.sun.xml.ws.security.trust.impl.wssx.elements.AllowPostdatingImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.BinaryExchangeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.CancelTargetImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.DelegateToImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.EncryptionImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.OnBehalfOfImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ParticipantsImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ProofEncryptionImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RenewTargetImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RenewingImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.SecondaryParametersImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.SignChallengeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.UseKeyImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSecurityTokenImpl
extends RequestSecurityTokenType
implements RequestSecurityToken {
    private Claims claims = null;
    private Participants participants = null;
    private URI tokenType = null;
    private URI requestType = null;
    private long keySize = 0L;
    private URI keyType = null;
    private URI computedKeyAlgorithm = null;
    private URI signWith = null;
    private URI encryptWith = null;
    private URI authenticationType = null;
    private URI signatureAlgorithm = null;
    private URI encryptionAlgorithm = null;
    private URI canonAlgorithm = null;
    private Lifetime lifetime = null;
    private Entropy entropy = null;
    private AppliesTo appliesTo = null;
    private OnBehalfOf obo = null;
    private SignChallenge signChallenge = null;
    private Encryption encryption = null;
    private UseKey useKey = null;
    private DelegateTo delegateTo = null;
    private RenewTarget renewTarget = null;
    private CancelTarget cancelTarget = null;
    private AllowPostdating apd = null;
    private BinaryExchange binaryExchange = null;
    private Issuer issuer = null;
    private Renewing renewable = null;
    private ProofEncryption proofEncryption = null;
    private boolean forwardable = true;
    private boolean delegatable = false;
    private Policy policy = null;
    private PolicyReference policyRef = null;
    private SecondaryParameters sp = null;
    private List<Object> extendedElements = new ArrayList<Object>();

    public RequestSecurityTokenImpl() {
        this.setRequestType(URI.create(WSTrustVersion.WS_TRUST_13.getIssueRequestTypeURI()));
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType, URI context, AppliesTo scopes, Claims claims, Entropy entropy, Lifetime lt, URI algorithm) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
        if (context != null) {
            this.setContext(context.toString());
        }
        if (scopes != null) {
            this.setAppliesTo(scopes);
        }
        if (claims != null) {
            this.setClaims(claims);
        }
        if (entropy != null) {
            this.setEntropy(entropy);
        }
        if (lt != null) {
            this.setLifetime(lt);
        }
        if (algorithm != null) {
            this.setComputedKeyAlgorithm(algorithm);
        }
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType, URI context, RenewTarget target, AllowPostdating apd, Renewing renewingInfo) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
        if (context != null) {
            this.setContext(context.toString());
        }
        if (context != null) {
            this.setContext(context.toString());
        }
        if (target != null) {
            this.setRenewTarget(target);
        }
        if (apd != null) {
            this.setAllowPostdating(apd);
        }
        if (renewingInfo != null) {
            this.setRenewable(renewingInfo);
        }
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType, CancelTarget cancel) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
        this.setCancelTarget(cancel);
    }

    @Override
    public String getContext() {
        return super.getContext();
    }

    @Override
    public void setClaims(Claims claims) {
        this.claims = claims;
        JAXBElement<ClaimsType> cElement = new ObjectFactory().createClaims((ClaimsType)((Object)claims));
        this.getAny().add(cElement);
    }

    @Override
    public Claims getClaims() {
        return this.claims;
    }

    public void setCancelTarget(CancelTarget cTarget) {
        this.cancelTarget = cTarget;
        JAXBElement<CancelTargetType> ctElement = new ObjectFactory().createCancelTarget((CancelTargetType)((Object)cTarget));
        this.getAny().add(ctElement);
    }

    @Override
    public CancelTarget getCancelTarget() {
        return this.cancelTarget;
    }

    public void setRenewTarget(RenewTarget target) {
        this.renewTarget = target;
        JAXBElement<RenewTargetType> rElement = new ObjectFactory().createRenewTarget((RenewTargetType)((Object)target));
        this.getAny().add(rElement);
    }

    @Override
    public RenewTarget getRenewTarget() {
        return this.renewTarget;
    }

    @Override
    public void setParticipants(Participants participants) {
        this.participants = participants;
        JAXBElement<ParticipantsType> rElement = new ObjectFactory().createParticipants((ParticipantsType)((Object)participants));
        this.getAny().add(rElement);
    }

    @Override
    public Participants getParticipants() {
        return this.participants;
    }

    @Override
    public URI getTokenType() {
        return this.tokenType;
    }

    @Override
    public void setTokenType(URI tokenType) {
        if (tokenType != null) {
            this.tokenType = tokenType;
            JAXBElement<String> ttElement = new ObjectFactory().createTokenType(tokenType.toString());
            this.getAny().add(ttElement);
        }
    }

    @Override
    public URI getRequestType() {
        return this.requestType;
    }

    @Override
    public void setRequestType(URI requestType) {
        if (requestType == null) {
            throw new RuntimeException("RequestType cannot be null");
        }
        String rtString = requestType.toString();
        if (!(rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getIssueRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getCancelRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getKeyExchangeRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getRenewRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getValidateRequestTypeURI()))) {
            throw new RuntimeException("Invalid Request Type specified");
        }
        this.requestType = requestType;
        JAXBElement<String> rtElement = new ObjectFactory().createRequestType(rtString);
        this.getAny().add(rtElement);
    }

    @Override
    public Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        JAXBElement<LifetimeType> ltElement = new ObjectFactory().createLifetime((LifetimeType)((Object)lifetime));
        this.getAny().add(ltElement);
    }

    @Override
    public SecondaryParameters getSecondaryParameters() {
        return this.sp;
    }

    @Override
    public void setSecondaryParameters(SecondaryParameters sp) {
        this.sp = sp;
        JAXBElement<SecondaryParametersType> spElement = new ObjectFactory().createSecondaryParameters((SecondaryParametersType)((Object)sp));
        this.getAny().add(spElement);
    }

    @Override
    public Entropy getEntropy() {
        return this.entropy;
    }

    @Override
    public void setEntropy(Entropy entropy) {
        this.entropy = entropy;
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)((Object)entropy));
        this.getAny().add(etElement);
    }

    @Override
    public void setAppliesTo(AppliesTo appliesTo) {
        this.getAny().add(appliesTo);
        this.appliesTo = appliesTo;
    }

    @Override
    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    @Override
    public void setOnBehalfOf(OnBehalfOf onBehalfOf) {
        this.obo = onBehalfOf;
    }

    @Override
    public OnBehalfOf getOnBehalfOf() {
        return this.obo;
    }

    @Override
    public void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    @Override
    public Issuer getIssuer() {
        return this.issuer;
    }

    @Override
    public void setRenewable(Renewing renew) {
        this.renewable = renew;
        JAXBElement<RenewingType> renewType = new ObjectFactory().createRenewing((RenewingType)((Object)renew));
        this.getAny().add(renewType);
    }

    @Override
    public Renewing getRenewable() {
        return this.renewable;
    }

    @Override
    public void setSignChallenge(SignChallenge challenge) {
        this.signChallenge = challenge;
        JAXBElement<SignChallengeType> challengeType = new ObjectFactory().createSignChallenge((SignChallengeType)((Object)challenge));
        this.getAny().add(challengeType);
    }

    @Override
    public SignChallenge getSignChallenge() {
        return this.signChallenge;
    }

    @Override
    public void setBinaryExchange(BinaryExchange exchange) {
        this.binaryExchange = exchange;
        JAXBElement<BinaryExchangeType> exchangeType = new ObjectFactory().createBinaryExchange((BinaryExchangeType)((Object)exchange));
        this.getAny().add(exchangeType);
    }

    @Override
    public BinaryExchange getBinaryExchange() {
        return this.binaryExchange;
    }

    @Override
    public void setAuthenticationType(URI uri) {
        this.authenticationType = uri;
        JAXBElement<String> atElement = new ObjectFactory().createAuthenticationType(uri.toString());
        this.getAny().add(atElement);
    }

    @Override
    public URI getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    public void setKeyType(URI keytype) throws WSTrustException {
        this.keyType = keytype;
        JAXBElement<String> ktElement = new ObjectFactory().createKeyType(this.keyType.toString());
        this.getAny().add(ktElement);
    }

    @Override
    public URI getKeyType() {
        return this.keyType;
    }

    @Override
    public void setKeySize(long size) {
        this.keySize = size;
        JAXBElement<Long> ksElement = new ObjectFactory().createKeySize(size);
        this.getAny().add(ksElement);
    }

    @Override
    public long getKeySize() {
        return this.keySize;
    }

    @Override
    public void setSignatureAlgorithm(URI algorithm) {
        this.signatureAlgorithm = algorithm;
        JAXBElement<String> signElement = new ObjectFactory().createSignatureAlgorithm(algorithm.toString());
        this.getAny().add(signElement);
    }

    @Override
    public URI getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public void setEncryptionAlgorithm(URI algorithm) {
        this.encryptionAlgorithm = algorithm;
        JAXBElement<String> encElement = new ObjectFactory().createEncryptionAlgorithm(algorithm.toString());
        this.getAny().add(encElement);
    }

    @Override
    public URI getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public void setCanonicalizationAlgorithm(URI algorithm) {
        this.canonAlgorithm = algorithm;
        JAXBElement<String> canonElement = new ObjectFactory().createCanonicalizationAlgorithm(algorithm.toString());
        this.getAny().add(canonElement);
    }

    @Override
    public URI getCanonicalizationAlgorithm() {
        return this.canonAlgorithm;
    }

    @Override
    public void setUseKey(UseKey useKey) {
        this.useKey = useKey;
        JAXBElement<UseKeyType> ukElement = new ObjectFactory().createUseKey((UseKeyType)((Object)useKey));
        this.getAny().add(ukElement);
    }

    @Override
    public UseKey getUseKey() {
        return this.useKey;
    }

    @Override
    public void setProofEncryption(ProofEncryption proofEncryption) {
        this.proofEncryption = proofEncryption;
        JAXBElement<ProofEncryptionType> proofElement = new ObjectFactory().createProofEncryption((ProofEncryptionType)((Object)proofEncryption));
        this.getAny().add(proofElement);
    }

    @Override
    public ProofEncryption getProofEncryption() {
        return this.proofEncryption;
    }

    @Override
    public void setComputedKeyAlgorithm(URI algorithm) {
        if (algorithm != null) {
            String ckaString = algorithm.toString();
            if (!ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getCKHASHalgorithmURI()) && !ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getCKPSHA1algorithmURI())) {
                throw new RuntimeException("Invalid Computed Key Algorithm specified");
            }
            this.computedKeyAlgorithm = algorithm;
            JAXBElement<String> ckaElement = new ObjectFactory().createComputedKeyAlgorithm(ckaString);
            this.getAny().add(ckaElement);
        }
    }

    @Override
    public URI getComputedKeyAlgorithm() {
        return this.computedKeyAlgorithm;
    }

    @Override
    public void setEncryption(Encryption enc) {
        this.encryption = enc;
        JAXBElement<EncryptionType> encElement = new ObjectFactory().createEncryption((EncryptionType)((Object)enc));
        this.getAny().add(encElement);
    }

    @Override
    public Encryption getEncryption() {
        return this.encryption;
    }

    @Override
    public void setSignWith(URI algorithm) {
        this.signWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createSignWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    @Override
    public URI getSignWith() {
        return this.signWith;
    }

    @Override
    public void setEncryptWith(URI algorithm) {
        this.encryptWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createEncryptWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    @Override
    public URI getEncryptWith() {
        return this.encryptWith;
    }

    @Override
    public void setDelegateTo(DelegateTo to) {
        this.delegateTo = to;
        JAXBElement<DelegateToType> dtElement = new ObjectFactory().createDelegateTo((DelegateToType)((Object)to));
        this.getAny().add(dtElement);
    }

    @Override
    public DelegateTo getDelegateTo() {
        return this.delegateTo;
    }

    @Override
    public void setForwardable(boolean flag) {
        this.forwardable = flag;
        JAXBElement<Boolean> forward = new ObjectFactory().createForwardable(flag);
        this.getAny().add(forward);
    }

    @Override
    public boolean getForwardable() {
        return this.forwardable;
    }

    @Override
    public void setDelegatable(boolean flag) {
        this.delegatable = flag;
        JAXBElement<Boolean> del = new ObjectFactory().createDelegatable(flag);
        this.getAny().add(del);
    }

    @Override
    public boolean getDelegatable() {
        return this.delegatable;
    }

    @Override
    public void setPolicy(Policy policy) {
        this.policy = policy;
        this.getAny().add(policy);
    }

    @Override
    public Policy getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicyReference(PolicyReference policyRef) {
        this.policyRef = policyRef;
        this.getAny().add(policyRef);
    }

    @Override
    public PolicyReference getPolicyReference() {
        return this.policyRef;
    }

    @Override
    public AllowPostdating getAllowPostdating() {
        return this.apd;
    }

    @Override
    public void setAllowPostdating(AllowPostdating allowPostdating) {
        this.apd = allowPostdating;
        JAXBElement<AllowPostdatingType> allowPd = new ObjectFactory().createAllowPostdating((AllowPostdatingType)((Object)this.apd));
        this.getAny().add(allowPd);
    }

    public RequestSecurityTokenImpl(RequestSecurityTokenType rstType) throws Exception {
        this.context = rstType.getContext();
        List<Object> list = rstType.getAny();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof AppliesTo) {
                this.setAppliesTo((AppliesTo)list.get(i));
                continue;
            }
            if (list.get(i) instanceof JAXBElement) {
                JAXBElement obj = (JAXBElement)list.get(i);
                String local = obj.getName().getLocalPart();
                if (local.equalsIgnoreCase("RequestType")) {
                    this.setRequestType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("KeySize")) {
                    this.setKeySize((Long)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("KeyType")) {
                    this.setKeyType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("ComputedKeyAlgorithm")) {
                    this.setComputedKeyAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("TokenType")) {
                    this.setTokenType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("AuthenticationType")) {
                    this.setAuthenticationType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("Lifetime")) {
                    LifetimeType ltType = (LifetimeType)obj.getValue();
                    this.setLifetime(new LifetimeImpl(ltType.getCreated(), ltType.getExpires()));
                    continue;
                }
                if (local.equalsIgnoreCase("Entropy")) {
                    EntropyType eType = (EntropyType)obj.getValue();
                    this.setEntropy(new EntropyImpl(eType));
                    continue;
                }
                if (local.equalsIgnoreCase("Forwardable")) {
                    this.setForwardable((Boolean)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("Delegatable")) {
                    this.setDelegatable((Boolean)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("SignWith")) {
                    this.setSignWith(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("EncryptWith")) {
                    this.setEncryptWith(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("SignatureAlgorithm")) {
                    this.setSignatureAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("EncryptionAlgorithm")) {
                    this.setEncryptionAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("CanonicalizationAlgorithm")) {
                    this.setCanonicalizationAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("AllowPostdating")) {
                    this.setAllowPostdating(new AllowPostdatingImpl());
                    continue;
                }
                if (local.equalsIgnoreCase("SignChallenge")) {
                    this.setSignChallenge(new SignChallengeImpl());
                    continue;
                }
                if (local.equalsIgnoreCase("BinaryExchange")) {
                    BinaryExchangeType bcType = (BinaryExchangeType)obj.getValue();
                    this.setBinaryExchange(new BinaryExchangeImpl(bcType));
                    continue;
                }
                if (local.equalsIgnoreCase("Issuer")) continue;
                if (local.equalsIgnoreCase("Claims")) {
                    ClaimsType cType = (ClaimsType)obj.getValue();
                    this.setClaims(new ClaimsImpl(cType));
                    continue;
                }
                if (local.equalsIgnoreCase("Participants")) {
                    ParticipantsType psType = (ParticipantsType)obj.getValue();
                    this.setParticipants(new ParticipantsImpl(psType));
                    continue;
                }
                if (local.equalsIgnoreCase("Renewing")) {
                    this.setRenewable(new RenewingImpl());
                    continue;
                }
                if (local.equalsIgnoreCase("ProofEncryption")) {
                    ProofEncryptionType peType = (ProofEncryptionType)obj.getValue();
                    this.setProofEncryption(new ProofEncryptionImpl(peType));
                    continue;
                }
                if (local.equalsIgnoreCase("Policy")) {
                    this.setPolicy((Policy)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("PolicyReference")) {
                    this.setPolicyReference((PolicyReference)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("AppliesTo")) {
                    this.setAppliesTo((AppliesTo)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("OnBehalfOf")) {
                    OnBehalfOfType oboType = (OnBehalfOfType)obj.getValue();
                    this.setOnBehalfOf(new OnBehalfOfImpl(oboType));
                    continue;
                }
                if (local.equalsIgnoreCase("Encryption")) {
                    EncryptionType encType = (EncryptionType)obj.getValue();
                    this.setEncryption(new EncryptionImpl(encType));
                    continue;
                }
                if (local.equalsIgnoreCase("UseKey")) {
                    UseKeyType ukType = (UseKeyType)obj.getValue();
                    this.setUseKey(new UseKeyImpl(ukType));
                    continue;
                }
                if (local.equalsIgnoreCase("DelegateTo")) {
                    DelegateToType dtType = (DelegateToType)obj.getValue();
                    this.setDelegateTo(new DelegateToImpl(dtType));
                    continue;
                }
                if (local.equalsIgnoreCase("RenewTarget")) {
                    RenewTargetType rtType = (RenewTargetType)obj.getValue();
                    this.setRenewTarget(new RenewTargetImpl(rtType));
                    continue;
                }
                if (local.equalsIgnoreCase("CancelTarget")) {
                    CancelTargetType ctType = (CancelTargetType)obj.getValue();
                    this.setCancelTarget(new CancelTargetImpl(ctType));
                    continue;
                }
                if (local.equalsIgnoreCase("AppliesTo")) {
                    this.setAppliesTo((AppliesTo)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("SecondaryParameters")) {
                    this.setSecondaryParameters(new SecondaryParametersImpl((SecondaryParametersType)obj.getValue()));
                    continue;
                }
                this.getAny().add(list.get(i));
                this.extendedElements.add(list.get(i));
                continue;
            }
            this.getAny().add(list.get(i));
            this.extendedElements.add(list.get(i));
        }
    }

    @Override
    public List<Object> getExtensionElements() {
        return this.extendedElements;
    }
}

