/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.testing;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.rm.RmWsException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.testing.PacketFilter;
import com.sun.xml.ws.rm.runtime.testing.PacketFilteringFeature;
import java.io.IOException;
import javax.xml.ws.WebServiceException;

public class PacketFilteringTube
extends AbstractFilterTubeImpl {
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketFilteringTube.class);
    private final boolean isClientSide;
    private final PacketFilter[] filters;

    public PacketFilteringTube(PacketFilteringTube original, TubeCloner cloner) {
        super(original, cloner);
        this.isClientSide = original.isClientSide;
        this.filters = original.filters;
    }

    public PacketFilteringTube(WsitClientTubeAssemblyContext context) throws RmWsException {
        super(context.getTubelineHead());
        this.isClientSide = true;
        this.filters = this.getFilters(context.getBinding());
    }

    public PacketFilteringTube(WsitServerTubeAssemblyContext context) throws RmWsException {
        super(context.getTubelineHead());
        this.isClientSide = false;
        this.filters = this.getFilters(context.getEndpoint().getBinding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketFilteringTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            PacketFilteringTube packetFilteringTube = new PacketFilteringTube(this, cloner);
            return packetFilteringTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    public void preDestroy() {
        super.preDestroy();
    }

    public NextAction processRequest(Packet request) {
        if (this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (request != null) {
                        request = filter.filterClientRequest(request);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException((Throwable)ex));
            }
            if (request == null) {
                return this.doThrow(new WebServiceException((Throwable)new IOException("Simulated IO error while sending request")));
            }
        }
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        if (!this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (response != null) {
                        response = filter.filterServerResponse(response);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException((Throwable)ex));
            }
        }
        return super.processResponse(response);
    }

    private PacketFilter[] getFilters(WSBinding binding) {
        PacketFilteringFeature pfFeature = binding.getFeature(PacketFilteringFeature.class);
        return pfFeature.getFilters();
    }
}

