/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.AbstractSequence;
import com.sun.xml.ws.rm.runtime.IllegalMessageIdentifierException;
import com.sun.xml.ws.rm.runtime.Sequence;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundSequence
extends AbstractSequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(OutboundSequence.class);
    private final AtomicLong lastMessageId = new AtomicLong(0L);

    public OutboundSequence(String id, long expirationTime) {
        super(id, expirationTime, new LinkedList<Long>());
    }

    @Override
    public long getNextMessageId() throws MessageNumberRolloverException {
        long nextId = this.lastMessageId.incrementAndGet();
        if (nextId > Long.MAX_VALUE) {
            throw LOGGER.logSevereException(new MessageNumberRolloverException(this.getId(), nextId));
        }
        this.unackedIndexes.add(nextId);
        return nextId;
    }

    @Override
    public long getLastMessageId() {
        return this.lastMessageId.longValue();
    }

    @Override
    public void acknowledgeMessageId(long messageId) {
        this.unackedIndexes.remove(messageId);
    }

    @Override
    public void acknowledgeMessageIds(List<Sequence.AckRange> ranges) throws IllegalMessageIdentifierException {
        if (ranges == null || ranges.isEmpty() || this.unackedIndexes.isEmpty()) {
            return;
        }
        if (ranges.size() > 1) {
            Collections.sort(ranges, new Comparator<Sequence.AckRange>(){

                @Override
                public int compare(Sequence.AckRange range1, Sequence.AckRange range2) {
                    if (range1.lower <= range2.lower) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        Iterator unackedIterator = this.unackedIndexes.iterator();
        Iterator<Sequence.AckRange> rangeIterator = ranges.iterator();
        Sequence.AckRange currentRange = rangeIterator.next();
        while (unackedIterator.hasNext()) {
            long unackedIndex = (Long)unackedIterator.next();
            if (unackedIndex >= currentRange.lower && unackedIndex <= currentRange.upper) {
                unackedIterator.remove();
                continue;
            }
            if (!rangeIterator.hasNext()) break;
            currentRange = rangeIterator.next();
        }
    }
}

